/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.integration.invoke;

import com.alipay.sofa.ark.spi.model.Biz;
import com.alipay.sofa.ark.spi.model.BizState;
import com.alipay.sofa.ark.spi.service.ArkInject;
import com.alipay.sofa.ark.spi.service.biz.BizManagerService;
import com.alipay.sofa.runtime.SofaFramework;
import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.ComponentInfo;
import com.alipay.sofa.runtime.spi.component.ComponentManager;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeManager;
import com.alipay.sofa.runtime.spi.log.SofaLogger;
import com.alipay.sofa.runtime.spi.service.ServiceProxy;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import org.aopalliance.intercept.MethodInvocation;

public class DynamicJvmServiceProxyFinder {
    private static DynamicJvmServiceProxyFinder dynamicJvmServiceProxyFinder = new DynamicJvmServiceProxyFinder();
    @ArkInject
    private BizManagerService bizManagerService;

    private DynamicJvmServiceProxyFinder() {
    }

    public static DynamicJvmServiceProxyFinder getDynamicJvmServiceProxyFinder() {
        return dynamicJvmServiceProxyFinder;
    }

    public ServiceProxy findServiceProxy(ClassLoader clientClassloader, Contract contract) {
        String interfaceType = contract.getInterfaceType().getCanonicalName();
        String uniqueId = contract.getUniqueId();
        for (SofaRuntimeManager sofaRuntimeManager : SofaFramework.getRuntimeSet()) {
            ServiceComponent serviceComponent;
            Biz biz;
            if (sofaRuntimeManager.getAppClassLoader().equals(clientClassloader) || (biz = DynamicJvmServiceProxyFinder.getBiz(sofaRuntimeManager)) == null || biz.getBizState() != BizState.ACTIVATED || (serviceComponent = this.findServiceComponent(uniqueId, interfaceType, sofaRuntimeManager.getComponentManager())) == null) continue;
            return new DynamicJvmServiceInvoker(clientClassloader, sofaRuntimeManager.getAppClassLoader(), serviceComponent.getService().getTarget(), contract, biz.getIdentity());
        }
        return null;
    }

    private ServiceComponent findServiceComponent(String uniqueId, String interfaceType, ComponentManager componentManager) {
        Collection<ComponentInfo> components = componentManager.getComponentInfosByType(ServiceComponent.SERVICE_COMPONENT_TYPE);
        for (ComponentInfo c : components) {
            ServiceComponent component = (ServiceComponent)c;
            Service serviceContract = component.getService();
            if (!serviceContract.getInterfaceType().getCanonicalName().equals(interfaceType) || !uniqueId.equals(serviceContract.getUniqueId())) continue;
            return component;
        }
        return null;
    }

    public static Biz getBiz(SofaRuntimeManager sofaRuntimeManager) {
        for (Biz biz : DynamicJvmServiceProxyFinder.getDynamicJvmServiceProxyFinder().bizManagerService.getBizInOrder()) {
            if (!sofaRuntimeManager.getAppClassLoader().equals(biz.getBizClassLoader())) continue;
            return biz;
        }
        return null;
    }

    static class DynamicJvmServiceInvoker
    extends ServiceProxy {
        private Contract contract;
        private Object targetService;
        private String bizIdentity;
        private ThreadLocal<ClassLoader> clientClassloader = new ThreadLocal();
        protected static final String TOSTRING_METHOD = "toString";
        protected static final String EQUALS_METHOD = "equals";
        protected static final String HASHCODE_METHOD = "hashCode";

        public DynamicJvmServiceInvoker(ClassLoader clientClassloader, ClassLoader serviceClassLoader, Object targetService, Contract contract, String bizIdentity) {
            super(serviceClassLoader);
            this.clientClassloader.set(clientClassloader);
            this.targetService = targetService;
            this.contract = contract;
            this.bizIdentity = bizIdentity;
        }

        @Override
        protected Object doInvoke(MethodInvocation invocation) throws Throwable {
            try {
                Method targetMethod = invocation.getMethod();
                Object[] targetArguments = invocation.getArguments();
                SofaLogger.debug(">> Start in Cross App JVM service invoke, the service interface is  - " + this.getInterfaceType(), new Object[0]);
                if (TOSTRING_METHOD.equalsIgnoreCase(targetMethod.getName()) && targetMethod.getParameterTypes().length == 0) {
                    String string = this.targetService.toString();
                    return string;
                }
                if (EQUALS_METHOD.equalsIgnoreCase(targetMethod.getName()) && targetMethod.getParameterTypes().length == 1) {
                    Boolean bl = this.targetService.equals(targetArguments[0]);
                    return bl;
                }
                if (HASHCODE_METHOD.equalsIgnoreCase(targetMethod.getName()) && targetMethod.getParameterTypes().length == 0) {
                    Integer n = this.targetService.hashCode();
                    return n;
                }
                Class<?>[] oldArgumentTypes = targetMethod.getParameterTypes();
                Object[] arguments = (Object[])DynamicJvmServiceInvoker.hessianTransport(targetArguments, null);
                Class[] argumentTypes = (Class[])DynamicJvmServiceInvoker.hessianTransport(oldArgumentTypes, null);
                Method transformMethod = this.getTargetMethod(targetMethod, argumentTypes);
                Object retVal = transformMethod.invoke(this.targetService, arguments);
                Object object = DynamicJvmServiceInvoker.hessianTransport(retVal, this.getClientClassloader());
                return object;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
            finally {
                this.setClientClassloader(null);
            }
        }

        @Override
        protected void doCatch(MethodInvocation invocation, Throwable e, long startTime) {
            SofaLogger.debug(this.getCommonInvocationLog("Exception", invocation, startTime), new Object[0]);
        }

        @Override
        protected void doFinally(MethodInvocation invocation, long startTime) {
            SofaLogger.debug(this.getCommonInvocationLog("Finally", invocation, startTime), new Object[0]);
        }

        private Class getInterfaceType() {
            return this.contract.getInterfaceType();
        }

        public ClassLoader getClientClassloader() {
            return this.clientClassloader.get();
        }

        public void setClientClassloader(ClassLoader clientClassloader) {
            this.clientClassloader.set(clientClassloader);
        }

        private Method getTargetMethod(Method method, Class[] argumentTypes) {
            try {
                return this.targetService.getClass().getMethod(method.getName(), argumentTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(this.targetService + " in " + this.bizIdentity + " don't have the method " + method);
            }
        }

        private static Object hessianTransport(Object source, ClassLoader contextClassLoader) {
            Object target;
            ClassLoader currentContextClassloader = Thread.currentThread().getContextClassLoader();
            try {
                if (contextClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(contextClassLoader);
                }
                SerializerFactory serializerFactory = new SerializerFactory();
                serializerFactory.setAllowNonSerializable(true);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Hessian2Output h2o = new Hessian2Output((OutputStream)bos);
                h2o.setSerializerFactory(serializerFactory);
                h2o.writeObject(source);
                h2o.flush();
                byte[] content = bos.toByteArray();
                Hessian2Input h2i = new Hessian2Input((InputStream)new ByteArrayInputStream(content));
                h2i.setSerializerFactory(serializerFactory);
                target = h2i.readObject();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentContextClassloader);
            }
            return target;
        }
    }
}

