/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.client;

import com.alipay.sofa.runtime.api.client.ExtensionClient;
import com.alipay.sofa.runtime.api.client.param.ExtensionParam;
import com.alipay.sofa.runtime.api.client.param.ExtensionPointParam;
import com.alipay.sofa.runtime.ext.component.ExtensionComponent;
import com.alipay.sofa.runtime.ext.component.ExtensionImpl;
import com.alipay.sofa.runtime.ext.component.ExtensionPointComponent;
import com.alipay.sofa.runtime.ext.component.ExtensionPointImpl;
import com.alipay.sofa.runtime.spi.component.DefaultImplementation;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.util.ComponentNameFactory;
import org.springframework.util.Assert;

public class ExtensionClientImpl
implements ExtensionClient {
    private SofaRuntimeContext sofaRuntimeContext;

    public ExtensionClientImpl(SofaRuntimeContext sofaRuntimeContext) {
        this.sofaRuntimeContext = sofaRuntimeContext;
    }

    @Override
    public void publishExtension(ExtensionParam extensionParam) {
        Assert.notNull((Object)extensionParam, (String)"extensionParam can not be null.");
        Assert.notNull((Object)extensionParam.getElement(), (String)"Extension contribution element can not be null.");
        Assert.notNull((Object)extensionParam.getTargetInstanceName(), (String)"Extension target instance name can not be null.");
        Assert.notNull((Object)extensionParam.getTargetName(), (String)"Extension target name can not be null.");
        ExtensionImpl extension = new ExtensionImpl(null, extensionParam.getTargetName(), extensionParam.getElement(), this.sofaRuntimeContext.getAppClassLoader());
        extension.setTargetComponentName(ComponentNameFactory.createComponentName(ExtensionPointComponent.EXTENSION_POINT_COMPONENT_TYPE, extensionParam.getTargetInstanceName() + "$" + extensionParam.getTargetName()));
        ExtensionComponent extensionComponent = new ExtensionComponent(extension, this.sofaRuntimeContext);
        this.sofaRuntimeContext.getComponentManager().register(extensionComponent);
    }

    @Override
    public void publishExtensionPoint(ExtensionPointParam extensionPointParam) {
        Assert.notNull((Object)extensionPointParam, (String)"extensionPointParam can not be null.");
        Assert.notNull((Object)extensionPointParam.getName(), (String)"Extension point name can not be null.");
        Assert.notNull(extensionPointParam.getContributionClass(), (String)"Extension point contribution can not be null.");
        Assert.notNull((Object)extensionPointParam.getTarget(), (String)"Extension point target can not be null.");
        ExtensionPointImpl extensionPoint = new ExtensionPointImpl(extensionPointParam.getName(), extensionPointParam.getContributionClass());
        DefaultImplementation implementation = new DefaultImplementation(extensionPointParam.getTargetName());
        implementation.setTarget(extensionPointParam.getTarget());
        ExtensionPointComponent extensionPointComponent = new ExtensionPointComponent(extensionPoint, this.sofaRuntimeContext, implementation);
        this.sofaRuntimeContext.getComponentManager().register(extensionPointComponent);
    }
}

