/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.xmap;

import com.alipay.sofa.common.xmap.Context;
import com.alipay.sofa.common.xmap.Path;
import com.alipay.sofa.common.xmap.Sorter;
import com.alipay.sofa.common.xmap.XAnnotatedMember;
import com.alipay.sofa.common.xmap.XMap;
import com.alipay.sofa.common.xmap.annotation.XObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAnnotatedObject {
    public final XMap xmap;
    public final Class<?> klass;
    public final Path path;
    final List<XAnnotatedMember> members;
    Sorter sorter;
    Sorter deSorter;

    public XAnnotatedObject(XMap xmap, Class<?> klass, XObject xob) {
        this.xmap = xmap;
        this.klass = klass;
        this.path = new Path(xob.value());
        this.members = new ArrayList<XAnnotatedMember>();
        String[] order = xob.order();
        if (order.length > 0) {
            this.sorter = new Sorter(order);
        }
    }

    public void addMember(XAnnotatedMember member) {
        this.members.add(member);
    }

    public Path getPath() {
        return this.path;
    }

    public Object newInstance(Context ctx, Element element) throws Exception {
        Object ob = this.klass.newInstance();
        ctx.push(ob);
        if (this.sorter != null) {
            Collections.sort(this.members, this.sorter);
            this.deSorter = this.sorter;
            this.sorter = null;
        }
        for (XAnnotatedMember member : this.members) {
            member.process(ctx, element);
        }
        return ctx.pop();
    }

    public Object newInstance(Context ctx, Map<String, Object> map, String keyPrefix) throws Exception {
        Object ob = this.klass.newInstance();
        ctx.push(ob);
        for (XAnnotatedMember member : this.members) {
            member.process(ctx, map, keyPrefix);
        }
        return ctx.pop();
    }

    public void decode(Object instance, Node base, Document document, List<String> filters) throws Exception {
        Node node = base;
        String name = this.path.path;
        if (this.sorter != null) {
            this.deSorter = this.sorter;
        }
        if (this.deSorter != null) {
            Collections.sort(this.members, this.deSorter);
            this.deSorter = null;
        }
        if (name != null && name.length() > 0) {
            Element element = document.createElement(name);
            node = node.appendChild(element);
        }
        for (XAnnotatedMember annotatedMember : this.members) {
            annotatedMember.decode(instance, node, document, filters);
        }
    }
}

