/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.xmap;

import com.alipay.sofa.common.xmap.AttributeValueVisitor;
import com.alipay.sofa.common.xmap.Context;
import com.alipay.sofa.common.xmap.DOMHelper;
import com.alipay.sofa.common.xmap.ElementValueVisitor;
import com.alipay.sofa.common.xmap.ElementVisitor;
import com.alipay.sofa.common.xmap.Path;
import com.alipay.sofa.common.xmap.PrimitiveArrays;
import com.alipay.sofa.common.xmap.XAnnotatedMember;
import com.alipay.sofa.common.xmap.XGetter;
import com.alipay.sofa.common.xmap.XMap;
import com.alipay.sofa.common.xmap.XSetter;
import com.alipay.sofa.common.xmap.annotation.XNodeList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAnnotatedList
extends XAnnotatedMember {
    protected static final ElementVisitor elementListVisitor = new ElementVisitor();
    protected static final ElementValueVisitor elementVisitor = new ElementValueVisitor();
    protected static final AttributeValueVisitor attributeVisitor = new AttributeValueVisitor();
    public Class<?> componentType;

    protected XAnnotatedList(XMap xmap, XSetter setter, XGetter getter) {
        super(xmap, setter, getter);
    }

    public XAnnotatedList(XMap xmap, XSetter setter, XGetter getter, XNodeList anno) {
        super(xmap, setter, getter);
        this.path = new Path(anno.value());
        this.trim = anno.trim();
        this.type = anno.type();
        this.cdata = anno.cdata();
        this.componentType = anno.componentType();
        this.valueFactory = xmap.getValueFactory(this.componentType);
        this.xao = xmap.register(this.componentType);
    }

    @Override
    protected Object getValue(Context ctx, Element base) throws Exception {
        ArrayList<Object> values = new ArrayList<Object>();
        if (this.xao != null) {
            DOMHelper.visitNodes(ctx, this, base, this.path, elementListVisitor, values);
        } else if (this.path.attribute != null) {
            DOMHelper.visitNodes(ctx, this, base, this.path, attributeVisitor, values);
        } else {
            DOMHelper.visitNodes(ctx, this, base, this.path, elementVisitor, values);
        }
        if (this.type != ArrayList.class) {
            if (this.type.isArray()) {
                if (this.componentType.isPrimitive()) {
                    return PrimitiveArrays.toPrimitiveArray(values, this.componentType);
                }
                return values.toArray((Object[])Array.newInstance(this.componentType, values.size()));
            }
            Collection col = (Collection)this.type.newInstance();
            col.addAll(values);
            return col;
        }
        return values;
    }

    @Override
    public void decode(Object instance, Node base, Document document, List<String> filters) throws Exception {
        int i;
        if (!this.isFilter(filters)) {
            return;
        }
        ArrayList<Object> col = null;
        if (Collection.class.isAssignableFrom(this.type)) {
            col = (ArrayList<Object>)this.getter.getValue(instance);
        } else if (this.type.isArray()) {
            col = new ArrayList<Object>();
            Object obj = this.getter.getValue(instance);
            int length = Array.getLength(obj);
            for (i = 0; i < length; ++i) {
                col.add(Array.get(obj, i));
            }
        } else {
            throw new Exception("@XNodeList " + base.getNodeName() + " 'type' only support Collection ande Array type");
        }
        Node node = base;
        int len = this.path.segments.length - 1;
        for (i = 0; i < len; ++i) {
            Node n = DOMHelper.getElementNode(node, this.path.segments[i]);
            if (n == null) {
                Element element = document.createElement(this.path.segments[i]);
                node = node.appendChild(element);
                continue;
            }
            node = n;
        }
        String name = this.path.segments[len];
        Node lastParentNode = node;
        for (Object e : col) {
            String value;
            Element element = document.createElement(name);
            node = lastParentNode.appendChild(element);
            if (this.xao != null) {
                this.xao.decode(e, node, document, filters);
                continue;
            }
            String string = value = e == null ? "" : e.toString();
            if (this.path.attribute != null && this.path.attribute.length() > 0) {
                Attr attr = document.createAttribute(this.path.attribute);
                attr.setNodeValue(value);
                ((Element)node).setAttributeNode(attr);
                continue;
            }
            if (this.cdata) {
                CDATASection cdataSection = document.createCDATASection(value);
                node.appendChild(cdataSection);
                continue;
            }
            node.setTextContent(value);
        }
    }
}

