/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util;

import com.alipay.api.AlipayApiErrorEnum;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.encrypt.Encrypt;
import com.alipay.api.internal.util.encrypt.impl.AesEncrypt;
import com.alipay.api.internal.util.encrypt.impl.AesEncryptV2;
import com.alipay.api.internal.util.encrypt.impl.SM4Encrypt;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlipayEncrypt {
    private static Map<String, Encrypt> encryptManager = new HashMap<String, Encrypt>();

    public static String encryptContent(String content, String encryptType, String encryptKey, String charset) throws AlipayApiException {
        Encrypt encrypt = encryptManager.get(encryptType);
        if (encrypt == null) {
            if ("SM4".equals(encryptType)) {
                encrypt = new SM4Encrypt();
            } else {
                throw new AlipayApiException(AlipayApiErrorEnum.ENCRYPT_TYPE_ERROR.getErrMsg() + encryptType);
            }
        }
        return encrypt.encrypt(content, encryptKey, charset);
    }

    public static String decryptContent(String content, String encryptType, String encryptKey, String charset) throws AlipayApiException {
        Encrypt encrypt = encryptManager.get(encryptType);
        if (encrypt == null) {
            if ("SM4".equals(encryptType)) {
                encrypt = new SM4Encrypt();
            } else {
                throw new AlipayApiException(AlipayApiErrorEnum.ENCRYPT_TYPE_ERROR.getErrMsg() + encryptType);
            }
        }
        return encrypt.decrypt(content, encryptKey, charset);
    }

    public static Map<String, Encrypt> getEncryptManager() {
        return encryptManager;
    }

    public static void putEncryptManager(String encryptType, Encrypt encrypt) {
        encryptManager.put(encryptType, encrypt);
    }

    static {
        encryptManager.put("AES", new AesEncrypt());
        encryptManager.put("AES_V2", new AesEncryptV2());
    }
}

