/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api;

import com.alipay.api.internal.util.AlipayUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileItem {
    private String fileName;
    private String mimeType;
    private byte[] content;
    private File file;

    public FileItem(File file) {
        this.file = file;
    }

    public FileItem(String filePath) {
        this(new File(filePath));
    }

    public FileItem(String fileName, byte[] content) {
        this.fileName = fileName;
        this.content = content;
    }

    public FileItem(String fileName, byte[] content, String mimeType) {
        this(fileName, content);
        this.mimeType = mimeType;
    }

    public String getFileName() {
        if (this.fileName == null && this.file != null && this.file.exists()) {
            this.fileName = this.file.getName();
        }
        return this.fileName;
    }

    public String getMimeType() throws IOException {
        if (this.mimeType == null) {
            this.mimeType = AlipayUtils.getMimeType(this.getFileHeader());
        }
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getFileHeader() throws IOException {
        FileInputStream in;
        block3: {
            byte[] byArray;
            if (this.content != null || this.file == null || !this.file.exists()) return this.content;
            in = null;
            try {
                in = new FileInputStream(this.file);
                byte[] bufferByte = new byte[16];
                if (((InputStream)in).read(bufferByte) == -1) break block3;
                byArray = bufferByte;
                Object var5_4 = null;
                if (in == null) return byArray;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (in == null) throw throwable;
                ((InputStream)in).close();
                throw throwable;
            }
            ((InputStream)in).close();
            return byArray;
        }
        Object var5_5 = null;
        if (in == null) return null;
        ((InputStream)in).close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getContent() throws IOException {
        if (this.content == null && this.file != null && this.file.exists()) {
            FileInputStream in;
            block7: {
                in = null;
                ByteArrayOutputStream out = null;
                try {
                    int ch;
                    in = new FileInputStream(this.file);
                    out = new ByteArrayOutputStream();
                    while ((ch = ((InputStream)in).read()) != -1) {
                        out.write(ch);
                    }
                    this.content = out.toByteArray();
                    Object var5_4 = null;
                    if (out == null) break block7;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (out != null) {
                        out.close();
                    }
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    throw throwable;
                }
                out.close();
            }
            if (in != null) {
                ((InputStream)in).close();
            }
        }
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeFileContent(OutputStream out) throws IOException {
        if (out == null) {
            return;
        }
        if (this.content != null) {
            out.write(this.content);
            return;
        }
        if (this.file == null || !this.file.exists()) throw new IOException("\u6587\u4ef6\u5b57\u8282\u6d41\u6216\u6587\u4ef6\u4e3a\u7a7a");
        FileInputStream in = null;
        try {
            int bytes;
            in = new FileInputStream(this.file);
            byte[] bufferByte = new byte[0x100000];
            while ((bytes = ((InputStream)in).read(bufferByte)) != -1) {
                out.write(bufferByte, 0, bytes);
            }
            Object var6_5 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (in == null) throw throwable;
            ((InputStream)in).close();
            throw throwable;
        }
        ((InputStream)in).close();
    }

    public long fileContentLength() {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.file != null && this.file.exists()) {
            return this.file.length();
        }
        return 0L;
    }
}

