/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.model.attribute;

import com.alipay.service.schema.exception.SchemaException;
import com.alipay.service.schema.model.attribute.Attribute;
import com.alipay.service.schema.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexAttribute
extends Attribute {
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    @Override
    public Element toElement() throws SchemaException {
        this.checkAttribute();
        Element attributeNode = XmlUtils.createRootElement("attribute");
        attributeNode.addAttribute("id", this.getId());
        attributeNode.addAttribute("name", this.getName());
        attributeNode.addAttribute("type", this.getType().getType());
        attributeNode.addAttribute("valueType", this.getValueType().getCode());
        Element attributesElm = XmlUtils.appendElement(attributeNode, "attributes");
        for (Attribute attribute : this.attributes) {
            Element attributeElm = XmlUtils.appendElement(attributesElm, "attribute");
            attributeElm.addAttribute("id", attribute.getId());
            attributeElm.addAttribute("name", attribute.getName());
            attributeElm.addAttribute("type", attribute.getType().getType());
            attributeElm.addAttribute("valueType", attribute.getValueType().getCode());
            this.appendRulesElement(attributeElm, attribute.getRules(), attribute.getId());
            this.appendOptionsElement(attributeElm, attribute.getOptions(), attribute.getId());
            this.appendAttributeValues(attribute, attributeElm);
        }
        this.appendRulesElement(attributeNode, this.getRules(), this.getId());
        return attributeNode;
    }

    @Override
    public Element toValueElement() throws SchemaException {
        this.checkAttribute();
        Element attributeNode = XmlUtils.createRootElement("attribute");
        attributeNode.addAttribute("id", this.getId());
        attributeNode.addAttribute("name", this.getName());
        attributeNode.addAttribute("type", this.getType().getType());
        attributeNode.addAttribute("valueType", this.getValueType().getCode());
        Element attributesElm = XmlUtils.appendElement(attributeNode, "attributes");
        for (Attribute attribute : this.attributes) {
            Element attributeElm = XmlUtils.appendElement(attributesElm, "attribute");
            attributeElm.addAttribute("id", attribute.getId());
            attributeElm.addAttribute("name", attribute.getName());
            attributeElm.addAttribute("type", attribute.getType().getType());
            attributeElm.addAttribute("valueType", attribute.getValueType().getCode());
            this.appendAttributeValues(attribute, attributeElm);
        }
        return attributeNode;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }
}

