/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.kms.aliyun.http;

import com.alipay.api.kms.aliyun.exceptions.ClientException;
import com.alipay.api.kms.aliyun.http.FormatType;
import com.alipay.api.kms.aliyun.http.MethodType;
import com.alipay.api.kms.aliyun.utils.Base64Utils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessage {
    protected static final String CONTENT_TYPE = "Content-Type";
    protected static final String CONTENT_MD5 = "Content-MD5";
    protected static final String CONTENT_LENGTH = "Content-Length";
    protected FormatType httpContentType = null;
    protected byte[] httpContent = null;
    protected String encoding = null;
    protected Map<String, String> headers = new HashMap<String, String>();
    protected Integer connectTimeout = null;
    protected Integer readTimeout = null;
    private String url = null;
    private MethodType method = null;
    protected boolean ignoreSSLCerts = false;
    private KeyManager[] keyManagers = null;
    private X509TrustManager[] x509TrustManagers = null;

    public HttpMessage(String strUrl) {
        this.url = strUrl;
    }

    public HttpMessage() {
    }

    public FormatType getHttpContentType() {
        return this.httpContentType;
    }

    public void setHttpContentType(FormatType httpContentType) {
        this.httpContentType = httpContentType;
    }

    public byte[] getHttpContent() {
        return this.httpContent;
    }

    public String getHttpContentString() throws ClientException {
        String stringContent = "";
        if (this.httpContent != null) {
            try {
                stringContent = this.encoding == null ? new String(this.httpContent) : new String(this.httpContent, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ClientException("UnsupportedEncoding", "Can not parse response due to unsupported encoding.");
            }
        }
        return stringContent;
    }

    public void setHttpContent(byte[] httpContent, String encoding, FormatType format) throws NoSuchAlgorithmException {
        this.httpContent = httpContent;
        if (null == httpContent) {
            this.headers.remove(CONTENT_MD5);
            this.headers.put(CONTENT_LENGTH, "0");
            this.headers.remove(CONTENT_TYPE);
            this.httpContentType = null;
            this.httpContent = null;
            this.encoding = null;
            return;
        }
        if (this.getMethod() != null && !this.getMethod().hasContent()) {
            httpContent = new byte[]{};
        }
        this.httpContent = httpContent;
        this.encoding = encoding;
        String contentLen = String.valueOf(httpContent.length);
        String strMd5 = HttpMessage.md5Sum(httpContent);
        this.headers.put(CONTENT_MD5, strMd5);
        this.headers.put(CONTENT_LENGTH, contentLen);
        if (null != format) {
            this.headers.put(CONTENT_TYPE, FormatType.mapFormatToAccept(format));
        }
    }

    public static String md5Sum(byte[] buff) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] messageDigest = md.digest(buff);
        return Base64Utils.encode(messageDigest);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String getHeaderValue(String name) {
        return this.headers.get(name);
    }

    public void putHeaderParameter(String name, String value) {
        if (null != name && null != value) {
            this.headers.put(name, value);
        }
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public void setMethod(MethodType method) {
        this.method = method;
    }

    public boolean isIgnoreSSLCerts() {
        return this.ignoreSSLCerts;
    }

    public void setIgnoreSSLCerts(boolean ignoreSSLCerts) {
        this.ignoreSSLCerts = ignoreSSLCerts;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public X509TrustManager[] getX509TrustManagers() {
        return this.x509TrustManagers;
    }

    public void setX509TrustManagers(X509TrustManager[] x509TrustManagers) {
        this.x509TrustManagers = x509TrustManagers;
    }
}

