/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util.encrypt.impl;

import com.alipay.api.AlipayApiErrorEnum;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.codec.Base64;
import com.alipay.api.internal.util.encrypt.Encrypt;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4Encrypt
implements Encrypt {
    public static final String PROVIDER_NAME = "BC";
    private static final Charset CIPHER_CHARSET;
    private static final String SLASH = "/";
    private static final String ALG = "SM4";
    private static final String MODE = "GCM";
    private static final String PADDING = "NoPadding";
    private static final int IV_SIZE = 16;
    private final String fullCipherName;

    public SM4Encrypt() {
        this.fullCipherName = "SM4/GCM/NoPadding";
    }

    public String encrypt(String content, String key, String charset) throws AlipayApiException {
        try {
            Cipher cipher = Cipher.getInstance(this.fullCipherName, PROVIDER_NAME);
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivParams = new IvParameterSpec(iv);
            cipher.init(1, (Key)new SecretKeySpec(Base64.decodeBase64(key.getBytes()), ALG), ivParams);
            byte[] encryptedText = cipher.doFinal(content.getBytes(charset));
            byte[] ivAndEncryptedText = new byte[16 + encryptedText.length];
            System.arraycopy(iv, 0, ivAndEncryptedText, 0, 16);
            System.arraycopy(encryptedText, 0, ivAndEncryptedText, 16, encryptedText.length);
            return new String(Base64.encodeBase64(ivAndEncryptedText), CIPHER_CHARSET);
        }
        catch (Exception e) {
            throw new AlipayApiException(String.format(AlipayApiErrorEnum.ENCRYPT_SM4_ERROR.getErrMsg(), content, charset), (Throwable)e);
        }
    }

    public String decrypt(String content, String aesKey, String charset) throws AlipayApiException {
        try {
            byte[] ivAndEncryptedText = Base64.decodeBase64(content.getBytes(CIPHER_CHARSET));
            Cipher cipher = Cipher.getInstance(this.fullCipherName, PROVIDER_NAME);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ivAndEncryptedText, 0, 16);
            cipher.init(2, (Key)new SecretKeySpec(Base64.decodeBase64(aesKey.getBytes()), ALG), ivParameterSpec);
            byte[] cleanBytes = cipher.doFinal(ivAndEncryptedText, 16, ivAndEncryptedText.length - 16);
            return new String(cleanBytes, charset);
        }
        catch (Exception e) {
            throw new AlipayApiException(String.format(AlipayApiErrorEnum.DECRYPT_SM4_ERROR.getErrMsg(), content, charset), (Throwable)e);
        }
    }

    public static String getAlg() {
        return ALG;
    }

    public String getMode() {
        return MODE;
    }

    public String getPadding() {
        return PADDING;
    }

    public String getFullCipherName() {
        return this.fullCipherName;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CIPHER_CHARSET = Charset.forName("UTF-8");
    }
}

