/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.model.attribute;

import com.alipay.service.schema.exception.SchemaException;
import com.alipay.service.schema.model.attribute.Attribute;
import com.alipay.service.schema.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiAttribute
extends Attribute {
    private List<String> values = new ArrayList<String>();

    @Override
    public Element toElement() throws SchemaException {
        this.checkAttribute();
        Element attributeNode = XmlUtils.createRootElement("attribute");
        attributeNode.addAttribute("id", this.getId());
        attributeNode.addAttribute("name", this.getName());
        attributeNode.addAttribute("type", this.getType().getType());
        attributeNode.addAttribute("valueType", this.getValueType().getCode());
        Element valuesNode = XmlUtils.appendElement(attributeNode, "values");
        if (this.values != null && this.values.size() > 0) {
            for (String value : this.values) {
                Element valueNode = XmlUtils.appendElement(valuesNode, "value");
                valueNode.setText(value);
            }
        }
        this.appendRulesElement(attributeNode, this.getRules(), this.getId());
        this.appendOptionsElement(attributeNode, this.getOptions(), this.getId());
        return attributeNode;
    }

    @Override
    public Element toValueElement() throws SchemaException {
        this.checkAttribute();
        Element attributeNode = XmlUtils.createRootElement("attribute");
        attributeNode.addAttribute("id", this.getId());
        attributeNode.addAttribute("name", this.getName());
        attributeNode.addAttribute("type", this.getType().getType());
        attributeNode.addAttribute("valueType", this.getValueType().getCode());
        Element valuesNode = XmlUtils.appendElement(attributeNode, "values");
        if (this.values != null && this.values.size() > 0) {
            for (String value : this.values) {
                Element valueNode = XmlUtils.appendElement(valuesNode, "value");
                valueNode.setText(value);
            }
        }
        return attributeNode;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

