/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.kms.aliyun.credentials.provider;

import com.alipay.api.kms.aliyun.credentials.EcsRamRoleCredentials;
import com.alipay.api.kms.aliyun.credentials.ICredentials;
import com.alipay.api.kms.aliyun.credentials.exceptions.CredentialsException;
import com.alipay.api.kms.aliyun.credentials.provider.ECSMetadataServiceCredentialFetcher;
import com.alipay.api.kms.aliyun.credentials.provider.ICredentialsProvider;

public class EcsRamRoleCredentialsProvider
implements ICredentialsProvider {
    private static final int MAX_ECS_METADATA_FETCH_RETRY_TIMES = 3;
    private final String roleName;
    private EcsRamRoleCredentials credentials = null;
    private ECSMetadataServiceCredentialFetcher fetcher;

    public EcsRamRoleCredentialsProvider(String roleName) {
        if (null == roleName) {
            throw new NullPointerException("You must specifiy a valid role name.");
        }
        this.roleName = roleName;
        this.fetcher = new ECSMetadataServiceCredentialFetcher();
        this.fetcher.setRoleName(this.roleName);
    }

    public EcsRamRoleCredentialsProvider withFetcher(ECSMetadataServiceCredentialFetcher fetcher) {
        this.fetcher = fetcher;
        this.fetcher.setRoleName(this.roleName);
        return this;
    }

    public ICredentials getCredentials() throws CredentialsException {
        if (this.credentials == null || this.credentials.isExpired()) {
            this.credentials = this.fetcher.fetch(3);
        } else if (this.credentials.willSoonExpire() && this.credentials.shouldRefresh()) {
            try {
                this.credentials = this.fetcher.fetch();
            }
            catch (CredentialsException e) {
                this.credentials.setLastFailedRefreshTime();
            }
        }
        return this.credentials;
    }
}

