/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api.internal.util.asymmetric;

import com.alipay.api.AlipayApiErrorEnum;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.asymmetric.IAsymmetricEncryptor;
import com.alipay.api.internal.util.asymmetric.RSA2Encryptor;
import com.alipay.api.internal.util.asymmetric.RSAEncryptor;
import com.alipay.api.internal.util.asymmetric.SM2Encryptor;

public class AsymmetricManager {
    public static IAsymmetricEncryptor getByName(String type) throws AlipayApiException {
        if ("RSA".equals(type)) {
            return new RSAEncryptor();
        }
        if ("RSA2".equals(type)) {
            return new RSA2Encryptor();
        }
        if ("SM2".equals(type)) {
            return new SM2Encryptor();
        }
        throw new AlipayApiException(String.format(AlipayApiErrorEnum.SIGN_TYPE_ERROR.getErrMsg(), type));
    }
}

