/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.model;

import com.alipay.v3.JSON;
import com.alipay.v3.model.ConversionProperty;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class ConversionData {
    public static final String SERIALIZED_NAME_AD_ID = "ad_id";
    @SerializedName(value="ad_id")
    private String adId;
    public static final String SERIALIZED_NAME_ATTRIBUTE_LIST = "attribute_list";
    @SerializedName(value="attribute_list")
    private List<ConversionProperty> attributeList = null;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    private ConversionProperty attributes;
    public static final String SERIALIZED_NAME_BIZ_NO = "biz_no";
    @SerializedName(value="biz_no")
    private String bizNo;
    public static final String SERIALIZED_NAME_CALLBACK_EXT_INFO = "callback_ext_info";
    @SerializedName(value="callback_ext_info")
    private String callbackExtInfo;
    public static final String SERIALIZED_NAME_CID = "cid";
    @SerializedName(value="cid")
    private String cid;
    public static final String SERIALIZED_NAME_CONVERSION_AMOUNT = "conversion_amount";
    @SerializedName(value="conversion_amount")
    private String conversionAmount;
    public static final String SERIALIZED_NAME_CONVERSION_ID = "conversion_id";
    @SerializedName(value="conversion_id")
    private String conversionId;
    public static final String SERIALIZED_NAME_CONVERSION_TIME = "conversion_time";
    @SerializedName(value="conversion_time")
    private Integer conversionTime;
    public static final String SERIALIZED_NAME_CONVERSION_TYPE = "conversion_type";
    @SerializedName(value="conversion_type")
    private String conversionType;
    public static final String SERIALIZED_NAME_CREATIVE_ID = "creative_id";
    @SerializedName(value="creative_id")
    private String creativeId;
    public static final String SERIALIZED_NAME_DATA_ID = "data_id";
    @SerializedName(value="data_id")
    private String dataId;
    public static final String SERIALIZED_NAME_DATA_SRC_TYPE = "data_src_type";
    @SerializedName(value="data_src_type")
    private String dataSrcType;
    public static final String SERIALIZED_NAME_GROUP_ID = "group_id";
    @SerializedName(value="group_id")
    private String groupId;
    public static final String SERIALIZED_NAME_JOIN_CHANNEL = "join_channel";
    @SerializedName(value="join_channel")
    private String joinChannel;
    public static final String SERIALIZED_NAME_PLAN_ID = "plan_id";
    @SerializedName(value="plan_id")
    private String planId;
    public static final String SERIALIZED_NAME_PRINCIPAL_ID = "principal_id";
    @SerializedName(value="principal_id")
    private String principalId;
    public static final String SERIALIZED_NAME_PRINCIPAL_TAG = "principal_tag";
    @SerializedName(value="principal_tag")
    private String principalTag;
    public static final String SERIALIZED_NAME_PROPERTY_LIST = "property_list";
    @SerializedName(value="property_list")
    private List<ConversionProperty> propertyList = null;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    private String source;
    public static final String SERIALIZED_NAME_TARGET_ID = "target_id";
    @SerializedName(value="target_id")
    private String targetId;
    public static final String SERIALIZED_NAME_TARGET_TYPE = "target_type";
    @SerializedName(value="target_type")
    private String targetType;
    public static final String SERIALIZED_NAME_UUID = "uuid";
    @SerializedName(value="uuid")
    private String uuid;
    public static final String SERIALIZED_NAME_UUID_OPEN_ID = "uuid_open_id";
    @SerializedName(value="uuid_open_id")
    private String uuidOpenId;
    public static final String SERIALIZED_NAME_UUID_TYPE = "uuid_type";
    @SerializedName(value="uuid_type")
    private String uuidType;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ConversionData adId(String adId) {
        this.adId = adId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="123", value="\u5e7f\u544a\u521b\u610fid\uff0c\u6765\u81ea\uff1a<a href='https://adpub.alipay.com/lark/adrlark/qm1v2gtpvcftele4'>\u76d1\u6d4b\u4e0a\u62a5</a>\u6216<a href='https://adpub.alipay.com/lark/adrlark/gw3740rggm4n5gar'>\u843d\u5730\u9875\u5b8f\u66ff\u6362</a>\u914d\u7f6e\u7684__AD_ID__\u5b8f\u53c2\u53d1\u751f\u7528\u6237\u70b9\u51fb\u66ff\u6362\u540e\u7684\u503c")
    public String getAdId() {
        return this.adId;
    }

    public void setAdId(String adId) {
        this.adId = adId;
    }

    public ConversionData attributeList(List<ConversionProperty> attributeList) {
        this.attributeList = attributeList;
        return this;
    }

    public ConversionData addAttributeListItem(ConversionProperty attributeListItem) {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList<ConversionProperty>();
        }
        this.attributeList.add(attributeListItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u8f6c\u5316\u4e8b\u4ef6\u5c5e\u6027\u4fe1\u606f\uff0c\u7528\u4e8e\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b\u76f8\u5173\u5c5e\u6027\u89c4\u5219\u4e0a\u4f20\u3002 \u53ef\u652f\u6301\u4e0a\u4f20\u5c5e\u6027\u7684\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b\u53ca\u5c5e\u6027\u89c4\u5219\u8bf7\u53c2\u8003\u8be5\u6587\u6863\uff1a<a href='https://adpub.alipay.com/adrlark/ivdktpyh511x9r6i'>\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b\u5c5e\u6027\u89c4\u5219</a>")
    public List<ConversionProperty> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<ConversionProperty> attributeList) {
        this.attributeList = attributeList;
    }

    public ConversionData attributes(ConversionProperty attributes) {
        this.attributes = attributes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public ConversionProperty getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ConversionProperty attributes) {
        this.attributes = attributes;
    }

    public ConversionData bizNo(String bizNo) {
        this.bizNo = bizNo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Zybnom890437Mvcu", value="\u8f6c\u5316\u6d41\u6c34\u53f7\uff1a\u7531\u7528\u6237\u81ea\u5b9a\u4e49\uff0c\u7528\u4e8e\u5e42\u7b49")
    public String getBizNo() {
        return this.bizNo;
    }

    public void setBizNo(String bizNo) {
        this.bizNo = bizNo;
    }

    public ConversionData callbackExtInfo(String callbackExtInfo) {
        this.callbackExtInfo = callbackExtInfo;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="hAXLRVRoQHTgh2CQLhjfkX_0HR80F7ktEabHmKgD_XSSXPF2Pwv-a_pEAQVW2FS-6FCLShsXMMU4Ctx0X61swqcK4Qme3YdxzrjynZ_gYjQ8Iv4MNcM0d8oHKFiDWyOx", value="\u6765\u81ea\uff1a<a href='https://adpub.alipay.com/lark/adrlark/qm1v2gtpvcftele4'>\u76d1\u6d4b\u4e0a\u62a5</a>\u6216<a href='https://adpub.alipay.com/lark/adrlark/gw3740rggm4n5gar'>\u843d\u5730\u9875\u5b8f\u66ff\u6362</a>\u914d\u7f6e\u7684__CALLBACK_EXT_INFO__\u5b8f\u53c2\u53d1\u751f\u7528\u6237\u70b9\u51fb\u66ff\u6362\u540e\u7684\u503c\uff0c\u9700url decode\u540e\u4f20\u56de\u3002")
    public String getCallbackExtInfo() {
        return this.callbackExtInfo;
    }

    public void setCallbackExtInfo(String callbackExtInfo) {
        this.callbackExtInfo = callbackExtInfo;
    }

    public ConversionData cid(String cid) {
        this.cid = cid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="8e91eca2-930d-4b4e-bb38-1ba74146cd06", value="\u7528\u4e8e\u7cbe\u51c6\u5f52\u56e0\uff0c\u6765\u81ea\uff1a<a href='https://adpub.alipay.com/lark/adrlark/qm1v2gtpvcftele4'>\u76d1\u6d4b\u4e0a\u62a5</a>\u6216<a href='https://adpub.alipay.com/lark/adrlark/gw3740rggm4n5gar'>\u843d\u5730\u9875\u5b8f\u66ff\u6362</a>\u914d\u7f6e\u7684__CID__\u5b8f\u53c2\u53d1\u751f\u7528\u6237\u70b9\u51fb\u66ff\u6362\u540e\u7684\u503c\u3002<br> \u652f\u6301cid\u4e0a\u62a5\u7684\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b\u8bf7\u53c2\u89c1\uff1a<br> <a href='https://adpub.alipay.com/lark/adrlark/pg4vb1c0g0u6fx7b'>app\u63a8\u5e7f\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b</a><br> <a href='https://adpub.alipay.com/lark/adrlark/rvzylhryxh37yplt'>\u901a\u7528\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b</a>")
    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public ConversionData conversionAmount(String conversionAmount) {
        this.conversionAmount = conversionAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="20", value="\u8f6c\u5316\u91d1\u989d\uff0c\u5355\u4f4d\u5206\u3002 \u91d1\u989d\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u5fc5\u4f20")
    public String getConversionAmount() {
        return this.conversionAmount;
    }

    public void setConversionAmount(String conversionAmount) {
        this.conversionAmount = conversionAmount;
    }

    public ConversionData conversionId(String conversionId) {
        this.conversionId = conversionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="167390987332", value="\u8f6c\u5316\u4e8b\u4ef6id\uff0c\u5f53source=COMMON_CONVERSION_ID\u9700\u4e0a\u4f20\u8be5\u5b57\u6bb5\uff0c\u5176\u4ed6\u60c5\u51b5\u65e0\u9700\u4e0a\u4f20\u3002")
    public String getConversionId() {
        return this.conversionId;
    }

    public void setConversionId(String conversionId) {
        this.conversionId = conversionId;
    }

    public ConversionData conversionTime(Integer conversionTime) {
        this.conversionTime = conversionTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12389637", value="\u8f6c\u5316\u65f6\u95f4\uff0cUTC \u65f6\u95f4\u6233\uff0c\u5355\u4f4d\uff1a\u79d2")
    public Integer getConversionTime() {
        return this.conversionTime;
    }

    public void setConversionTime(Integer conversionTime) {
        this.conversionTime = conversionTime;
    }

    public ConversionData conversionType(String conversionType) {
        this.conversionType = conversionType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="225", value="\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b\u6570\u5b57")
    public String getConversionType() {
        return this.conversionType;
    }

    public void setConversionType(String conversionType) {
        this.conversionType = conversionType;
    }

    public ConversionData creativeId(String creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="6785", value="\u5e7f\u544a\u521b\u610fid\uff0c\u6765\u81ea\uff1a<a href='https://adpub.alipay.com/lark/adrlark/qm1v2gtpvcftele4'>\u76d1\u6d4b\u4e0a\u62a5</a>\u6216<a href='https://adpub.alipay.com/lark/adrlark/gw3740rggm4n5gar'>\u843d\u5730\u9875\u5b8f\u66ff\u6362</a>\u914d\u7f6e\u7684__AD_ID__\u5b8f\u53c2\u53d1\u751f\u7528\u6237\u70b9\u51fb\u66ff\u6362\u540e\u7684\u503c")
    public String getCreativeId() {
        return this.creativeId;
    }

    public void setCreativeId(String creativeId) {
        this.creativeId = creativeId;
    }

    public ConversionData dataId(String dataId) {
        this.dataId = dataId;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(example="20391", value="\u5f53source=XLIGHT\u6216\u8005DATASET\u65f6\u4f7f\u7528\uff1a  \u6570\u636e\u96c6id(\u63a5\u53e3\u5347\u7ea7\uff0c\u8be5\u53c2\u6570\u5df2\u4e0d\u518d\u4f7f\u7528\uff0c\u6545\u5e9f\u5f03\u8be5\u53c2\u6570\uff0c\u4f46\u4e0d\u5f71\u54cd\u5386\u53f2\u6570\u636e\u4f7f\u7528\u3002)")
    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public ConversionData dataSrcType(String dataSrcType) {
        this.dataSrcType = dataSrcType;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(example="KR_MEMBER", value="\u5f53source=OTHER\u65f6\u4f7f\u7528:  \u6570\u636e\u7c7b\u578b\uff1a KR_MEMBER - \u5ba2\u5982\u4e91\u5165\u4f1a KR_TRADE - \u5ba2\u5982\u4e91\u4ea4\u6613 TB_LIVE -  \u6dd8\u5b9d\u76f4\u64ad(\u63a5\u53e3\u5347\u7ea7\uff0c\u8be5\u53c2\u6570\u5df2\u4e0d\u518d\u4f7f\u7528\uff0c\u6545\u5e9f\u5f03\u8be5\u53c2\u6570\uff0c\u4f46\u4e0d\u5f71\u54cd\u5386\u53f2\u6570\u636e\u4f7f\u7528\u3002)")
    public String getDataSrcType() {
        return this.dataSrcType;
    }

    public void setDataSrcType(String dataSrcType) {
        this.dataSrcType = dataSrcType;
    }

    public ConversionData groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7896", value="\u5e7f\u544a\u5355\u5143id\uff0c\u6765\u81ea\uff1a<a href='https://adpub.alipay.com/lark/adrlark/qm1v2gtpvcftele4'>\u76d1\u6d4b\u4e0a\u62a5</a>\u6216<a href='https://adpub.alipay.com/lark/adrlark/gw3740rggm4n5gar'>\u843d\u5730\u9875\u5b8f\u66ff\u6362</a>\u914d\u7f6e\u7684__GROUP_ID__\u5b8f\u53c2\u53d1\u751f\u7528\u6237\u70b9\u51fb\u66ff\u6362\u540e\u7684\u503c")
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public ConversionData joinChannel(String joinChannel) {
        this.joinChannel = joinChannel;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="XLIGHT", value="XLIGHT - \u706f\u706b\u5f52\u56e0 MERCHANT -\u5546\u5bb6\u81ea\u4e3b\u5f52\u56e0 \u8be5\u5b57\u6bb5\u82e5\u4e3a\u7a7a\u5219\u9ed8\u8ba4\u4e3aXLIGHT")
    public String getJoinChannel() {
        return this.joinChannel;
    }

    public void setJoinChannel(String joinChannel) {
        this.joinChannel = joinChannel;
    }

    public ConversionData planId(String planId) {
        this.planId = planId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1789", value="\u5e7f\u544a\u8ba1\u5212id\uff0c\u6765\u81ea\uff1a<a href='https://adpub.alipay.com/lark/adrlark/qm1v2gtpvcftele4'>\u76d1\u6d4b\u4e0a\u62a5</a>\u6216<a href='https://adpub.alipay.com/lark/adrlark/gw3740rggm4n5gar'>\u843d\u5730\u9875\u5b8f\u66ff\u6362</a>\u914d\u7f6e\u7684__PLAN_ID__\u5b8f\u53c2\u53d1\u751f\u7528\u6237\u70b9\u51fb\u66ff\u6362\u540e\u7684\u503c")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public ConversionData principalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="\u5546\u6237\u5728\u706f\u706bpb\u7aef\u7684id, \u53ef\u4ee3\u66ffprincipal_tag\u3002")
    public String getPrincipalId() {
        return this.principalId;
    }

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    public ConversionData principalTag(String principalTag) {
        this.principalTag = principalTag;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="HYjofejnnlp89730202bcklHH", value="\u5546\u5bb6\u6807\u5fd7\uff0c\u53ef\u4ee3\u66ffprincipal_id\u3002\u83b7\u53d6\u65b9\u6cd5\uff1a <a href='https://adpub.alipay.com/lark/adrlark/sbk3vetg6ki5m4r8'>principal_tag\u83b7\u53d6sop</a><br>")
    public String getPrincipalTag() {
        return this.principalTag;
    }

    public void setPrincipalTag(String principalTag) {
        this.principalTag = principalTag;
    }

    public ConversionData propertyList(List<ConversionProperty> propertyList) {
        this.propertyList = propertyList;
        return this;
    }

    public ConversionData addPropertyListItem(ConversionProperty propertyListItem) {
        if (this.propertyList == null) {
            this.propertyList = new ArrayList<ConversionProperty>();
        }
        this.propertyList.add(propertyListItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u8f6c\u5316\u5f52\u56e0\u5b57\u6bb5\u5217\u8868\u3002\u4e0d\u540c\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b\u56de\u4f20property_list\u4e0d\u540c\u3002\u8bf7\u53c2\u89c1\u56de\u4f20\u793a\u4f8b\uff1a<br> <a href=\"https://adpub.alipay.com/lark/adrlark/pvbgwf72ea090877\">\u901a\u7528\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u56de\u4f20\u793a\u4f8b</a><br> <a href=\"https://adpub.alipay.com/lark/adrlark/kgnnk94p0p1mwbgp\">APP\u63a8\u5e7f\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u56de\u4f20\u793a\u4f8b</a><br>")
    public List<ConversionProperty> getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(List<ConversionProperty> propertyList) {
        this.propertyList = propertyList;
    }

    public ConversionData source(String source) {
        this.source = source;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="COMMON_TARGET", value="<br> COMMON_TARGET\uff1a<a href='https://adpub.alipay.com/lark/adrlark/rvzylhryxh37yplt'>\u901a\u7528\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b</a>\u9002\u7528<br> CALLBACK\uff1a<a href='https://adpub.alipay.com/lark/adrlark/pg4vb1c0g0u6fx7b'>APP\u63a8\u5e7f\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b</a>\u9002\u7528<br> \u4e0d\u540csource\u7684\u53c2\u6570\u56de\u4f20\u89c4\u5219\u8bf7\u53c2\u8003\uff1a COMMON_TARGET\uff1a<a href='https://adpub.alipay.com/lark/adrlark/dxw7fkkdnhm45spm'>\u901a\u7528\u8f6c\u5316\u56de\u4f20\u53c2\u6570\u8bf4\u660e</a><br> CALLBACK\uff1a <a href='https://adpub.alipay.com/lark/adrlark/wxou6agg3z1o6wyn'>APP\u63a8\u5e7f\u7c7b\u8f6c\u5316\u56de\u4f20\u53c2\u6570\u8bf4\u660e</a>")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public ConversionData targetId(String targetId) {
        this.targetId = targetId;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(example="123", value="\u5f53source=OTHER\u65f6\u4f7f\u7528\uff1a \u4e3b\u4f53id\uff0c\u4f8b\u5982\u54c1\u724cid(\u63a5\u53e3\u5347\u7ea7\uff0c\u8be5\u53c2\u6570\u5df2\u4e0d\u518d\u4f7f\u7528\uff0c\u6545\u5e9f\u5f03\u8be5\u53c2\u6570\uff0c\u4f46\u4e0d\u5f71\u54cd\u5386\u53f2\u6570\u636e\u4f7f\u7528\u3002)")
    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public ConversionData targetType(String targetType) {
        this.targetType = targetType;
        return this;
    }

    @Deprecated
    @Nullable
    @ApiModelProperty(example="STORE", value="\u5f53source=OTHER\u65f6\u4f7f\u7528\uff1a  \u4e3b\u4f53\u7c7b\u578b\uff1a BRAND - \u54c1\u724c STORE - \u5e97\u94fa LIVE - \u76f4\u64ad \u7b49\u7b49(\u63a5\u53e3\u5347\u7ea7\uff0c\u8be5\u53c2\u6570\u5df2\u4e0d\u518d\u4f7f\u7528\uff0c\u6545\u5e9f\u5f03\u8be5\u53c2\u6570\uff0c\u4f46\u4e0d\u5f71\u54cd\u5386\u53f2\u6570\u636e\u4f7f\u7528\u3002)")
    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public ConversionData uuid(String uuid) {
        this.uuid = uuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="7893ybc7032173", value="\u53d1\u751f\u8f6c\u5316\u7528\u6237\u7684\u552f\u4e00\u6807\u8bc6\u3002 uuid_type\u4e0d\u540c\uff0cuuid\u4f20\u503c\u4e0d\u540c\uff1a<br> 1. \u82e5uuid_type=\u3010PID\u3011\uff1auuid\u4e3a\u53d1\u751f\u8f6c\u5316\u7528\u6237\u76842088id\u3002\u82e5\u83b7\u53d6\u4e0d\u5230\uff0c\u53ef\u56fa\u5b9a\u4e00\u4e2a\u503c\u540e\uff0c\u4e0a\u4f20callback_ext_info\u53c2\u6570\u3002<br> 2. \u82e5uuid_type=\u3010OAID_MD5\u3011\u3010IDFA_MD5\u3011\u3010IP_UA\u3011\u3010CAID\u3011\u3010MEI\u3011: uuid\u4f20\u7684\u503c\u4e3a<a href='https://adpub.alipay.com/lark/adrlark/qm1v2gtpvcftele4'>\u76d1\u6d4b\u4e0a\u62a5</a>\u6216<a href='https://adpub.alipay.com/lark/adrlark/gw3740rggm4n5gar'>\u843d\u5730\u9875\u5b8f\u66ff\u6362</a>\u914d\u7f6e\u7684\u5bf9\u5e94\u5b8f\u53c2\u4e0b\u53d1\u7684\u503c<br> \u5176\u4e2d\u5f53uuid_type=IP_UA\u65f6\uff1a__IP__\u3001__UA__\u5b8f\u53c2\u9700\u7528\"_\"\u62fc\u63a5\u4e0a\u4f20<br>")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public ConversionData uuidOpenId(String uuidOpenId) {
        this.uuidOpenId = uuidOpenId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="oPXyY4O0ZTmUqSX4MRxYDDCccT6Kc9EXX", value="\u652f\u4ed8\u5b9d\u7528\u6237\u5728\u5e94\u7528\u7ef4\u5ea6\u4e0b\u7684\u552f\u4e00\u6807\u8bc6")
    public String getUuidOpenId() {
        return this.uuidOpenId;
    }

    public void setUuidOpenId(String uuidOpenId) {
        this.uuidOpenId = uuidOpenId;
    }

    public ConversionData uuidType(String uuidType) {
        this.uuidType = uuidType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="PID", value="<a href='https://adpub.alipay.com/lark/adrlark/rvzylhryxh37yplt'>\u901a\u7528\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b\uff1a</a><br> uuid_type\u56fa\u5b9a\u4e3aPID\uff1a\u8868\u793a\u8f6c\u5316\u7528\u6237\u552f\u4e00\u6807\u8bc6<br> <a href='https://adpub.alipay.com/lark/adrlark/pg4vb1c0g0u6fx7b'>APP\u63a8\u5e7f\u7c7b\u8f6c\u5316\u4e8b\u4ef6\u7c7b\u578b\uff1a</a><br> OAID_MD5\uff1a\u8868\u793aOAID\u539f\u503cMD5\u52a0\u5bc6\u540e\u7684\u503c<br> IDFA_MD5\uff1a\u8868\u793aIDFA\u539f\u503cMD5\u52a0\u5bc6\u540e\u7684\u503c<br> IP_UA\uff1a\u8868\u793aIP_UA\u62fc\u63a5\u503c\uff0c\u4ee5\u4e0b\u5212\u7ebf\u62fc\u63a5<br> CAID\uff1a\u8868\u793aCAID\u539f\u503c<br> IMEI\uff1a\u8868\u793aIMEI\u539f\u503c<br>")
    public String getUuidType() {
        return this.uuidType;
    }

    public void setUuidType(String uuidType) {
        this.uuidType = uuidType;
    }

    public ConversionData putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionData conversionData = (ConversionData)o;
        return Objects.equals(this.adId, conversionData.adId) && Objects.equals(this.attributeList, conversionData.attributeList) && Objects.equals(this.attributes, conversionData.attributes) && Objects.equals(this.bizNo, conversionData.bizNo) && Objects.equals(this.callbackExtInfo, conversionData.callbackExtInfo) && Objects.equals(this.cid, conversionData.cid) && Objects.equals(this.conversionAmount, conversionData.conversionAmount) && Objects.equals(this.conversionId, conversionData.conversionId) && Objects.equals(this.conversionTime, conversionData.conversionTime) && Objects.equals(this.conversionType, conversionData.conversionType) && Objects.equals(this.creativeId, conversionData.creativeId) && Objects.equals(this.dataId, conversionData.dataId) && Objects.equals(this.dataSrcType, conversionData.dataSrcType) && Objects.equals(this.groupId, conversionData.groupId) && Objects.equals(this.joinChannel, conversionData.joinChannel) && Objects.equals(this.planId, conversionData.planId) && Objects.equals(this.principalId, conversionData.principalId) && Objects.equals(this.principalTag, conversionData.principalTag) && Objects.equals(this.propertyList, conversionData.propertyList) && Objects.equals(this.source, conversionData.source) && Objects.equals(this.targetId, conversionData.targetId) && Objects.equals(this.targetType, conversionData.targetType) && Objects.equals(this.uuid, conversionData.uuid) && Objects.equals(this.uuidOpenId, conversionData.uuidOpenId) && Objects.equals(this.uuidType, conversionData.uuidType) && Objects.equals(this.additionalProperties, conversionData.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.adId, this.attributeList, this.attributes, this.bizNo, this.callbackExtInfo, this.cid, this.conversionAmount, this.conversionId, this.conversionTime, this.conversionType, this.creativeId, this.dataId, this.dataSrcType, this.groupId, this.joinChannel, this.planId, this.principalId, this.principalTag, this.propertyList, this.source, this.targetId, this.targetType, this.uuid, this.uuidOpenId, this.uuidType, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversionData {\n");
        sb.append("    adId: ").append(this.toIndentedString(this.adId)).append("\n");
        sb.append("    attributeList: ").append(this.toIndentedString(this.attributeList)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    bizNo: ").append(this.toIndentedString(this.bizNo)).append("\n");
        sb.append("    callbackExtInfo: ").append(this.toIndentedString(this.callbackExtInfo)).append("\n");
        sb.append("    cid: ").append(this.toIndentedString(this.cid)).append("\n");
        sb.append("    conversionAmount: ").append(this.toIndentedString(this.conversionAmount)).append("\n");
        sb.append("    conversionId: ").append(this.toIndentedString(this.conversionId)).append("\n");
        sb.append("    conversionTime: ").append(this.toIndentedString(this.conversionTime)).append("\n");
        sb.append("    conversionType: ").append(this.toIndentedString(this.conversionType)).append("\n");
        sb.append("    creativeId: ").append(this.toIndentedString(this.creativeId)).append("\n");
        sb.append("    dataId: ").append(this.toIndentedString(this.dataId)).append("\n");
        sb.append("    dataSrcType: ").append(this.toIndentedString(this.dataSrcType)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    joinChannel: ").append(this.toIndentedString(this.joinChannel)).append("\n");
        sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        sb.append("    principalId: ").append(this.toIndentedString(this.principalId)).append("\n");
        sb.append("    principalTag: ").append(this.toIndentedString(this.principalTag)).append("\n");
        sb.append("    propertyList: ").append(this.toIndentedString(this.propertyList)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    targetId: ").append(this.toIndentedString(this.targetId)).append("\n");
        sb.append("    targetType: ").append(this.toIndentedString(this.targetType)).append("\n");
        sb.append("    uuid: ").append(this.toIndentedString(this.uuid)).append("\n");
        sb.append("    uuidOpenId: ").append(this.toIndentedString(this.uuidOpenId)).append("\n");
        sb.append("    uuidType: ").append(this.toIndentedString(this.uuidType)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ConversionData is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_AD_ID) != null && !jsonObj.get(SERIALIZED_NAME_AD_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ad_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AD_ID).toString()));
        }
        JsonArray jsonArrayattributeList = jsonObj.getAsJsonArray(SERIALIZED_NAME_ATTRIBUTE_LIST);
        if (jsonArrayattributeList != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ATTRIBUTE_LIST).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `attribute_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTE_LIST).toString()));
            }
            for (int i = 0; i < jsonArrayattributeList.size(); ++i) {
                ConversionProperty.validateJsonObject(jsonArrayattributeList.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.getAsJsonObject(SERIALIZED_NAME_ATTRIBUTES) != null) {
            ConversionProperty.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_ATTRIBUTES));
        }
        if (jsonObj.get(SERIALIZED_NAME_BIZ_NO) != null && !jsonObj.get(SERIALIZED_NAME_BIZ_NO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `biz_no` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BIZ_NO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CALLBACK_EXT_INFO) != null && !jsonObj.get(SERIALIZED_NAME_CALLBACK_EXT_INFO).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `callback_ext_info` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CALLBACK_EXT_INFO).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CID) != null && !jsonObj.get(SERIALIZED_NAME_CID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONVERSION_AMOUNT) != null && !jsonObj.get(SERIALIZED_NAME_CONVERSION_AMOUNT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `conversion_amount` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONVERSION_AMOUNT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONVERSION_ID) != null && !jsonObj.get(SERIALIZED_NAME_CONVERSION_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `conversion_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONVERSION_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONVERSION_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_CONVERSION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `conversion_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONVERSION_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CREATIVE_ID) != null && !jsonObj.get(SERIALIZED_NAME_CREATIVE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `creative_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CREATIVE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA_ID) != null && !jsonObj.get(SERIALIZED_NAME_DATA_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `data_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DATA_SRC_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_DATA_SRC_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `data_src_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DATA_SRC_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_GROUP_ID) != null && !jsonObj.get(SERIALIZED_NAME_GROUP_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `group_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_GROUP_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_JOIN_CHANNEL) != null && !jsonObj.get(SERIALIZED_NAME_JOIN_CHANNEL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `join_channel` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_JOIN_CHANNEL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLAN_ID) != null && !jsonObj.get(SERIALIZED_NAME_PLAN_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `plan_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PLAN_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRINCIPAL_ID) != null && !jsonObj.get(SERIALIZED_NAME_PRINCIPAL_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `principal_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRINCIPAL_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRINCIPAL_TAG) != null && !jsonObj.get(SERIALIZED_NAME_PRINCIPAL_TAG).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `principal_tag` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRINCIPAL_TAG).toString()));
        }
        JsonArray jsonArraypropertyList = jsonObj.getAsJsonArray(SERIALIZED_NAME_PROPERTY_LIST);
        if (jsonArraypropertyList != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PROPERTY_LIST).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `property_list` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROPERTY_LIST).toString()));
            }
            for (int i = 0; i < jsonArraypropertyList.size(); ++i) {
                ConversionProperty.validateJsonObject(jsonArraypropertyList.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `source` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SOURCE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_ID) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `target_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TARGET_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TARGET_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `target_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TARGET_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UUID) != null && !jsonObj.get(SERIALIZED_NAME_UUID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uuid` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UUID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UUID_OPEN_ID) != null && !jsonObj.get(SERIALIZED_NAME_UUID_OPEN_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uuid_open_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UUID_OPEN_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UUID_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_UUID_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `uuid_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UUID_TYPE).toString()));
        }
    }

    public static ConversionData fromJson(String jsonString) throws IOException {
        return (ConversionData)JSON.getGson().fromJson(jsonString, ConversionData.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AD_ID);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTE_LIST);
        openapiFields.add(SERIALIZED_NAME_ATTRIBUTES);
        openapiFields.add(SERIALIZED_NAME_BIZ_NO);
        openapiFields.add(SERIALIZED_NAME_CALLBACK_EXT_INFO);
        openapiFields.add(SERIALIZED_NAME_CID);
        openapiFields.add(SERIALIZED_NAME_CONVERSION_AMOUNT);
        openapiFields.add(SERIALIZED_NAME_CONVERSION_ID);
        openapiFields.add(SERIALIZED_NAME_CONVERSION_TIME);
        openapiFields.add(SERIALIZED_NAME_CONVERSION_TYPE);
        openapiFields.add(SERIALIZED_NAME_CREATIVE_ID);
        openapiFields.add(SERIALIZED_NAME_DATA_ID);
        openapiFields.add(SERIALIZED_NAME_DATA_SRC_TYPE);
        openapiFields.add(SERIALIZED_NAME_GROUP_ID);
        openapiFields.add(SERIALIZED_NAME_JOIN_CHANNEL);
        openapiFields.add(SERIALIZED_NAME_PLAN_ID);
        openapiFields.add(SERIALIZED_NAME_PRINCIPAL_ID);
        openapiFields.add(SERIALIZED_NAME_PRINCIPAL_TAG);
        openapiFields.add(SERIALIZED_NAME_PROPERTY_LIST);
        openapiFields.add(SERIALIZED_NAME_SOURCE);
        openapiFields.add(SERIALIZED_NAME_TARGET_ID);
        openapiFields.add(SERIALIZED_NAME_TARGET_TYPE);
        openapiFields.add(SERIALIZED_NAME_UUID);
        openapiFields.add(SERIALIZED_NAME_UUID_OPEN_ID);
        openapiFields.add(SERIALIZED_NAME_UUID_TYPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ConversionData.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ConversionData.class));
            return new TypeAdapter<ConversionData>(){

                public void write(JsonWriter out, ConversionData value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)gson.toJsonTree(entry.getValue()).getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ConversionData read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ConversionData.validateJsonObject(jsonObj);
                    ConversionData instance = (ConversionData)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format("The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

