/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.ZhimaMerchantZmgoCumulateQueryDefaultResponse;
import com.alipay.v3.model.ZhimaMerchantZmgoCumulateQueryResponseModel;
import com.alipay.v3.model.ZhimaMerchantZmgoCumulateSyncDefaultResponse;
import com.alipay.v3.model.ZhimaMerchantZmgoCumulateSyncModel;
import com.alipay.v3.model.ZhimaMerchantZmgoCumulateSyncResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class ZhimaMerchantZmgoCumulateApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ZhimaMerchantZmgoCumulateApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ZhimaMerchantZmgoCumulateApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call queryCall(String agreementId, String userId, String openId, String providerPid, Boolean needDetail, Integer pageNo, Integer pageSize, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/zhima/merchant/zmgo/cumulate/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (agreementId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("agreement_id", agreementId));
        }
        if (userId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("user_id", userId));
        }
        if (openId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("open_id", openId));
        }
        if (providerPid != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("provider_pid", providerPid));
        }
        if (needDetail != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("need_detail", needDetail));
        }
        if (pageNo != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_no", pageNo));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("page_size", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String agreementId, String userId, String openId, String providerPid, Boolean needDetail, Integer pageNo, Integer pageSize, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(agreementId, userId, openId, providerPid, needDetail, pageNo, pageSize, _callback, customizedParams);
        return localVarCall;
    }

    public ZhimaMerchantZmgoCumulateQueryResponseModel query(String agreementId, String userId, String openId, String providerPid, Boolean needDetail, Integer pageNo, Integer pageSize) throws ApiException {
        ApiResponse<ZhimaMerchantZmgoCumulateQueryResponseModel> localVarResp = this.queryWithHttpInfo(agreementId, userId, openId, providerPid, needDetail, pageNo, pageSize, null);
        return localVarResp.getData();
    }

    public ZhimaMerchantZmgoCumulateQueryResponseModel query(String agreementId, String userId, String openId, String providerPid, Boolean needDetail, Integer pageNo, Integer pageSize, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<ZhimaMerchantZmgoCumulateQueryResponseModel> localVarResp = this.queryWithHttpInfo(agreementId, userId, openId, providerPid, needDetail, pageNo, pageSize, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<ZhimaMerchantZmgoCumulateQueryResponseModel> queryWithHttpInfo(String agreementId, String userId, String openId, String providerPid, Boolean needDetail, Integer pageNo, Integer pageSize, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(agreementId, userId, openId, providerPid, needDetail, pageNo, pageSize, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<ZhimaMerchantZmgoCumulateQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ZhimaMerchantZmgoCumulateQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call queryAsync(String agreementId, String userId, String openId, String providerPid, Boolean needDetail, Integer pageNo, Integer pageSize, ApiCallback<ZhimaMerchantZmgoCumulateQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(agreementId, userId, openId, providerPid, needDetail, pageNo, pageSize, _callback, null);
        Type localVarReturnType = new TypeToken<ZhimaMerchantZmgoCumulateQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call queryAsync(String agreementId, String userId, String openId, String providerPid, Boolean needDetail, Integer pageNo, Integer pageSize, ApiCallback<ZhimaMerchantZmgoCumulateQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(agreementId, userId, openId, providerPid, needDetail, pageNo, pageSize, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<ZhimaMerchantZmgoCumulateQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call syncCall(ZhimaMerchantZmgoCumulateSyncModel zhimaMerchantZmgoCumulateSyncModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        ZhimaMerchantZmgoCumulateSyncModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : zhimaMerchantZmgoCumulateSyncModel;
        String localVarPath = "/v3/zhima/merchant/zmgo/cumulate/sync";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call syncValidateBeforeCall(ZhimaMerchantZmgoCumulateSyncModel zhimaMerchantZmgoCumulateSyncModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.syncCall(zhimaMerchantZmgoCumulateSyncModel, _callback, customizedParams);
        return localVarCall;
    }

    public ZhimaMerchantZmgoCumulateSyncResponseModel sync(ZhimaMerchantZmgoCumulateSyncModel zhimaMerchantZmgoCumulateSyncModel) throws ApiException {
        ApiResponse<ZhimaMerchantZmgoCumulateSyncResponseModel> localVarResp = this.syncWithHttpInfo(zhimaMerchantZmgoCumulateSyncModel, null);
        return localVarResp.getData();
    }

    public ZhimaMerchantZmgoCumulateSyncResponseModel sync(ZhimaMerchantZmgoCumulateSyncModel zhimaMerchantZmgoCumulateSyncModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<ZhimaMerchantZmgoCumulateSyncResponseModel> localVarResp = this.syncWithHttpInfo(zhimaMerchantZmgoCumulateSyncModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<ZhimaMerchantZmgoCumulateSyncResponseModel> syncWithHttpInfo(ZhimaMerchantZmgoCumulateSyncModel zhimaMerchantZmgoCumulateSyncModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.syncValidateBeforeCall(zhimaMerchantZmgoCumulateSyncModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<ZhimaMerchantZmgoCumulateSyncResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<ZhimaMerchantZmgoCumulateSyncDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call syncAsync(ZhimaMerchantZmgoCumulateSyncModel zhimaMerchantZmgoCumulateSyncModel, ApiCallback<ZhimaMerchantZmgoCumulateSyncResponseModel> _callback) throws ApiException {
        Call localVarCall = this.syncValidateBeforeCall(zhimaMerchantZmgoCumulateSyncModel, _callback, null);
        Type localVarReturnType = new TypeToken<ZhimaMerchantZmgoCumulateSyncResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call syncAsync(ZhimaMerchantZmgoCumulateSyncModel zhimaMerchantZmgoCumulateSyncModel, ApiCallback<ZhimaMerchantZmgoCumulateSyncResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.syncValidateBeforeCall(zhimaMerchantZmgoCumulateSyncModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<ZhimaMerchantZmgoCumulateSyncResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

