/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayTradeCustomsDeclareDefaultResponse;
import com.alipay.v3.model.AlipayTradeCustomsDeclareModel;
import com.alipay.v3.model.AlipayTradeCustomsDeclareResponseModel;
import com.alipay.v3.model.AlipayTradeCustomsQueryDefaultResponse;
import com.alipay.v3.model.AlipayTradeCustomsQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayTradeCustomsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayTradeCustomsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayTradeCustomsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call declareCall(AlipayTradeCustomsDeclareModel alipayTradeCustomsDeclareModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayTradeCustomsDeclareModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayTradeCustomsDeclareModel;
        String localVarPath = "/v3/alipay/trade/customs/declare";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call declareValidateBeforeCall(AlipayTradeCustomsDeclareModel alipayTradeCustomsDeclareModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.declareCall(alipayTradeCustomsDeclareModel, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayTradeCustomsDeclareResponseModel declare(AlipayTradeCustomsDeclareModel alipayTradeCustomsDeclareModel) throws ApiException {
        ApiResponse<AlipayTradeCustomsDeclareResponseModel> localVarResp = this.declareWithHttpInfo(alipayTradeCustomsDeclareModel, null);
        return localVarResp.getData();
    }

    public AlipayTradeCustomsDeclareResponseModel declare(AlipayTradeCustomsDeclareModel alipayTradeCustomsDeclareModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayTradeCustomsDeclareResponseModel> localVarResp = this.declareWithHttpInfo(alipayTradeCustomsDeclareModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayTradeCustomsDeclareResponseModel> declareWithHttpInfo(AlipayTradeCustomsDeclareModel alipayTradeCustomsDeclareModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.declareValidateBeforeCall(alipayTradeCustomsDeclareModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayTradeCustomsDeclareResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayTradeCustomsDeclareDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call declareAsync(AlipayTradeCustomsDeclareModel alipayTradeCustomsDeclareModel, ApiCallback<AlipayTradeCustomsDeclareResponseModel> _callback) throws ApiException {
        Call localVarCall = this.declareValidateBeforeCall(alipayTradeCustomsDeclareModel, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayTradeCustomsDeclareResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call declareAsync(AlipayTradeCustomsDeclareModel alipayTradeCustomsDeclareModel, ApiCallback<AlipayTradeCustomsDeclareResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.declareValidateBeforeCall(alipayTradeCustomsDeclareModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayTradeCustomsDeclareResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(String outRequestNos, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/trade/customs/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (outRequestNos != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("out_request_nos", outRequestNos));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(String outRequestNos, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(outRequestNos, _callback, customizedParams);
        return localVarCall;
    }

    public AlipayTradeCustomsQueryResponseModel query(String outRequestNos) throws ApiException {
        ApiResponse<AlipayTradeCustomsQueryResponseModel> localVarResp = this.queryWithHttpInfo(outRequestNos, null);
        return localVarResp.getData();
    }

    public AlipayTradeCustomsQueryResponseModel query(String outRequestNos, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayTradeCustomsQueryResponseModel> localVarResp = this.queryWithHttpInfo(outRequestNos, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayTradeCustomsQueryResponseModel> queryWithHttpInfo(String outRequestNos, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(outRequestNos, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayTradeCustomsQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayTradeCustomsQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call queryAsync(String outRequestNos, ApiCallback<AlipayTradeCustomsQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(outRequestNos, _callback, null);
        Type localVarReturnType = new TypeToken<AlipayTradeCustomsQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call queryAsync(String outRequestNos, ApiCallback<AlipayTradeCustomsQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(outRequestNos, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayTradeCustomsQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

