/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayOpenAppApiFieldApplyDefaultResponse;
import com.alipay.v3.model.AlipayOpenAppApiFieldApplyModel;
import com.alipay.v3.model.AlipayOpenAppApiFieldQueryDefaultResponse;
import com.alipay.v3.model.AlipayOpenAppApiFieldQueryResponseModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayOpenAppApiFieldApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayOpenAppApiFieldApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayOpenAppApiFieldApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call applyCall(AlipayOpenAppApiFieldApplyModel data, File picture1, File picture2, File picture3, File picture4, File picture5, File video, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/app/api/field/apply";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (data != null) {
            localVarFormParams.put("data", data);
        }
        if (customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent())) {
            localVarFormParams.put("data", customizedParams.getBodyContent());
        }
        if (picture1 != null) {
            localVarFormParams.put("picture_1", picture1);
        }
        if (picture2 != null) {
            localVarFormParams.put("picture_2", picture2);
        }
        if (picture3 != null) {
            localVarFormParams.put("picture_3", picture3);
        }
        if (picture4 != null) {
            localVarFormParams.put("picture_4", picture4);
        }
        if (picture5 != null) {
            localVarFormParams.put("picture_5", picture5);
        }
        if (video != null) {
            localVarFormParams.put("video", video);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"multipart/form-data"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call applyValidateBeforeCall(AlipayOpenAppApiFieldApplyModel data, File picture1, File picture2, File picture3, File picture4, File picture5, File video, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyCall(data, picture1, picture2, picture3, picture4, picture5, video, _callback, customizedParams);
        return localVarCall;
    }

    public Object apply(AlipayOpenAppApiFieldApplyModel data, File picture1, File picture2, File picture3, File picture4, File picture5, File video) throws ApiException {
        ApiResponse<Object> localVarResp = this.applyWithHttpInfo(data, picture1, picture2, picture3, picture4, picture5, video, null);
        return localVarResp.getData();
    }

    public Object apply(AlipayOpenAppApiFieldApplyModel data, File picture1, File picture2, File picture3, File picture4, File picture5, File video, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.applyWithHttpInfo(data, picture1, picture2, picture3, picture4, picture5, video, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> applyWithHttpInfo(AlipayOpenAppApiFieldApplyModel data, File picture1, File picture2, File picture3, File picture4, File picture5, File video, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(data, picture1, picture2, picture3, picture4, picture5, video, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenAppApiFieldApplyDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call applyAsync(AlipayOpenAppApiFieldApplyModel data, File picture1, File picture2, File picture3, File picture4, File picture5, File video, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(data, picture1, picture2, picture3, picture4, picture5, video, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call applyAsync(AlipayOpenAppApiFieldApplyModel data, File picture1, File picture2, File picture3, File picture4, File picture5, File video, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.applyValidateBeforeCall(data, picture1, picture2, picture3, picture4, picture5, video, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call queryCall(ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/v3/alipay/open/app/api/field/query";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call queryValidateBeforeCall(ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryCall(_callback, customizedParams);
        return localVarCall;
    }

    public AlipayOpenAppApiFieldQueryResponseModel query() throws ApiException {
        ApiResponse<AlipayOpenAppApiFieldQueryResponseModel> localVarResp = this.queryWithHttpInfo(null);
        return localVarResp.getData();
    }

    public AlipayOpenAppApiFieldQueryResponseModel query(CustomizedParams customizedParams) throws ApiException {
        ApiResponse<AlipayOpenAppApiFieldQueryResponseModel> localVarResp = this.queryWithHttpInfo(customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<AlipayOpenAppApiFieldQueryResponseModel> queryWithHttpInfo(CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<AlipayOpenAppApiFieldQueryResponseModel>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayOpenAppApiFieldQueryDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call queryAsync(ApiCallback<AlipayOpenAppApiFieldQueryResponseModel> _callback) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(_callback, null);
        Type localVarReturnType = new TypeToken<AlipayOpenAppApiFieldQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call queryAsync(ApiCallback<AlipayOpenAppApiFieldQueryResponseModel> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.queryValidateBeforeCall(_callback, customizedParams);
        Type localVarReturnType = new TypeToken<AlipayOpenAppApiFieldQueryResponseModel>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

