/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.v3.api;

import com.alipay.v3.ApiCallback;
import com.alipay.v3.ApiClient;
import com.alipay.v3.ApiException;
import com.alipay.v3.ApiResponse;
import com.alipay.v3.Configuration;
import com.alipay.v3.JSON;
import com.alipay.v3.Pair;
import com.alipay.v3.model.AbstractOpenApiSchema;
import com.alipay.v3.model.AlipayEbppInvoiceAuthSignDefaultResponse;
import com.alipay.v3.model.AlipayEbppInvoiceAuthSignModel;
import com.alipay.v3.model.AlipayEbppInvoiceAuthUnsignDefaultResponse;
import com.alipay.v3.model.AlipayEbppInvoiceAuthUnsignModel;
import com.alipay.v3.util.AlipayLogger;
import com.alipay.v3.util.model.CustomizedParams;
import com.google.common.base.Strings;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;

public class AlipayEbppInvoiceAuthApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public AlipayEbppInvoiceAuthApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AlipayEbppInvoiceAuthApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    public Call signCall(AlipayEbppInvoiceAuthSignModel alipayEbppInvoiceAuthSignModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayEbppInvoiceAuthSignModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayEbppInvoiceAuthSignModel;
        String localVarPath = "/v3/alipay/ebpp/invoice/auth/sign";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call signValidateBeforeCall(AlipayEbppInvoiceAuthSignModel alipayEbppInvoiceAuthSignModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.signCall(alipayEbppInvoiceAuthSignModel, _callback, customizedParams);
        return localVarCall;
    }

    public Object sign(AlipayEbppInvoiceAuthSignModel alipayEbppInvoiceAuthSignModel) throws ApiException {
        ApiResponse<Object> localVarResp = this.signWithHttpInfo(alipayEbppInvoiceAuthSignModel, null);
        return localVarResp.getData();
    }

    public Object sign(AlipayEbppInvoiceAuthSignModel alipayEbppInvoiceAuthSignModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.signWithHttpInfo(alipayEbppInvoiceAuthSignModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> signWithHttpInfo(AlipayEbppInvoiceAuthSignModel alipayEbppInvoiceAuthSignModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(alipayEbppInvoiceAuthSignModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayEbppInvoiceAuthSignDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call signAsync(AlipayEbppInvoiceAuthSignModel alipayEbppInvoiceAuthSignModel, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(alipayEbppInvoiceAuthSignModel, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call signAsync(AlipayEbppInvoiceAuthSignModel alipayEbppInvoiceAuthSignModel, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.signValidateBeforeCall(alipayEbppInvoiceAuthSignModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public Call unsignCall(AlipayEbppInvoiceAuthUnsignModel alipayEbppInvoiceAuthUnsignModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        AlipayEbppInvoiceAuthUnsignModel localVarPostBody = customizedParams != null && !Strings.isNullOrEmpty((String)customizedParams.getBodyContent()) ? customizedParams.getBodyContent() : alipayEbppInvoiceAuthUnsignModel;
        String localVarPath = "/v3/alipay/ebpp/invoice/auth/unsign";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        if (customizedParams != null) {
            if (customizedParams.getQueryParams() != null && customizedParams.getQueryParams().size() > 0) {
                for (Map.Entry<String, String> entry : customizedParams.getQueryParams().entrySet()) {
                    localVarQueryParams.addAll(this.localVarApiClient.parameterToPair(entry.getKey(), entry.getValue()));
                }
            }
            if (!Strings.isNullOrEmpty((String)customizedParams.getAppAuthToken())) {
                localVarHeaderParams.put("alipay-app-auth-token", customizedParams.getAppAuthToken());
            }
            if (customizedParams.getHeaderParams() != null && customizedParams.getHeaderParams().size() > 0) {
                localVarHeaderParams.putAll(customizedParams.getHeaderParams());
            }
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call unsignValidateBeforeCall(AlipayEbppInvoiceAuthUnsignModel alipayEbppInvoiceAuthUnsignModel, ApiCallback _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unsignCall(alipayEbppInvoiceAuthUnsignModel, _callback, customizedParams);
        return localVarCall;
    }

    public Object unsign(AlipayEbppInvoiceAuthUnsignModel alipayEbppInvoiceAuthUnsignModel) throws ApiException {
        ApiResponse<Object> localVarResp = this.unsignWithHttpInfo(alipayEbppInvoiceAuthUnsignModel, null);
        return localVarResp.getData();
    }

    public Object unsign(AlipayEbppInvoiceAuthUnsignModel alipayEbppInvoiceAuthUnsignModel, CustomizedParams customizedParams) throws ApiException {
        ApiResponse<Object> localVarResp = this.unsignWithHttpInfo(alipayEbppInvoiceAuthUnsignModel, customizedParams);
        return localVarResp.getData();
    }

    public ApiResponse<Object> unsignWithHttpInfo(AlipayEbppInvoiceAuthUnsignModel alipayEbppInvoiceAuthUnsignModel, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unsignValidateBeforeCall(alipayEbppInvoiceAuthUnsignModel, null, customizedParams);
        try {
            Type localVarReturnType = new TypeToken<Object>(){}.getType();
            return this.localVarApiClient.execute(localVarCall, localVarReturnType);
        }
        catch (ApiException e) {
            try {
                this.localVarApiClient.getJSON();
                e.setErrorObject((AbstractOpenApiSchema)JSON.getGson().fromJson(e.getResponseBody(), new TypeToken<AlipayEbppInvoiceAuthUnsignDefaultResponse>(){}.getType()));
            }
            catch (Exception ex) {
                AlipayLogger.logBizWarn(ex);
            }
            throw e;
        }
    }

    @Deprecated
    public Call unsignAsync(AlipayEbppInvoiceAuthUnsignModel alipayEbppInvoiceAuthUnsignModel, ApiCallback<Object> _callback) throws ApiException {
        Call localVarCall = this.unsignValidateBeforeCall(alipayEbppInvoiceAuthUnsignModel, _callback, null);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    @Deprecated
    public Call unsignAsync(AlipayEbppInvoiceAuthUnsignModel alipayEbppInvoiceAuthUnsignModel, ApiCallback<Object> _callback, CustomizedParams customizedParams) throws ApiException {
        Call localVarCall = this.unsignValidateBeforeCall(alipayEbppInvoiceAuthUnsignModel, _callback, customizedParams);
        Type localVarReturnType = new TypeToken<Object>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }
}

