/*
 * Copyright 1999-2020 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.alibaba.nacos.api.grpc.auto;

import static com.alibaba.nacos.shaded.io.grpc.MethodDescriptor.generateFullMethodName;
import static com.alibaba.nacos.shaded.io.grpc.stub.ClientCalls.asyncBidiStreamingCall;
import static com.alibaba.nacos.shaded.io.grpc.stub.ServerCalls.asyncBidiStreamingCall;
import static com.alibaba.nacos.shaded.io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall;

/**
 */
@com.alibaba.nacos.shaded.javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.14.0)",
    comments = "Source: nacos_grpc_service.proto")
public final class BiRequestStreamGrpc {

  private BiRequestStreamGrpc() {}

  public static final String SERVICE_NAME = "BiRequestStream";

  // Static method descriptors that strictly reflect the proto.
  private static volatile com.alibaba.nacos.shaded.io.grpc.MethodDescriptor<com.alibaba.nacos.api.grpc.auto.Payload,
      com.alibaba.nacos.api.grpc.auto.Payload> getRequestBiStreamMethod;

  @com.alibaba.nacos.shaded.io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "requestBiStream",
      requestType = com.alibaba.nacos.api.grpc.auto.Payload.class,
      responseType = com.alibaba.nacos.api.grpc.auto.Payload.class,
      methodType = com.alibaba.nacos.shaded.io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static com.alibaba.nacos.shaded.io.grpc.MethodDescriptor<com.alibaba.nacos.api.grpc.auto.Payload,
      com.alibaba.nacos.api.grpc.auto.Payload> getRequestBiStreamMethod() {
    com.alibaba.nacos.shaded.io.grpc.MethodDescriptor<com.alibaba.nacos.api.grpc.auto.Payload, com.alibaba.nacos.api.grpc.auto.Payload> getRequestBiStreamMethod;
    if ((getRequestBiStreamMethod = BiRequestStreamGrpc.getRequestBiStreamMethod) == null) {
      synchronized (BiRequestStreamGrpc.class) {
        if ((getRequestBiStreamMethod = BiRequestStreamGrpc.getRequestBiStreamMethod) == null) {
          BiRequestStreamGrpc.getRequestBiStreamMethod = getRequestBiStreamMethod = 
              com.alibaba.nacos.shaded.io.grpc.MethodDescriptor.<com.alibaba.nacos.api.grpc.auto.Payload, com.alibaba.nacos.api.grpc.auto.Payload>newBuilder()
              .setType(com.alibaba.nacos.shaded.io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(
                  "BiRequestStream", "requestBiStream"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(com.alibaba.nacos.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  com.alibaba.nacos.api.grpc.auto.Payload.getDefaultInstance()))
              .setResponseMarshaller(com.alibaba.nacos.shaded.io.grpc.protobuf.ProtoUtils.marshaller(
                  com.alibaba.nacos.api.grpc.auto.Payload.getDefaultInstance()))
                  .setSchemaDescriptor(new BiRequestStreamMethodDescriptorSupplier("requestBiStream"))
                  .build();
          }
        }
     }
     return getRequestBiStreamMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static BiRequestStreamStub newStub(com.alibaba.nacos.shaded.io.grpc.Channel channel) {
    return new BiRequestStreamStub(channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static BiRequestStreamBlockingStub newBlockingStub(
      com.alibaba.nacos.shaded.io.grpc.Channel channel) {
    return new BiRequestStreamBlockingStub(channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static BiRequestStreamFutureStub newFutureStub(
      com.alibaba.nacos.shaded.io.grpc.Channel channel) {
    return new BiRequestStreamFutureStub(channel);
  }

  /**
   */
  public static abstract class BiRequestStreamImplBase implements com.alibaba.nacos.shaded.io.grpc.BindableService {

    /**
     * <pre>
     * Sends a commonRequest
     * </pre>
     */
    public com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<com.alibaba.nacos.api.grpc.auto.Payload> requestBiStream(
        com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<com.alibaba.nacos.api.grpc.auto.Payload> responseObserver) {
      return asyncUnimplementedStreamingCall(getRequestBiStreamMethod(), responseObserver);
    }

    @Override public final com.alibaba.nacos.shaded.io.grpc.ServerServiceDefinition bindService() {
      return com.alibaba.nacos.shaded.io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
          .addMethod(
            getRequestBiStreamMethod(),
            asyncBidiStreamingCall(
              new MethodHandlers<
                com.alibaba.nacos.api.grpc.auto.Payload,
                com.alibaba.nacos.api.grpc.auto.Payload>(
                  this, METHODID_REQUEST_BI_STREAM)))
          .build();
    }
  }

  /**
   */
  public static final class BiRequestStreamStub extends com.alibaba.nacos.shaded.io.grpc.stub.AbstractStub<BiRequestStreamStub> {
    private BiRequestStreamStub(com.alibaba.nacos.shaded.io.grpc.Channel channel) {
      super(channel);
    }

    private BiRequestStreamStub(com.alibaba.nacos.shaded.io.grpc.Channel channel,
        com.alibaba.nacos.shaded.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @Override
    protected BiRequestStreamStub build(com.alibaba.nacos.shaded.io.grpc.Channel channel,
        com.alibaba.nacos.shaded.io.grpc.CallOptions callOptions) {
      return new BiRequestStreamStub(channel, callOptions);
    }

    /**
     * <pre>
     * Sends a commonRequest
     * </pre>
     */
    public com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<com.alibaba.nacos.api.grpc.auto.Payload> requestBiStream(
        com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<com.alibaba.nacos.api.grpc.auto.Payload> responseObserver) {
      return asyncBidiStreamingCall(
          getChannel().newCall(getRequestBiStreamMethod(), getCallOptions()), responseObserver);
    }
  }

  /**
   */
  public static final class BiRequestStreamBlockingStub extends com.alibaba.nacos.shaded.io.grpc.stub.AbstractStub<BiRequestStreamBlockingStub> {
    private BiRequestStreamBlockingStub(com.alibaba.nacos.shaded.io.grpc.Channel channel) {
      super(channel);
    }

    private BiRequestStreamBlockingStub(com.alibaba.nacos.shaded.io.grpc.Channel channel,
        com.alibaba.nacos.shaded.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @Override
    protected BiRequestStreamBlockingStub build(com.alibaba.nacos.shaded.io.grpc.Channel channel,
        com.alibaba.nacos.shaded.io.grpc.CallOptions callOptions) {
      return new BiRequestStreamBlockingStub(channel, callOptions);
    }
  }

  /**
   */
  public static final class BiRequestStreamFutureStub extends com.alibaba.nacos.shaded.io.grpc.stub.AbstractStub<BiRequestStreamFutureStub> {
    private BiRequestStreamFutureStub(com.alibaba.nacos.shaded.io.grpc.Channel channel) {
      super(channel);
    }

    private BiRequestStreamFutureStub(com.alibaba.nacos.shaded.io.grpc.Channel channel,
        com.alibaba.nacos.shaded.io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @Override
    protected BiRequestStreamFutureStub build(com.alibaba.nacos.shaded.io.grpc.Channel channel,
        com.alibaba.nacos.shaded.io.grpc.CallOptions callOptions) {
      return new BiRequestStreamFutureStub(channel, callOptions);
    }
  }

  private static final int METHODID_REQUEST_BI_STREAM = 0;

  private static final class MethodHandlers<Req, Resp> implements
      com.alibaba.nacos.shaded.io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      com.alibaba.nacos.shaded.io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      com.alibaba.nacos.shaded.io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      com.alibaba.nacos.shaded.io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final BiRequestStreamImplBase serviceImpl;
    private final int methodId;

    MethodHandlers(BiRequestStreamImplBase serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @Override
    @SuppressWarnings("unchecked")
    public void invoke(Req request, com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        default:
          throw new AssertionError();
      }
    }

    @Override
    @SuppressWarnings("unchecked")
    public com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<Req> invoke(
        com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_REQUEST_BI_STREAM:
          return (com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<Req>) serviceImpl.requestBiStream(
              (com.alibaba.nacos.shaded.io.grpc.stub.StreamObserver<com.alibaba.nacos.api.grpc.auto.Payload>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  private static abstract class BiRequestStreamBaseDescriptorSupplier
      implements com.alibaba.nacos.shaded.io.grpc.protobuf.ProtoFileDescriptorSupplier, com.alibaba.nacos.shaded.io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    BiRequestStreamBaseDescriptorSupplier() {}

    @Override
    public com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return com.alibaba.nacos.api.grpc.auto.NacosGrpcService.getDescriptor();
    }

    @Override
    public com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("BiRequestStream");
    }
  }

  private static final class BiRequestStreamFileDescriptorSupplier
      extends BiRequestStreamBaseDescriptorSupplier {
    BiRequestStreamFileDescriptorSupplier() {}
  }

  private static final class BiRequestStreamMethodDescriptorSupplier
      extends BiRequestStreamBaseDescriptorSupplier
      implements com.alibaba.nacos.shaded.io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    BiRequestStreamMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @Override
    public com.alibaba.nacos.shaded.com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile com.alibaba.nacos.shaded.io.grpc.ServiceDescriptor serviceDescriptor;

  public static com.alibaba.nacos.shaded.io.grpc.ServiceDescriptor getServiceDescriptor() {
    com.alibaba.nacos.shaded.io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (BiRequestStreamGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = com.alibaba.nacos.shaded.io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new BiRequestStreamFileDescriptorSupplier())
              .addMethod(getRequestBiStreamMethod())
              .build();
        }
      }
    }
    return result;
  }
}
