/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.core.model.Resource;
import com.alibaba.fescar.rm.DefaultResourceManager;
import com.alibaba.fescar.rm.datasource.AbstractDataSourceProxy;
import com.alibaba.fescar.rm.datasource.ConnectionProxy;
import java.sql.Connection;
import java.sql.SQLException;

public class DataSourceProxy
extends AbstractDataSourceProxy
implements Resource {
    private String resourceGroupId = "DEFAULT";
    private boolean managed = false;

    public DataSourceProxy(DruidDataSource targetDataSource) {
        super(targetDataSource);
    }

    public DataSourceProxy(DruidDataSource targetDataSource, String resourceGroupId) {
        super(targetDataSource);
        this.resourceGroupId = resourceGroupId;
    }

    private void assertManaged() {
        if (!this.managed) {
            DefaultResourceManager.get().registerResource((Resource)this);
            this.managed = true;
        }
    }

    public Connection getPlainConnection() throws SQLException {
        return this.targetDataSource.getConnection();
    }

    public String getDbType() {
        return this.targetDataSource.getDbType();
    }

    @Override
    public ConnectionProxy getConnection() throws SQLException {
        this.assertManaged();
        DruidPooledConnection targetConnection = this.targetDataSource.getConnection();
        return new ConnectionProxy(this, (Connection)targetConnection, this.targetDataSource.getDbType());
    }

    @Override
    public ConnectionProxy getConnection(String username, String password) throws SQLException {
        this.assertManaged();
        Connection targetConnection = this.targetDataSource.getConnection(username, password);
        return new ConnectionProxy(this, targetConnection, this.targetDataSource.getDbType());
    }

    public String getResourceGroupId() {
        return this.resourceGroupId;
    }

    public String getResourceId() {
        return this.targetDataSource.getUrl();
    }

    public BranchType getBranchType() {
        return BranchType.AT;
    }
}

