/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource.undo.mysql.keyword;

import com.alibaba.fescar.rm.datasource.undo.KeywordChecker;
import org.apache.commons.lang3.StringUtils;

public class MySQLKeywordChecker
implements KeywordChecker {
    private static volatile KeywordChecker keywordChecker;

    private MySQLKeywordChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeywordChecker getInstance() {
        if (keywordChecker != null) return keywordChecker;
        Class<MySQLKeywordChecker> clazz = MySQLKeywordChecker.class;
        synchronized (MySQLKeywordChecker.class) {
            if (keywordChecker != null) return keywordChecker;
            keywordChecker = new MySQLKeywordChecker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return keywordChecker;
        }
    }

    @Override
    public boolean check(String fieldOrTableName) {
        try {
            if (StringUtils.isNotBlank((CharSequence)fieldOrTableName)) {
                MySQLKeyword.valueOf(fieldOrTableName.toUpperCase());
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String checkAndReplace(String fieldOrTableName) {
        return this.check(fieldOrTableName) ? "`" + fieldOrTableName + "`" : fieldOrTableName;
    }

    private static enum MySQLKeyword {
        SELECT("SELECT"),
        DELETE("DELETE"),
        INSERT("INSERT"),
        UPDATE("UPDATE"),
        FROM("FROM"),
        HAVING("HAVING"),
        WHERE("WHERE"),
        ORDER("ORDER"),
        BY("BY"),
        GROUP("GROUP"),
        INTO("INTO"),
        AS("AS"),
        CREATE("CREATE"),
        ALTER("ALTER"),
        DROP("DROP"),
        SET("SET"),
        NULL("NULL"),
        NOT("NOT"),
        DISTINCT("DISTINCT"),
        TABLE("TABLE"),
        TABLESPACE("TABLESPACE"),
        VIEW("VIEW"),
        SEQUENCE("SEQUENCE"),
        TRIGGER("TRIGGER"),
        USER("USER"),
        INDEX("INDEX"),
        SESSION("SESSION"),
        PROCEDURE("PROCEDURE"),
        FUNCTION("FUNCTION"),
        PRIMARY("PRIMARY"),
        KEY("KEY"),
        DEFAULT("DEFAULT"),
        CONSTRAINT("CONSTRAINT"),
        CHECK("CHECK"),
        UNIQUE("UNIQUE"),
        FOREIGN("FOREIGN"),
        REFERENCES("REFERENCES"),
        EXPLAIN("EXPLAIN"),
        FOR("FOR"),
        IF("IF"),
        SORT("SORT"),
        ALL("ALL"),
        UNION("UNION"),
        EXCEPT("EXCEPT"),
        INTERSECT("INTERSECT"),
        MINUS("MINUS"),
        INNER("INNER"),
        LEFT("LEFT"),
        RIGHT("RIGHT"),
        FULL("FULL"),
        OUTER("OUTER"),
        JOIN("JOIN"),
        ON("ON"),
        SCHEMA("SCHEMA"),
        CAST("CAST"),
        COLUMN("COLUMN"),
        USE("USE"),
        DATABASE("DATABASE"),
        TO("TO"),
        AND("AND"),
        OR("OR"),
        XOR("XOR"),
        CASE("CASE"),
        WHEN("WHEN"),
        THEN("THEN"),
        ELSE("ELSE"),
        ELSIF("ELSIF"),
        END("END"),
        EXISTS("EXISTS"),
        IN("IN"),
        CONTAINS("CONTAINS"),
        RLIKE("RLIKE"),
        FULLTEXT("FULLTEXT"),
        NEW("NEW"),
        ASC("ASC"),
        DESC("DESC"),
        IS("IS"),
        LIKE("LIKE"),
        ESCAPE("ESCAPE"),
        BETWEEN("BETWEEN"),
        VALUES("VALUES"),
        INTERVAL("INTERVAL"),
        LOCK("LOCK"),
        SOME("SOME"),
        ANY("ANY"),
        TRUNCATE("TRUNCATE"),
        RETURN("RETURN"),
        TRUE("TRUE"),
        FALSE("FALSE"),
        LIMIT("LIMIT"),
        KILL("KILL"),
        IDENTIFIED("IDENTIFIED"),
        PASSWORD("PASSWORD"),
        ALGORITHM("ALGORITHM"),
        DUAL("DUAL"),
        BINARY("BINARY"),
        SHOW("SHOW"),
        REPLACE("REPLACE"),
        WHILE("WHILE"),
        DO("DO"),
        LEAVE("LEAVE"),
        ITERATE("ITERATE"),
        REPEAT("REPEAT"),
        UNTIL("UNTIL"),
        OPEN("OPEN"),
        CLOSE("CLOSE"),
        OUT("OUT"),
        INOUT("INOUT"),
        EXIT("EXIT"),
        UNDO("UNDO"),
        SQLSTATE("SQLSTATE"),
        CONDITION("CONDITION"),
        DIV("DIV");

        public final String name;

        private MySQLKeyword() {
            this(null);
        }

        private MySQLKeyword(String name) {
            this.name = name;
        }
    }
}

