/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fescar.rm.datasource;

import com.alibaba.fescar.core.exception.TransactionException;
import com.alibaba.fescar.core.exception.TransactionExceptionCode;
import com.alibaba.fescar.core.model.BranchStatus;
import com.alibaba.fescar.core.model.BranchType;
import com.alibaba.fescar.rm.datasource.AbstractConnectionProxy;
import com.alibaba.fescar.rm.datasource.ConnectionContext;
import com.alibaba.fescar.rm.datasource.DataSourceManager;
import com.alibaba.fescar.rm.datasource.DataSourceProxy;
import com.alibaba.fescar.rm.datasource.exec.LockConflictException;
import com.alibaba.fescar.rm.datasource.undo.SQLUndoLog;
import com.alibaba.fescar.rm.datasource.undo.UndoLogManager;
import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProxy
extends AbstractConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProxy.class);
    private ConnectionContext context = new ConnectionContext();

    public ConnectionProxy(DataSourceProxy dataSourceProxy, Connection targetConnection, String dbType) {
        super(dataSourceProxy, targetConnection, dbType);
    }

    public ConnectionContext getContext() {
        return this.context;
    }

    public void bind(String xid) {
        this.context.bind(xid);
    }

    public void setGlobalLockRequire(boolean isLock) {
        this.context.setGlobalLockRequire(isLock);
    }

    public boolean isGlobalLockRequire() {
        return this.context.isGlobalLockRequire();
    }

    public void checkLock(String lockKeys) throws SQLException {
        try {
            boolean lockable = DataSourceManager.get().lockQuery(BranchType.AT, this.getDataSourceProxy().getResourceId(), this.context.getXid(), lockKeys);
            if (!lockable) {
                throw new LockConflictException();
            }
        }
        catch (TransactionException e) {
            this.recognizeLockKeyConflictException(e);
        }
    }

    public void register(String lockKeys) throws SQLException {
        try {
            DataSourceManager.get().branchRegister(BranchType.AT, this.getDataSourceProxy().getResourceId(), null, this.context.getXid(), lockKeys);
        }
        catch (TransactionException e) {
            this.recognizeLockKeyConflictException(e);
        }
    }

    private void recognizeLockKeyConflictException(TransactionException te) throws SQLException {
        if (te.getCode() == TransactionExceptionCode.LockKeyConflict) {
            throw new LockConflictException();
        }
        throw new SQLException(te);
    }

    public void appendUndoLog(SQLUndoLog sqlUndoLog) {
        this.context.appendUndoItem(sqlUndoLog);
    }

    public void appendLockKey(String lockKey) {
        this.context.appendLockKey(lockKey);
    }

    @Override
    public void commit() throws SQLException {
        if (this.context.inGlobalTransaction()) {
            this.processGlobalTransactionCommit();
        } else if (this.context.isGlobalLockRequire()) {
            this.processLocalCommitWithGlobalLocks();
        } else {
            this.targetConnection.commit();
        }
    }

    private void processLocalCommitWithGlobalLocks() throws SQLException {
        this.checkLock(this.context.buildLockKeys());
        try {
            this.targetConnection.commit();
        }
        catch (Throwable ex) {
            throw new SQLException(ex);
        }
        this.context.reset();
    }

    private void processGlobalTransactionCommit() throws SQLException {
        block5: {
            try {
                this.register();
            }
            catch (TransactionException e) {
                this.recognizeLockKeyConflictException(e);
            }
            try {
                if (this.context.hasUndoLog()) {
                    UndoLogManager.flushUndoLogs(this);
                }
                this.targetConnection.commit();
            }
            catch (Throwable ex) {
                this.report(false);
                if (!(ex instanceof SQLException)) break block5;
                throw new SQLException(ex);
            }
        }
        this.report(true);
        this.context.reset();
    }

    private void register() throws TransactionException {
        Long branchId = DataSourceManager.get().branchRegister(BranchType.AT, this.getDataSourceProxy().getResourceId(), null, this.context.getXid(), this.context.buildLockKeys());
        this.context.setBranchId(branchId);
    }

    @Override
    public void rollback() throws SQLException {
        this.targetConnection.rollback();
        if (this.context.inGlobalTransaction() && this.context.isBranchRegistered()) {
            this.report(false);
        }
        this.context.reset();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit && !this.getAutoCommit()) {
            this.commit();
        }
        this.targetConnection.setAutoCommit(autoCommit);
    }

    private void report(boolean commitDone) throws SQLException {
        int retry = 5;
        while (retry > 0) {
            try {
                DataSourceManager.get().branchReport(this.context.getXid(), this.context.getBranchId(), commitDone ? BranchStatus.PhaseOne_Done : BranchStatus.PhaseOne_Failed, null);
                return;
            }
            catch (Throwable ex) {
                LOGGER.error("Failed to report [" + this.context.getBranchId() + "/" + this.context.getXid() + "] commit done [" + commitDone + "] Retry Countdown: " + retry);
                if (--retry != 0) continue;
                throw new SQLException("Failed to report branch status " + commitDone, ex);
            }
        }
    }
}

