/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.common.domain;

import com.alibaba.tmq.common.domain.ConsumerKey;
import com.alibaba.tmq.common.domain.MessageStatus;
import com.alibaba.tmq.common.remoting.protocol.RemotingSerializable;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetryConsumers
implements Serializable {
    private static final Log logger = LogFactory.getLog(RetryConsumers.class);
    private static final long serialVersionUID = 5844883016276114132L;
    private ConcurrentHashMap<ConsumerKey, MessageStatus> consumerTable = new ConcurrentHashMap();
    private MessageStatus messageStatus = MessageStatus.SUCCESS;

    public static RetryConsumers newInstance(String json) {
        RetryConsumers retryConsumers = null;
        try {
            retryConsumers = RemotingSerializable.fromJson(json, RetryConsumers.class);
        }
        catch (Throwable e) {
            logger.error((Object)("[RetryConsumers]: newInstance error, json:" + json), e);
        }
        return retryConsumers;
    }

    public String toString() {
        return RemotingSerializable.toJson(this, false);
    }

    public void add(ConsumerKey consumerKey, MessageStatus messageStatus) {
        try {
            this.consumerTable.put(consumerKey, messageStatus);
        }
        catch (Throwable e) {
            logger.error((Object)("[RetryConsumers]: add error, consumerKey:" + consumerKey + ", messageStatus:" + messageStatus), e);
        }
    }

    public void remove(ConsumerKey consumerKey) {
        try {
            this.consumerTable.remove(consumerKey);
        }
        catch (Throwable e) {
            logger.error((Object)("[RetryConsumers]: remove error, consumerKey:" + consumerKey), e);
        }
    }

    public ConcurrentHashMap<ConsumerKey, MessageStatus> getConsumerTable() {
        return this.consumerTable;
    }

    public void setConsumerTable(ConcurrentHashMap<ConsumerKey, MessageStatus> consumerTable) {
        this.consumerTable = consumerTable;
    }

    public MessageStatus getMessageStatus() {
        return this.messageStatus;
    }

    public void setMessageStatus(MessageStatus messageStatus) {
        this.messageStatus = messageStatus;
    }
}

