/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.remoting.timer;

import com.alibaba.tmq.client.TMQFactory;
import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.system.consumer.executer.ConsumerExecuter;
import com.alibaba.tmq.client.system.consumer.listener.MessageListener;
import com.alibaba.tmq.client.system.producer.executer.NormalProducerExecuter;
import com.alibaba.tmq.client.system.producer.executer.TransactionProducerExecuter;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.ConsumerKey;
import com.alibaba.tmq.common.util.ListUtil;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientHeartBeatTimer
extends TimerTask
implements Constants {
    private static final Log logger = LogFactory.getLog(ClientHeartBeatTimer.class);

    @Override
    public void run() {
        try {
            List<String> serverList = ClientContext.zookeeper.getServerList();
            if (ListUtil.isEmpty(serverList)) {
                logger.warn((Object)("[ClientHeartBeatTimer]: serverList is empty, clientConfig:" + ClientContext.clientConfig));
            } else {
                ClientContext.clientRemoting.setCachedServerList(serverList);
                this.checkHeartBeat(serverList);
            }
            if (StringUtil.isNotBlank(ClientContext.clientConfig.getBackupDomainName())) {
                List<String> backupServerList = ClientContext.zookeeper.getbackupServerList();
                if (ListUtil.isEmpty(backupServerList)) {
                    logger.warn((Object)("[ClientHeartBeatTimer]: backupServerList is empty, clientConfig:" + ClientContext.clientConfig));
                } else {
                    ClientContext.clientRemoting.setCachedBackupServerList(backupServerList);
                    this.checkHeartBeat(backupServerList);
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)("[ClientHeartBeatTimer]: run error, clientConfig:" + ClientContext.clientConfig), e);
        }
    }

    private void checkHeartBeat(List<String> serverList) {
        for (String server : serverList) {
            try {
                this.checkProducerHeartBeat(server);
                this.checkConsumerHeartBeat(server);
            }
            catch (Throwable e) {
                logger.error((Object)("[ClientHeartBeatTimer]: checkHeartBeat error, clientConfig:" + ClientContext.clientConfig + ", server:" + server), e);
            }
        }
    }

    private void checkProducerHeartBeat(String server) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, NormalProducerExecuter>> normalProducerTable = TMQFactory.getNormalproducertable();
        this.checkNormalProducerHeartBeat(server, normalProducerTable, "normalProducerTable");
        ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionProducerExecuter>> transactionProducerTable = TMQFactory.getTransactionproducertable();
        this.checkTransactionProducerHeartBeat(server, transactionProducerTable, "transactionProducerTable");
    }

    private void checkNormalProducerHeartBeat(String server, ConcurrentHashMap<String, ConcurrentHashMap<String, NormalProducerExecuter>> producerTable, String source) {
        for (Map.Entry<String, ConcurrentHashMap<String, NormalProducerExecuter>> entry : producerTable.entrySet()) {
            String producerId = entry.getKey();
            ConcurrentHashMap<String, NormalProducerExecuter> producerMap = entry.getValue();
            for (Map.Entry<String, NormalProducerExecuter> producerEntry : producerMap.entrySet()) {
                String instanceName = producerEntry.getKey();
                try {
                    ClientContext.clientRemoting.connectServer(instanceName, server, 0, producerId, "NULL", "NULL");
                }
                catch (Throwable e) {
                    logger.error((Object)("[ClientHeartBeatTimer]: checkNormalProducerHeartBeat connectServer error, server:" + server + ", clientConfig:" + ClientContext.clientConfig + ", producerId:" + producerId + ", instanceName:" + instanceName), e);
                }
            }
        }
    }

    private void checkTransactionProducerHeartBeat(String server, ConcurrentHashMap<String, ConcurrentHashMap<String, TransactionProducerExecuter>> producerTable, String source) {
        for (Map.Entry<String, ConcurrentHashMap<String, TransactionProducerExecuter>> entry : producerTable.entrySet()) {
            String producerId = entry.getKey();
            ConcurrentHashMap<String, TransactionProducerExecuter> producerMap = entry.getValue();
            for (Map.Entry<String, TransactionProducerExecuter> producerEntry : producerMap.entrySet()) {
                String instanceName = producerEntry.getKey();
                try {
                    ClientContext.clientRemoting.connectServer(instanceName, server, 0, producerId, "NULL", "NULL");
                }
                catch (Throwable e) {
                    logger.error((Object)("[ClientHeartBeatTimer]: checkTransactionProducerHeartBeat connectServer error, server:" + server + ", clientConfig:" + ClientContext.clientConfig + ", producerId:" + producerId + ", instanceName:" + instanceName), e);
                }
            }
        }
    }

    private void checkConsumerHeartBeat(String server) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, ConsumerExecuter>> consumerTable = TMQFactory.getConsumertable();
        for (Map.Entry<String, ConcurrentHashMap<String, ConsumerExecuter>> entry : consumerTable.entrySet()) {
            String consumerId = entry.getKey();
            ConcurrentHashMap<String, ConsumerExecuter> consumerMap = entry.getValue();
            for (Map.Entry<String, ConsumerExecuter> consumerEntry : consumerMap.entrySet()) {
                String instanceName = consumerEntry.getKey();
                ConsumerExecuter consumerExecuter = consumerEntry.getValue();
                ConcurrentHashMap<ConsumerKey, MessageListener> listenerTable = consumerExecuter.getListenerTable();
                for (Map.Entry<ConsumerKey, MessageListener> listenerEntry : listenerTable.entrySet()) {
                    ConsumerKey consumerKey = listenerEntry.getKey();
                    try {
                        ClientContext.clientRemoting.connectServer(instanceName, server, 1, consumerId, consumerKey.getTopic(), consumerKey.getTag());
                    }
                    catch (Throwable e) {
                        logger.error((Object)("[ClientHeartBeatTimer]: connectServer error, server:" + server + ", clientConfig:" + ClientContext.clientConfig + ", consumerId:" + consumerId + ", instanceName:" + instanceName + ", consumerKey:" + consumerKey), e);
                    }
                }
            }
        }
    }
}

