/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.tmq.client.logger;

import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.remoting.ClientRemoting;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.TracePoint;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.logger.LoggerEvent;
import com.alibaba.tmq.common.util.ListUtil;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientLoggerEvent
extends ClientContext
implements LoggerEvent,
Constants {
    private static final Log logger = LogFactory.getLog(ClientLoggerEvent.class);

    @Override
    public void onEvent(List<TracePoint> tracePointList) {
        List<String> serverList = clientRemoting.getServerList();
        if (StringUtil.isNotBlank(clientConfig.getBackupDomainName())) {
            serverList = clientRemoting.getbackupServerList();
        }
        if (ListUtil.isEmpty(serverList)) {
            logger.error((Object)("[ClientLoggerEvent]: serverList is empty, clientConfig:" + clientConfig));
            return;
        }
        Collections.shuffle(serverList);
        for (String server : serverList) {
            Result<Boolean> connectResult = null;
            try {
                ConnectionChannel connectionChannel = new ConnectionChannel(server, 0, null);
                InvocationContext.setConnectionChannel(connectionChannel);
                connectResult = ClientRemoting.serverService.trace(tracePointList);
            }
            catch (Throwable e) {
                logger.warn((Object)("[ClientLoggerEvent]: trace error, clientConfig:" + clientConfig + ", server:" + server + ", tracePointList:" + tracePointList), e);
            }
            if (connectResult != null && connectResult.getData().booleanValue()) {
                return;
            }
            logger.warn((Object)("[ClientLoggerEvent]: trace failed, clientConfig:" + clientConfig + ", server:" + server + ", tracePointList:" + tracePointList));
        }
    }
}

