/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.value;

import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.util.DateTimeUtils;
import com.alibaba.dts.shade.org.h2.util.MathUtils;
import com.alibaba.dts.shade.org.h2.value.CompareMode;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueDate;
import com.alibaba.dts.shade.org.h2.value.ValueDecimal;
import com.alibaba.dts.shade.org.h2.value.ValueTime;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class ValueTimestamp
extends Value {
    public static final int PRECISION = 23;
    static final int DISPLAY_SIZE = 23;
    static final int DEFAULT_SCALE = 10;
    private final long dateValue;
    private final long timeNanos;

    private ValueTimestamp(long dateValue, long timeNanos) {
        this.dateValue = dateValue;
        if (timeNanos < 0L || timeNanos >= 86400000000000L) {
            throw new IllegalArgumentException("timeNanos out of range " + timeNanos);
        }
        this.timeNanos = timeNanos;
    }

    public static ValueTimestamp fromDateValueAndNanos(long dateValue, long timeNanos) {
        return (ValueTimestamp)Value.cache(new ValueTimestamp(dateValue, timeNanos));
    }

    public static ValueTimestamp get(Timestamp timestamp) {
        long ms = timestamp.getTime();
        long nanos = timestamp.getNanos() % 1000000;
        long dateValue = DateTimeUtils.dateValueFromDate(ms);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos += DateTimeUtils.nanosFromDate(ms));
    }

    public static ValueTimestamp fromMillisNanos(long ms, int nanos) {
        long dateValue = DateTimeUtils.dateValueFromDate(ms);
        long timeNanos = (long)nanos + DateTimeUtils.nanosFromDate(ms);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, timeNanos);
    }

    public static ValueTimestamp fromMillis(long ms) {
        long dateValue = DateTimeUtils.dateValueFromDate(ms);
        long nanos = DateTimeUtils.nanosFromDate(ms);
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos);
    }

    public static ValueTimestamp parse(String s) {
        try {
            return ValueTimestamp.parseTry(s);
        }
        catch (Exception e) {
            throw DbException.get(22007, e, "TIMESTAMP", s);
        }
    }

    private static ValueTimestamp parseTry(String s) {
        long nanos;
        int timeStart;
        int dateEnd = s.indexOf(32);
        if (dateEnd < 0) {
            dateEnd = s.indexOf(84);
        }
        if (dateEnd < 0) {
            dateEnd = s.length();
            timeStart = -1;
        } else {
            timeStart = dateEnd + 1;
        }
        long dateValue = DateTimeUtils.parseDateValue(s, 0, dateEnd);
        if (timeStart < 0) {
            nanos = 0L;
        } else {
            int timeEnd = s.length();
            TimeZone tz = null;
            if (s.endsWith("Z")) {
                tz = TimeZone.getTimeZone("UTC");
                --timeEnd;
            } else {
                String tzName;
                int timeZoneStart = s.indexOf(43, dateEnd);
                if (timeZoneStart < 0) {
                    timeZoneStart = s.indexOf(45, dateEnd);
                }
                if (timeZoneStart >= 0) {
                    tzName = "GMT" + s.substring(timeZoneStart);
                    tz = TimeZone.getTimeZone(tzName);
                    if (!tz.getID().startsWith(tzName)) {
                        throw new IllegalArgumentException(tzName + " (" + tz.getID() + "?)");
                    }
                    timeEnd = timeZoneStart;
                } else {
                    timeZoneStart = s.indexOf(32, dateEnd + 1);
                    if (timeZoneStart > 0) {
                        tzName = s.substring(timeZoneStart + 1);
                        tz = TimeZone.getTimeZone(tzName);
                        if (!tz.getID().startsWith(tzName)) {
                            throw new IllegalArgumentException(tzName);
                        }
                        timeEnd = timeZoneStart;
                    }
                }
            }
            nanos = DateTimeUtils.parseTimeNanos(s, dateEnd + 1, timeEnd, true);
            if (tz != null) {
                int year = DateTimeUtils.yearFromDateValue(dateValue);
                int month = DateTimeUtils.monthFromDateValue(dateValue);
                int day = DateTimeUtils.dayFromDateValue(dateValue);
                long ms = nanos / 1000000L;
                nanos -= ms * 1000000L;
                long second = ms / 1000L;
                ms -= second * 1000L;
                int minute = (int)(second / 60L);
                second -= (long)(minute * 60);
                int hour = minute / 60;
                long millis = DateTimeUtils.getMillis(tz, year, month, day, hour, minute -= hour * 60, (int)second, (int)ms);
                ms = DateTimeUtils.convertToLocal(new Date(millis), Calendar.getInstance(TimeZone.getTimeZone("UTC")));
                long md = 86400000L;
                long absoluteDay = (ms >= 0L ? ms : ms - md + 1L) / md;
                dateValue = DateTimeUtils.dateValueFromAbsoluteDay(absoluteDay);
                nanos += (ms -= absoluteDay * md) * 1000000L;
            }
        }
        return ValueTimestamp.fromDateValueAndNanos(dateValue, nanos);
    }

    public long getDateValue() {
        return this.dateValue;
    }

    public long getTimeNanos() {
        return this.timeNanos;
    }

    @Override
    public Timestamp getTimestamp() {
        return DateTimeUtils.convertDateValueToTimestamp(this.dateValue, this.timeNanos);
    }

    @Override
    public int getType() {
        return 11;
    }

    @Override
    public String getString() {
        StringBuilder buff = new StringBuilder(23);
        ValueDate.appendDate(buff, this.dateValue);
        buff.append(' ');
        ValueTime.appendTime(buff, this.timeNanos, true);
        return buff.toString();
    }

    @Override
    public String getSQL() {
        return "TIMESTAMP '" + this.getString() + "'";
    }

    @Override
    public long getPrecision() {
        return 23L;
    }

    @Override
    public int getScale() {
        return 10;
    }

    @Override
    public int getDisplaySize() {
        return 23;
    }

    @Override
    public Value convertScale(boolean onlyToSmallerScale, int targetScale) {
        if (targetScale >= 10) {
            return this;
        }
        if (targetScale < 0) {
            throw DbException.getInvalidValueException("scale", targetScale);
        }
        long n = this.timeNanos;
        BigDecimal bd = BigDecimal.valueOf(n);
        bd = bd.movePointLeft(9);
        bd = ValueDecimal.setScale(bd, targetScale);
        long n2 = (bd = bd.movePointRight(9)).longValue();
        if (n2 == n) {
            return this;
        }
        return ValueTimestamp.fromDateValueAndNanos(this.dateValue, n2);
    }

    @Override
    protected int compareSecure(Value o, CompareMode mode) {
        ValueTimestamp t = (ValueTimestamp)o;
        int c = MathUtils.compareLong(this.dateValue, t.dateValue);
        if (c != 0) {
            return c;
        }
        return MathUtils.compareLong(this.timeNanos, t.timeNanos);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ValueTimestamp)) {
            return false;
        }
        ValueTimestamp x = (ValueTimestamp)other;
        return this.dateValue == x.dateValue && this.timeNanos == x.timeNanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.dateValue ^ this.dateValue >>> 32 ^ this.timeNanos ^ this.timeNanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTimestamp();
    }

    @Override
    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setTimestamp(parameterIndex, this.getTimestamp());
    }

    @Override
    public Value add(Value v) {
        ValueTimestamp t = (ValueTimestamp)v.convertTo(11);
        long d1 = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long d2 = DateTimeUtils.absoluteDayFromDateValue(t.dateValue);
        return DateTimeUtils.normalizeTimestamp(d1 + d2, this.timeNanos + t.timeNanos);
    }

    @Override
    public Value subtract(Value v) {
        ValueTimestamp t = (ValueTimestamp)v.convertTo(11);
        long d1 = DateTimeUtils.absoluteDayFromDateValue(this.dateValue);
        long d2 = DateTimeUtils.absoluteDayFromDateValue(t.dateValue);
        return DateTimeUtils.normalizeTimestamp(d1 - d2, this.timeNanos - t.timeNanos);
    }
}

