/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.util;

import com.alibaba.dts.shade.org.h2.util.Cache;
import com.alibaba.dts.shade.org.h2.util.CacheLRU;
import com.alibaba.dts.shade.org.h2.util.CacheObject;
import com.alibaba.dts.shade.org.h2.util.CacheWriter;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.SmallLRUCache;
import java.util.ArrayList;

public class CacheTQ
implements Cache {
    static final String TYPE_NAME = "TQ";
    private final Cache lru;
    private final Cache fifo;
    private final SmallLRUCache<Integer, Object> recentlyUsed = SmallLRUCache.newInstance(1024);
    private int lastUsed = -1;
    private int maxMemory;

    CacheTQ(CacheWriter writer, int maxMemoryKb) {
        this.maxMemory = maxMemoryKb;
        this.lru = new CacheLRU(writer, (int)((double)maxMemoryKb * 0.8), false);
        this.fifo = new CacheLRU(writer, (int)((double)maxMemoryKb * 0.2), true);
        this.setMaxMemory(4 * maxMemoryKb);
    }

    @Override
    public void clear() {
        this.lru.clear();
        this.fifo.clear();
        this.recentlyUsed.clear();
        this.lastUsed = -1;
    }

    @Override
    public CacheObject find(int pos) {
        CacheObject r = this.lru.find(pos);
        if (r == null) {
            r = this.fifo.find(pos);
        }
        return r;
    }

    @Override
    public CacheObject get(int pos) {
        CacheObject r = this.lru.find(pos);
        if (r != null) {
            return r;
        }
        r = this.fifo.find(pos);
        if (r != null && !r.isStream()) {
            if (this.recentlyUsed.get(pos) != null) {
                if (this.lastUsed != pos) {
                    this.fifo.remove(pos);
                    this.lru.put(r);
                }
            } else {
                this.recentlyUsed.put(pos, this);
            }
            this.lastUsed = pos;
        }
        return r;
    }

    @Override
    public ArrayList<CacheObject> getAllChanged() {
        ArrayList<CacheObject> changed = New.arrayList();
        changed.addAll(this.lru.getAllChanged());
        changed.addAll(this.fifo.getAllChanged());
        return changed;
    }

    @Override
    public int getMaxMemory() {
        return this.maxMemory;
    }

    @Override
    public int getMemory() {
        return this.lru.getMemory() + this.fifo.getMemory();
    }

    @Override
    public void put(CacheObject r) {
        if (r.isStream()) {
            this.fifo.put(r);
        } else if (this.recentlyUsed.get(r.getPos()) != null) {
            this.lru.put(r);
        } else {
            this.fifo.put(r);
            this.lastUsed = r.getPos();
        }
    }

    @Override
    public boolean remove(int pos) {
        boolean result = this.lru.remove(pos);
        if (!result) {
            result = this.fifo.remove(pos);
        }
        this.recentlyUsed.remove(pos);
        return result;
    }

    @Override
    public void setMaxMemory(int maxMemoryKb) {
        this.maxMemory = maxMemoryKb;
        this.lru.setMaxMemory((int)((double)maxMemoryKb * 0.8));
        this.fifo.setMaxMemory((int)((double)maxMemoryKb * 0.2));
        this.recentlyUsed.setMaxSize(4 * maxMemoryKb);
    }

    @Override
    public CacheObject update(int pos, CacheObject record) {
        if (this.lru.find(pos) != null) {
            return this.lru.update(pos, record);
        }
        return this.fifo.update(pos, record);
    }
}

