/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.util;

import com.alibaba.dts.shade.org.h2.util.Cache;
import com.alibaba.dts.shade.org.h2.util.CacheObject;
import java.util.ArrayList;
import java.util.Map;

class CacheSecondLevel
implements Cache {
    private final Cache baseCache;
    private final Map<Integer, CacheObject> map;

    CacheSecondLevel(Cache cache, Map<Integer, CacheObject> map) {
        this.baseCache = cache;
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
        this.baseCache.clear();
    }

    @Override
    public CacheObject find(int pos) {
        CacheObject ret = this.baseCache.find(pos);
        if (ret == null) {
            ret = this.map.get(pos);
        }
        return ret;
    }

    @Override
    public CacheObject get(int pos) {
        CacheObject ret = this.baseCache.get(pos);
        if (ret == null) {
            ret = this.map.get(pos);
        }
        return ret;
    }

    @Override
    public ArrayList<CacheObject> getAllChanged() {
        return this.baseCache.getAllChanged();
    }

    @Override
    public int getMaxMemory() {
        return this.baseCache.getMaxMemory();
    }

    @Override
    public int getMemory() {
        return this.baseCache.getMemory();
    }

    @Override
    public void put(CacheObject r) {
        this.baseCache.put(r);
        this.map.put(r.getPos(), r);
    }

    @Override
    public boolean remove(int pos) {
        boolean result = this.baseCache.remove(pos);
        return result |= this.map.remove(pos) != null;
    }

    @Override
    public void setMaxMemory(int size) {
        this.baseCache.setMaxMemory(size);
    }

    @Override
    public CacheObject update(int pos, CacheObject record) {
        CacheObject oldRec = this.baseCache.update(pos, record);
        this.map.put(pos, record);
        return oldRec;
    }
}

