/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.store;

import com.alibaba.dts.shade.org.h2.util.IOUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class DataReader
extends Reader {
    private final InputStream in;

    public DataReader(InputStream in) {
        this.in = in;
    }

    public byte readByte() throws IOException {
        int x = this.in.read();
        if (x < 0) {
            throw new FastEOFException();
        }
        return (byte)x;
    }

    public int readVarInt() throws IOException {
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        int x = b & 0x7F;
        b = this.readByte();
        if (b >= 0) {
            return x | b << 7;
        }
        x |= (b & 0x7F) << 7;
        b = this.readByte();
        if (b >= 0) {
            return x | b << 14;
        }
        x |= (b & 0x7F) << 14;
        b = this.readByte();
        if (b >= 0) {
            return x | b << 21;
        }
        return x | (b & 0x7F) << 21 | this.readByte() << 28;
    }

    public long readVarLong() throws IOException {
        long x = this.readByte();
        if (x >= 0L) {
            return x;
        }
        x &= 0x7FL;
        int s = 7;
        while (true) {
            long b = this.readByte();
            x |= (b & 0x7FL) << s;
            if (b >= 0L) {
                return x;
            }
            s += 7;
        }
    }

    public void readFully(byte[] buff, int len) throws IOException {
        int got = IOUtils.readFully(this.in, buff, len);
        if (got < len) {
            throw new FastEOFException();
        }
    }

    public String readString() throws IOException {
        int len = this.readVarInt();
        return this.readString(len);
    }

    private String readString(int len) throws IOException {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = this.readChar();
        }
        return new String(chars);
    }

    private char readChar() throws IOException {
        int x = this.readByte() & 0xFF;
        if (x < 128) {
            return (char)x;
        }
        if (x >= 224) {
            return (char)(((x & 0xF) << 12) + ((this.readByte() & 0x3F) << 6) + (this.readByte() & 0x3F));
        }
        return (char)(((x & 0x1F) << 6) + (this.readByte() & 0x3F));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public int read(char[] buff, int off, int len) throws IOException {
        int i;
        if (len == 0) {
            return 0;
        }
        try {
            for (i = 0; i < len; ++i) {
                buff[i] = this.readChar();
            }
            return len;
        }
        catch (EOFException e) {
            if (i == 0) {
                return -1;
            }
            return i;
        }
    }

    static class FastEOFException
    extends EOFException {
        private static final long serialVersionUID = 1L;

        FastEOFException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return null;
        }
    }
}

