/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.server.web;

import com.alibaba.dts.shade.javax.servlet.ServletContext;
import com.alibaba.dts.shade.javax.servlet.ServletContextEvent;
import com.alibaba.dts.shade.javax.servlet.ServletContextListener;
import com.alibaba.dts.shade.org.h2.Driver;
import com.alibaba.dts.shade.org.h2.tools.Server;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;

public class DbStarter
implements ServletContextListener {
    private Connection conn;
    private Server server;

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            Driver.load();
            ServletContext servletContext = servletContextEvent.getServletContext();
            String url = DbStarter.getParameter(servletContext, "db.url", "jdbc:h2:~/test");
            String user = DbStarter.getParameter(servletContext, "db.user", "sa");
            String password = DbStarter.getParameter(servletContext, "db.password", "sa");
            String serverParams = DbStarter.getParameter(servletContext, "db.tcpServer", null);
            if (serverParams != null) {
                String[] params = StringUtils.arraySplit(serverParams, ' ', true);
                this.server = Server.createTcpServer(params);
                this.server.start();
            }
            this.conn = DriverManager.getConnection(url, user, password);
            servletContext.setAttribute("connection", this.conn);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getParameter(ServletContext servletContext, String key, String defaultValue) {
        String value = servletContext.getInitParameter(key);
        return value == null ? defaultValue : value;
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            Statement stat = this.conn.createStatement();
            stat.execute("SHUTDOWN");
            stat.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }
}

