/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.schema;

import com.alibaba.dts.shade.org.h2.command.ddl.CreateTableData;
import com.alibaba.dts.shade.org.h2.constraint.Constraint;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.DbObject;
import com.alibaba.dts.shade.org.h2.engine.DbObjectBase;
import com.alibaba.dts.shade.org.h2.engine.DbSettings;
import com.alibaba.dts.shade.org.h2.engine.FunctionAlias;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.engine.SysProperties;
import com.alibaba.dts.shade.org.h2.engine.User;
import com.alibaba.dts.shade.org.h2.index.Index;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVPrimaryIndex;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTableEngine;
import com.alibaba.dts.shade.org.h2.schema.Constant;
import com.alibaba.dts.shade.org.h2.schema.SchemaObject;
import com.alibaba.dts.shade.org.h2.schema.SchemaObjectBase;
import com.alibaba.dts.shade.org.h2.schema.Sequence;
import com.alibaba.dts.shade.org.h2.schema.TriggerObject;
import com.alibaba.dts.shade.org.h2.table.RegularTable;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.table.TableLink;
import com.alibaba.dts.shade.org.h2.util.New;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Schema
extends DbObjectBase {
    private User owner;
    private final boolean system;
    private final HashMap<String, Table> tablesAndViews;
    private final HashMap<String, Index> indexes;
    private final HashMap<String, Sequence> sequences;
    private final HashMap<String, TriggerObject> triggers;
    private final HashMap<String, Constraint> constraints;
    private final HashMap<String, Constant> constants;
    private final HashMap<String, FunctionAlias> functions;
    private final HashSet<String> temporaryUniqueNames = New.hashSet();

    public Schema(Database database, int id, String schemaName, User owner, boolean system) {
        this.tablesAndViews = database.newStringMap();
        this.indexes = database.newStringMap();
        this.sequences = database.newStringMap();
        this.triggers = database.newStringMap();
        this.constraints = database.newStringMap();
        this.constants = database.newStringMap();
        this.functions = database.newStringMap();
        this.initDbObjectBase(database, id, schemaName, 8);
        this.owner = owner;
        this.system = system;
    }

    public boolean canDrop() {
        return !this.system;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw DbException.throwInternalError();
    }

    @Override
    public String getDropSQL() {
        return null;
    }

    @Override
    public String getCreateSQL() {
        if (this.system) {
            return null;
        }
        return "CREATE SCHEMA IF NOT EXISTS " + this.getSQL() + " AUTHORIZATION " + this.owner.getSQL();
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        SchemaObject obj;
        SchemaObjectBase obj2;
        while (this.triggers != null && this.triggers.size() > 0) {
            obj2 = (TriggerObject)this.triggers.values().toArray()[0];
            this.database.removeSchemaObject(session, obj2);
        }
        while (this.constraints != null && this.constraints.size() > 0) {
            obj2 = (Constraint)this.constraints.values().toArray()[0];
            this.database.removeSchemaObject(session, obj2);
        }
        boolean runLoopAgain = false;
        do {
            runLoopAgain = false;
            if (this.tablesAndViews == null) continue;
            for (Table obj3 : New.arrayList(this.tablesAndViews.values())) {
                if (obj3.getName() == null) continue;
                if (this.database.getDependentTable(obj3, obj3) == null) {
                    this.database.removeSchemaObject(session, obj3);
                    continue;
                }
                runLoopAgain = true;
            }
        } while (runLoopAgain);
        while (this.indexes != null && this.indexes.size() > 0) {
            obj = (Index)this.indexes.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.sequences != null && this.sequences.size() > 0) {
            obj = (Sequence)this.sequences.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.constants != null && this.constants.size() > 0) {
            obj = (Constant)this.constants.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        while (this.functions != null && this.functions.size() > 0) {
            obj = (FunctionAlias)this.functions.values().toArray()[0];
            this.database.removeSchemaObject(session, obj);
        }
        this.database.removeMeta(session, this.getId());
        this.owner = null;
        this.invalidate();
    }

    @Override
    public void checkRename() {
    }

    public User getOwner() {
        return this.owner;
    }

    private HashMap<String, SchemaObject> getMap(int type) {
        HashMap<String, SchemaObject> result;
        switch (type) {
            case 0: {
                result = this.tablesAndViews;
                break;
            }
            case 3: {
                result = this.sequences;
                break;
            }
            case 1: {
                result = this.indexes;
                break;
            }
            case 4: {
                result = this.triggers;
                break;
            }
            case 5: {
                result = this.constraints;
                break;
            }
            case 11: {
                result = this.constants;
                break;
            }
            case 9: {
                result = this.functions;
                break;
            }
            default: {
                throw DbException.throwInternalError("type=" + type);
            }
        }
        return result;
    }

    public void add(SchemaObject obj) {
        String name;
        if (SysProperties.CHECK && obj.getSchema() != this) {
            DbException.throwInternalError("wrong schema");
        }
        String key = name = obj.getName();
        if (obj.getType() == 1 || obj.getType() == 5) {
            Table table = obj.getType() == 1 ? ((Index)obj).getTable() : ((Constraint)obj).getTable();
            key = table.getName() + "." + name;
        }
        HashMap<String, SchemaObject> map = this.getMap(obj.getType());
        if (SysProperties.CHECK && map.get(key) != null) {
            DbException.throwInternalError("object already exists: " + key);
        }
        map.put(key, obj);
        this.freeUniqueName(name);
    }

    public void rename(SchemaObject obj, String newName, String oldTable) {
        int type = obj.getType();
        String key = obj.getName();
        String newKey = newName;
        HashMap<String, SchemaObject> map = this.getMap(type);
        if (oldTable != null && obj.getType() == 1 && obj instanceof MVPrimaryIndex) {
            SchemaObject primary = null;
            for (Map.Entry<String, SchemaObject> entry : map.entrySet()) {
                if (!entry.getKey().startsWith(oldTable + ".PRIMARY_KEY_")) continue;
                primary = entry.getValue();
                key = entry.getKey();
                Table table = ((Index)obj).getTable();
                newKey = table.getName() + "." + primary.getName();
                break;
            }
            if (primary != null) {
                if (SysProperties.CHECK && (obj.getName().equals(newName) || map.containsKey(newKey))) {
                    DbException.throwInternalError("object already exists: " + newKey);
                }
                obj.checkRename();
                map.remove(key);
                this.freeUniqueName(obj.getName());
                obj.rename(newName);
                map.put(newKey, primary);
                this.freeUniqueName(newName);
                return;
            }
        }
        if (obj.getType() == 1 || obj.getType() == 5) {
            Table table = obj.getType() == 1 ? ((Index)obj).getTable() : ((Constraint)obj).getTable();
            key = (oldTable == null ? table.getName() : oldTable) + "." + obj.getName();
            newKey = table.getName() + "." + newName;
        }
        if (SysProperties.CHECK) {
            if (!map.containsKey(key)) {
                DbException.throwInternalError("not found: " + key);
            }
            if (obj.getName().equals(newName) || map.containsKey(newKey)) {
                DbException.throwInternalError("object already exists: " + newKey);
            }
        }
        obj.checkRename();
        map.remove(key);
        this.freeUniqueName(obj.getName());
        obj.rename(newName);
        map.put(newKey, obj);
        this.freeUniqueName(newName);
    }

    public Table findTableOrView(Session session, String name) {
        Table table = this.tablesAndViews.get(name);
        if (table == null && session != null) {
            table = session.findLocalTempTable(name);
        }
        return table;
    }

    public Index findIndex(Session session, String tableName, String name) {
        Index index;
        if (tableName != null && name != null) {
            name = tableName + "." + name;
        }
        if ((index = this.indexes.get(name)) == null) {
            index = session.findLocalTempTableIndex(name);
        }
        return index;
    }

    public TriggerObject findTrigger(String name) {
        return this.triggers.get(name);
    }

    public Sequence findSequence(String sequenceName) {
        return this.sequences.get(sequenceName);
    }

    public Constraint findConstraint(Session session, String tableName, String name) {
        Constraint constraint;
        if (tableName != null && name != null) {
            name = tableName + "." + name;
        }
        if ((constraint = this.constraints.get(name)) == null) {
            constraint = session.findLocalTempTableConstraint(name);
        }
        return constraint;
    }

    public Constant findConstant(String constantName) {
        return this.constants.get(constantName);
    }

    public FunctionAlias findFunction(String functionAlias) {
        return this.functions.get(functionAlias);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freeUniqueName(String name) {
        if (name != null) {
            HashSet<String> hashSet = this.temporaryUniqueNames;
            synchronized (hashSet) {
                this.temporaryUniqueNames.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueName(DbObject obj, HashMap<String, ? extends SchemaObject> map, String prefix) {
        String hash = Integer.toHexString(obj.getName().hashCode()).toUpperCase();
        String name = null;
        HashSet<String> hashSet = this.temporaryUniqueNames;
        synchronized (hashSet) {
            int i;
            int len = hash.length();
            for (i = 1; i < len && (map.containsKey(name = prefix + hash.substring(0, i)) || this.temporaryUniqueNames.contains(name)); ++i) {
                name = null;
            }
            if (name == null) {
                prefix = prefix + hash + "_";
                i = 0;
                while (map.containsKey(name = prefix + i) || this.temporaryUniqueNames.contains(name)) {
                    ++i;
                }
            }
            this.temporaryUniqueNames.add(name);
        }
        return name;
    }

    public String getUniqueConstraintName(Session session, Table table) {
        HashMap<String, Constraint> tableConstraints = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableConstraints() : this.constraints;
        return this.getUniqueName(table, tableConstraints, "CONSTRAINT_");
    }

    public String getUniqueIndexName(Session session, Table table, String prefix) {
        HashMap<String, Index> tableIndexes = table.isTemporary() && !table.isGlobalTemporary() ? session.getLocalTempTableIndexes() : this.indexes;
        return this.getUniqueName(table, tableIndexes, prefix);
    }

    public Table getTableOrView(Session session, String name) {
        Table table = this.tablesAndViews.get(name);
        if (table == null) {
            if (session != null) {
                table = session.findLocalTempTable(name);
            }
            if (table == null) {
                throw DbException.get(42102, name);
            }
        }
        return table;
    }

    public Index getIndex(String tableName, String name) {
        Index index;
        if (tableName != null && name != null) {
            name = tableName + "." + name;
        }
        if ((index = this.indexes.get(name)) == null) {
            throw DbException.get(42112, name);
        }
        return index;
    }

    public Constraint getConstraint(String tableName, String name) {
        Constraint constraint;
        if (tableName != null && name != null) {
            name = tableName + "." + name;
        }
        if ((constraint = this.constraints.get(name)) == null) {
            throw DbException.get(90057, name);
        }
        return constraint;
    }

    public Constant getConstant(String constantName) {
        Constant constant = this.constants.get(constantName);
        if (constant == null) {
            throw DbException.get(90115, constantName);
        }
        return constant;
    }

    public Sequence getSequence(String sequenceName) {
        Sequence sequence = this.sequences.get(sequenceName);
        if (sequence == null) {
            throw DbException.get(90036, sequenceName);
        }
        return sequence;
    }

    public ArrayList<SchemaObject> getAll() {
        ArrayList<SchemaObject> all = New.arrayList();
        all.addAll(this.getMap(0).values());
        all.addAll(this.getMap(3).values());
        all.addAll(this.getMap(1).values());
        all.addAll(this.getMap(4).values());
        all.addAll(this.getMap(5).values());
        all.addAll(this.getMap(11).values());
        all.addAll(this.getMap(9).values());
        return all;
    }

    public ArrayList<SchemaObject> getAll(int type) {
        HashMap<String, SchemaObject> map = this.getMap(type);
        return New.arrayList(map.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Table> getAllTablesAndViews() {
        Database database = this.database;
        synchronized (database) {
            return New.arrayList(this.tablesAndViews.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTableOrViewByName(String name) {
        Database database = this.database;
        synchronized (database) {
            return this.tablesAndViews.get(name);
        }
    }

    public void remove(SchemaObject obj) {
        String objName;
        String key = objName = obj.getName();
        if (obj.getType() == 1 || obj.getType() == 5) {
            Table table = obj.getType() == 1 ? ((Index)obj).getTable() : ((Constraint)obj).getTable();
            key = table.getName() + "." + objName;
        }
        HashMap<String, SchemaObject> map = this.getMap(obj.getType());
        if (SysProperties.CHECK && !map.containsKey(key)) {
            DbException.throwInternalError("not found: " + key);
        }
        map.remove(key);
        this.freeUniqueName(objName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table createTable(CreateTableData data) {
        Database database = this.database;
        synchronized (database) {
            if (!data.temporary || data.globalTemporary) {
                this.database.lockMeta(data.session);
            }
            data.schema = this;
            if (data.tableEngine == null) {
                DbSettings s = this.database.getSettings();
                if (s.defaultTableEngine != null) {
                    data.tableEngine = s.defaultTableEngine;
                } else if (s.mvStore) {
                    data.tableEngine = MVTableEngine.class.getName();
                }
            }
            if (data.tableEngine != null) {
                return this.database.getTableEngine(data.tableEngine).createTable(data);
            }
            return new RegularTable(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableLink createTableLink(int id, String tableName, String driver, String url, String user, String password, String originalSchema, String originalTable, boolean emitUpdates, boolean force) {
        Database database = this.database;
        synchronized (database) {
            return new TableLink(this, id, tableName, driver, url, user, password, originalSchema, originalTable, emitUpdates, force);
        }
    }
}

