/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.result;

import com.alibaba.dts.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.ResultInterface;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.util.StringUtils;
import com.alibaba.dts.shade.org.h2.value.DataType;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class UpdatableRow {
    private final JdbcConnection conn;
    private final ResultInterface result;
    private final int columnCount;
    private String schemaName;
    private String tableName;
    private ArrayList<String> key;
    private boolean isUpdatable;

    public UpdatableRow(JdbcConnection conn, ResultInterface result) throws SQLException {
        this.conn = conn;
        this.result = result;
        this.columnCount = result.getVisibleColumnCount();
        for (int i = 0; i < this.columnCount; ++i) {
            String t = result.getTableName(i);
            String s = result.getSchemaName(i);
            if (t == null || s == null) {
                return;
            }
            if (this.tableName == null) {
                this.tableName = t;
            } else if (!this.tableName.equals(t)) {
                return;
            }
            if (this.schemaName == null) {
                this.schemaName = s;
                continue;
            }
            if (this.schemaName.equals(s)) continue;
            return;
        }
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet rs = meta.getTables(null, StringUtils.escapeMetaDataPattern(this.schemaName), StringUtils.escapeMetaDataPattern(this.tableName), new String[]{"TABLE"});
        if (!rs.next()) {
            return;
        }
        if (rs.getString("SQL") == null) {
            return;
        }
        String table = rs.getString("TABLE_NAME");
        boolean toUpper = !table.equals(this.tableName) && table.equalsIgnoreCase(this.tableName);
        this.key = New.arrayList();
        rs = meta.getPrimaryKeys(null, StringUtils.escapeMetaDataPattern(this.schemaName), this.tableName);
        while (rs.next()) {
            String c = rs.getString("COLUMN_NAME");
            this.key.add(toUpper ? StringUtils.toUpperEnglish(c) : c);
        }
        if (this.isIndexUsable(this.key)) {
            this.isUpdatable = true;
            return;
        }
        this.key.clear();
        rs = meta.getIndexInfo(null, StringUtils.escapeMetaDataPattern(this.schemaName), this.tableName, true, true);
        while (rs.next()) {
            short pos = rs.getShort("ORDINAL_POSITION");
            if (pos == 1) {
                if (this.isIndexUsable(this.key)) {
                    this.isUpdatable = true;
                    return;
                }
                this.key.clear();
            }
            String c = rs.getString("COLUMN_NAME");
            this.key.add(toUpper ? StringUtils.toUpperEnglish(c) : c);
        }
        if (this.isIndexUsable(this.key)) {
            this.isUpdatable = true;
            return;
        }
        this.key = null;
    }

    private boolean isIndexUsable(ArrayList<String> indexColumns) {
        if (indexColumns.size() == 0) {
            return false;
        }
        for (String c : indexColumns) {
            if (this.findColumnIndex(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    private int findColumnIndex(String columnName) {
        for (int i = 0; i < this.columnCount; ++i) {
            String col = this.result.getColumnName(i);
            if (!col.equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    private int getColumnIndex(String columnName) {
        int index = this.findColumnIndex(columnName);
        if (index < 0) {
            throw DbException.get(42122, columnName);
        }
        return index;
    }

    private void appendColumnList(StatementBuilder buff, boolean set) {
        buff.resetCount();
        for (int i = 0; i < this.columnCount; ++i) {
            buff.appendExceptFirst(",");
            String col = this.result.getColumnName(i);
            buff.append(StringUtils.quoteIdentifier(col));
            if (!set) continue;
            buff.append("=? ");
        }
    }

    private void appendKeyCondition(StatementBuilder buff) {
        buff.append(" WHERE ");
        buff.resetCount();
        for (String k : this.key) {
            buff.appendExceptFirst(" AND ");
            buff.append(StringUtils.quoteIdentifier(k)).append("=?");
        }
    }

    private void setKey(PreparedStatement prep, int start, Value[] current) throws SQLException {
        int size = this.key.size();
        for (int i = 0; i < size; ++i) {
            String col = this.key.get(i);
            int idx = this.getColumnIndex(col);
            Value v = current[idx];
            if (v == null || v == ValueNull.INSTANCE) {
                throw DbException.get(2000);
            }
            v.set(prep, start + i);
        }
    }

    private void appendTableName(StatementBuilder buff) {
        if (this.schemaName != null && this.schemaName.length() > 0) {
            buff.append(StringUtils.quoteIdentifier(this.schemaName)).append('.');
        }
        buff.append(StringUtils.quoteIdentifier(this.tableName));
    }

    public Value[] readRow(Value[] row) throws SQLException {
        StatementBuilder buff = new StatementBuilder("SELECT ");
        this.appendColumnList(buff, false);
        buff.append(" FROM ");
        this.appendTableName(buff);
        this.appendKeyCondition(buff);
        PreparedStatement prep = this.conn.prepareStatement(buff.toString());
        this.setKey(prep, 1, row);
        ResultSet rs = prep.executeQuery();
        if (!rs.next()) {
            throw DbException.get(2000);
        }
        Value[] newRow = new Value[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            int type = this.result.getColumnType(i);
            newRow[i] = DataType.readValue(this.conn.getSession(), rs, i + 1, type);
        }
        return newRow;
    }

    public void deleteRow(Value[] current) throws SQLException {
        StatementBuilder buff = new StatementBuilder("DELETE FROM ");
        this.appendTableName(buff);
        this.appendKeyCondition(buff);
        PreparedStatement prep = this.conn.prepareStatement(buff.toString());
        this.setKey(prep, 1, current);
        int count = prep.executeUpdate();
        if (count != 1) {
            throw DbException.get(2000);
        }
    }

    public void updateRow(Value[] current, Value[] updateRow) throws SQLException {
        StatementBuilder buff = new StatementBuilder("UPDATE ");
        this.appendTableName(buff);
        buff.append(" SET ");
        this.appendColumnList(buff, true);
        this.appendKeyCondition(buff);
        PreparedStatement prep = this.conn.prepareStatement(buff.toString());
        int j = 1;
        for (int i = 0; i < this.columnCount; ++i) {
            Value v = updateRow[i];
            if (v == null) {
                v = current[i];
            }
            v.set(prep, j++);
        }
        this.setKey(prep, j, current);
        int count = prep.executeUpdate();
        if (count != 1) {
            throw DbException.get(2000);
        }
    }

    public void insertRow(Value[] row) throws SQLException {
        StatementBuilder buff = new StatementBuilder("INSERT INTO ");
        this.appendTableName(buff);
        buff.append('(');
        this.appendColumnList(buff, false);
        buff.append(")VALUES(");
        buff.resetCount();
        for (int i = 0; i < this.columnCount; ++i) {
            buff.appendExceptFirst(",");
            Value v = row[i];
            if (v == null) {
                buff.append("DEFAULT");
                continue;
            }
            buff.append('?');
        }
        buff.append(')');
        PreparedStatement prep = this.conn.prepareStatement(buff.toString());
        int j = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            Value v = row[i];
            if (v == null) continue;
            v.set(prep, j++ + 1);
        }
        int count = prep.executeUpdate();
        if (count != 1) {
            throw DbException.get(2000);
        }
    }
}

