/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.mvstore.rtree;

import com.alibaba.dts.shade.org.h2.mvstore.DataUtils;
import com.alibaba.dts.shade.org.h2.mvstore.WriteBuffer;
import com.alibaba.dts.shade.org.h2.mvstore.rtree.SpatialKey;
import com.alibaba.dts.shade.org.h2.mvstore.type.DataType;
import com.alibaba.dts.shade.org.h2.util.New;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class SpatialDataType
implements DataType {
    private final int dimensions;

    public SpatialDataType(int dimensions) {
        DataUtils.checkArgument(dimensions >= 1 && dimensions < 32, "Dimensions must be between 1 and 31, is {0}", dimensions);
        this.dimensions = dimensions;
    }

    @Override
    public int compare(Object a, Object b) {
        long lb;
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        long la = ((SpatialKey)a).getId();
        return la < (lb = ((SpatialKey)b).getId()) ? -1 : (la > lb ? 1 : 0);
    }

    public boolean equals(Object a, Object b) {
        long lb;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        long la = ((SpatialKey)a).getId();
        return la == (lb = ((SpatialKey)b).getId());
    }

    @Override
    public int getMemory(Object obj) {
        return 40 + this.dimensions * 4;
    }

    @Override
    public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            obj[i] = this.read(buff);
        }
    }

    @Override
    public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, obj[i]);
        }
    }

    @Override
    public void write(WriteBuffer buff, Object obj) {
        int i;
        SpatialKey k = (SpatialKey)obj;
        if (k.isNull()) {
            buff.putVarInt(-1);
            buff.putVarLong(k.getId());
            return;
        }
        int flags = 0;
        for (i = 0; i < this.dimensions; ++i) {
            if (k.min(i) != k.max(i)) continue;
            flags |= 1 << i;
        }
        buff.putVarInt(flags);
        for (i = 0; i < this.dimensions; ++i) {
            buff.putFloat(k.min(i));
            if ((flags & 1 << i) != 0) continue;
            buff.putFloat(k.max(i));
        }
        buff.putVarLong(k.getId());
    }

    @Override
    public Object read(ByteBuffer buff) {
        int flags = DataUtils.readVarInt(buff);
        if (flags == -1) {
            long id = DataUtils.readVarLong(buff);
            return new SpatialKey(id, new float[0]);
        }
        float[] minMax = new float[this.dimensions * 2];
        for (int i = 0; i < this.dimensions; ++i) {
            float min = buff.getFloat();
            float max = (flags & 1 << i) != 0 ? min : buff.getFloat();
            minMax[i + i] = min;
            minMax[i + i + 1] = max;
        }
        long id = DataUtils.readVarLong(buff);
        return new SpatialKey(id, minMax);
    }

    public boolean isOverlap(Object objA, Object objB) {
        SpatialKey a = (SpatialKey)objA;
        SpatialKey b = (SpatialKey)objB;
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(a.max(i) < b.min(i)) && !(a.min(i) > b.max(i))) continue;
            return false;
        }
        return true;
    }

    public void increaseBounds(Object bounds, Object add) {
        SpatialKey a = (SpatialKey)add;
        SpatialKey b = (SpatialKey)bounds;
        if (a.isNull() || b.isNull()) {
            return;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            b.setMin(i, Math.min(b.min(i), a.min(i)));
            b.setMax(i, Math.max(b.max(i), a.max(i)));
        }
    }

    public float getAreaIncrease(Object objA, Object objB) {
        SpatialKey b = (SpatialKey)objB;
        SpatialKey a = (SpatialKey)objA;
        if (a.isNull() || b.isNull()) {
            return 0.0f;
        }
        float min = a.min(0);
        float max = a.max(0);
        float areaOld = max - min;
        min = Math.min(min, b.min(0));
        max = Math.max(max, b.max(0));
        float areaNew = max - min;
        for (int i = 1; i < this.dimensions; ++i) {
            min = a.min(i);
            max = a.max(i);
            areaOld *= max - min;
            min = Math.min(min, b.min(i));
            max = Math.max(max, b.max(i));
            areaNew *= max - min;
        }
        return areaNew - areaOld;
    }

    float getCombinedArea(Object objA, Object objB) {
        SpatialKey a = (SpatialKey)objA;
        SpatialKey b = (SpatialKey)objB;
        if (a.isNull()) {
            return this.getArea(b);
        }
        if (b.isNull()) {
            return this.getArea(a);
        }
        float area = 1.0f;
        for (int i = 0; i < this.dimensions; ++i) {
            float min = Math.min(a.min(i), b.min(i));
            float max = Math.max(a.max(i), b.max(i));
            area *= max - min;
        }
        return area;
    }

    private float getArea(SpatialKey a) {
        if (a.isNull()) {
            return 0.0f;
        }
        float area = 1.0f;
        for (int i = 0; i < this.dimensions; ++i) {
            area *= a.max(i) - a.min(i);
        }
        return area;
    }

    public boolean contains(Object objA, Object objB) {
        SpatialKey a = (SpatialKey)objA;
        SpatialKey b = (SpatialKey)objB;
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(a.min(i) > b.min(i)) && !(a.max(i) < b.max(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isInside(Object objA, Object objB) {
        SpatialKey a = (SpatialKey)objA;
        SpatialKey b = (SpatialKey)objB;
        if (a.isNull() || b.isNull()) {
            return false;
        }
        for (int i = 0; i < this.dimensions; ++i) {
            if (!(a.min(i) <= b.min(i)) && !(a.max(i) >= b.max(i))) continue;
            return false;
        }
        return true;
    }

    Object createBoundingBox(Object objA) {
        SpatialKey a = (SpatialKey)objA;
        if (a.isNull()) {
            return a;
        }
        float[] minMax = new float[this.dimensions * 2];
        for (int i = 0; i < this.dimensions; ++i) {
            minMax[i + i] = a.min(i);
            minMax[i + i + 1] = a.max(i);
        }
        return new SpatialKey(0L, minMax);
    }

    public int[] getExtremes(ArrayList<Object> list) {
        int i;
        if ((list = SpatialDataType.getNotNull(list)).size() == 0) {
            return null;
        }
        SpatialKey bounds = (SpatialKey)this.createBoundingBox(list.get(0));
        SpatialKey boundsInner = (SpatialKey)this.createBoundingBox(bounds);
        for (i = 0; i < this.dimensions; ++i) {
            float t = boundsInner.min(i);
            boundsInner.setMin(i, boundsInner.max(i));
            boundsInner.setMax(i, t);
        }
        for (i = 0; i < list.size(); ++i) {
            Object o = list.get(i);
            this.increaseBounds(bounds, o);
            this.increaseMaxInnerBounds(boundsInner, o);
        }
        double best = 0.0;
        int bestDim = 0;
        for (int i2 = 0; i2 < this.dimensions; ++i2) {
            float outer;
            float d;
            float inner = boundsInner.max(i2) - boundsInner.min(i2);
            if (inner < 0.0f || !((double)(d = inner / (outer = bounds.max(i2) - bounds.min(i2))) > best)) continue;
            best = d;
            bestDim = i2;
        }
        if (best <= 0.0) {
            return null;
        }
        float min = boundsInner.min(bestDim);
        float max = boundsInner.max(bestDim);
        int firstIndex = -1;
        int lastIndex = -1;
        for (int i3 = 0; i3 < list.size() && (firstIndex < 0 || lastIndex < 0); ++i3) {
            SpatialKey o = (SpatialKey)list.get(i3);
            if (firstIndex < 0 && o.max(bestDim) == min) {
                firstIndex = i3;
                continue;
            }
            if (lastIndex >= 0 || o.min(bestDim) != max) continue;
            lastIndex = i3;
        }
        return new int[]{firstIndex, lastIndex};
    }

    private static ArrayList<Object> getNotNull(ArrayList<Object> list) {
        SpatialKey a;
        ArrayList result = null;
        for (Object o : list) {
            a = (SpatialKey)o;
            if (!a.isNull()) continue;
            result = New.arrayList();
            break;
        }
        if (result == null) {
            return list;
        }
        for (Object o : list) {
            a = (SpatialKey)o;
            if (a.isNull()) continue;
            result.add(a);
        }
        return result;
    }

    private void increaseMaxInnerBounds(Object bounds, Object add) {
        SpatialKey b = (SpatialKey)bounds;
        SpatialKey a = (SpatialKey)add;
        for (int i = 0; i < this.dimensions; ++i) {
            b.setMin(i, Math.min(b.min(i), a.max(i)));
            b.setMax(i, Math.max(b.max(i), a.min(i)));
        }
    }
}

