/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.index;

import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.index.BaseIndex;
import com.alibaba.dts.shade.org.h2.index.Cursor;
import com.alibaba.dts.shade.org.h2.index.IndexType;
import com.alibaba.dts.shade.org.h2.index.NonUniqueHashCursor;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.result.SearchRow;
import com.alibaba.dts.shade.org.h2.result.SortOrder;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.IndexColumn;
import com.alibaba.dts.shade.org.h2.table.RegularTable;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.ValueHashMap;
import com.alibaba.dts.shade.org.h2.value.Value;
import java.util.ArrayList;

public class NonUniqueHashIndex
extends BaseIndex {
    private final int indexColumn;
    private ValueHashMap<ArrayList<Long>> rows;
    private final RegularTable tableData;
    private long rowCount;

    public NonUniqueHashIndex(RegularTable table, int id, String indexName, IndexColumn[] columns, IndexType indexType) {
        this.initBaseIndex(table, id, indexName, columns, indexType);
        this.indexColumn = columns[0].column.getColumnId();
        this.tableData = table;
        this.reset();
    }

    private void reset() {
        this.rows = ValueHashMap.newInstance();
        this.rowCount = 0L;
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value key = row.getValue(this.indexColumn);
        ArrayList<Long> positions = this.rows.get(key);
        if (positions == null) {
            positions = New.arrayList();
            this.rows.put(key, positions);
        }
        positions.add(row.getKey());
        ++this.rowCount;
    }

    @Override
    public void remove(Session session, Row row) {
        if (this.rowCount == 1L) {
            this.reset();
        } else {
            Value key = row.getValue(this.indexColumn);
            ArrayList<Long> positions = this.rows.get(key);
            if (positions.size() == 1) {
                this.rows.remove(key);
            } else {
                positions.remove(row.getKey());
            }
            --this.rowCount;
        }
    }

    @Override
    public Cursor find(Session session, SearchRow first, SearchRow last) {
        if (first == null || last == null) {
            throw DbException.throwInternalError();
        }
        if (first != last && this.compareKeys(first, last) != 0) {
            throw DbException.throwInternalError();
        }
        Value v = first.getValue(this.indexColumn);
        v = v.convertTo(this.tableData.getColumn(this.indexColumn).getType());
        ArrayList<Long> positions = this.rows.get(v);
        return new NonUniqueHashCursor(session, this.tableData, positions);
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public double getCost(Session session, int[] masks, TableFilter filter, SortOrder sortOrder) {
        for (Column column : this.columns) {
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean first) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

