/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.expression;

import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Comparison;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.dts.shade.org.h2.expression.ParameterInterface;
import com.alibaba.dts.shade.org.h2.expression.ValueExpression;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.ColumnResolver;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueBoolean;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import com.alibaba.dts.shade.org.h2.value.ValueString;

public class Parameter
extends Expression
implements ParameterInterface {
    private Value value;
    private Column column;
    private final int index;

    public Parameter(int index) {
        this.index = index;
    }

    @Override
    public String getSQL() {
        return "?" + (this.index + 1);
    }

    @Override
    public void setValue(Value v, boolean closeOld) {
        this.value = v;
    }

    public void setValue(Value v) {
        this.value = v;
    }

    @Override
    public Value getParamValue() {
        if (this.value == null) {
            return ValueNull.INSTANCE;
        }
        return this.value;
    }

    @Override
    public Value getValue(Session session) {
        return this.getParamValue();
    }

    @Override
    public int getType() {
        if (this.value != null) {
            return this.value.getType();
        }
        if (this.column != null) {
            return this.column.getType();
        }
        return -1;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
    }

    @Override
    public void checkSet() {
        if (this.value == null) {
            throw DbException.get(90012, "#" + (this.index + 1));
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (session.getDatabase().getMode().treatEmptyStringsAsNull && this.value != null && this.value instanceof ValueString) {
            this.value = ValueString.get(this.value.getString(), true);
        }
        return this;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isValueSet() {
        return this.value != null;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
    }

    @Override
    public int getScale() {
        if (this.value != null) {
            return this.value.getScale();
        }
        if (this.column != null) {
            return this.column.getScale();
        }
        return 0;
    }

    @Override
    public long getPrecision() {
        if (this.value != null) {
            return this.value.getPrecision();
        }
        if (this.column != null) {
            return this.column.getPrecision();
        }
        return 0L;
    }

    @Override
    public int getDisplaySize() {
        if (this.value != null) {
            return this.value.getDisplaySize();
        }
        if (this.column != null) {
            return this.column.getDisplaySize();
        }
        return 0;
    }

    @Override
    public void updateAggregate(Session session) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        switch (visitor.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
            case 0: {
                return this.value != null;
            }
        }
        throw DbException.throwInternalError("type=" + visitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public int getIndex() {
        return this.index;
    }
}

