/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.expression;

import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.expression.Expression;
import com.alibaba.dts.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.dts.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.dts.shade.org.h2.expression.ValueExpression;
import com.alibaba.dts.shade.org.h2.table.Column;
import com.alibaba.dts.shade.org.h2.table.ColumnResolver;
import com.alibaba.dts.shade.org.h2.table.TableFilter;
import com.alibaba.dts.shade.org.h2.util.StatementBuilder;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueArray;

public class ExpressionList
extends Expression {
    private final Expression[] list;

    public ExpressionList(Expression[] list) {
        this.list = list;
    }

    @Override
    public Value getValue(Session session) {
        Value[] v = new Value[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            v[i] = this.list[i].getValue(session);
        }
        return ValueArray.get(v);
    }

    @Override
    public int getType() {
        return 17;
    }

    @Override
    public void mapColumns(ColumnResolver resolver, int level) {
        for (Expression e : this.list) {
            e.mapColumns(resolver, level);
        }
    }

    @Override
    public Expression optimize(Session session) {
        boolean allConst = true;
        for (int i = 0; i < this.list.length; ++i) {
            Expression e = this.list[i].optimize(session);
            if (!e.isConstant()) {
                allConst = false;
            }
            this.list[i] = e;
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (Expression e : this.list) {
            e.setEvaluatable(tableFilter, b);
        }
    }

    @Override
    public int getScale() {
        return 0;
    }

    @Override
    public long getPrecision() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getDisplaySize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getSQL() {
        StatementBuilder buff = new StatementBuilder("(");
        for (Expression e : this.list) {
            buff.appendExceptFirst(", ");
            buff.append(e.getSQL());
        }
        if (this.list.length == 1) {
            buff.append(',');
        }
        return buff.append(')').toString();
    }

    @Override
    public void updateAggregate(Session session) {
        for (Expression e : this.list) {
            e.updateAggregate(session);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor visitor) {
        for (Expression e : this.list) {
            if (e.isEverything(visitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int cost = 1;
        for (Expression e : this.list) {
            cost += e.getCost();
        }
        return cost;
    }

    @Override
    public Expression[] getExpressionColumns(Session session) {
        Expression[] expr = new ExpressionColumn[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            Expression e = this.list[i];
            Column col = new Column("C" + (i + 1), e.getType(), e.getPrecision(), e.getScale(), e.getDisplaySize());
            expr[i] = new ExpressionColumn(session.getDatabase(), col);
        }
        return expr;
    }
}

