/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.engine;

import com.alibaba.dts.shade.org.h2.command.Command;
import com.alibaba.dts.shade.org.h2.command.CommandInterface;
import com.alibaba.dts.shade.org.h2.command.Parser;
import com.alibaba.dts.shade.org.h2.command.Prepared;
import com.alibaba.dts.shade.org.h2.command.dml.SetTypes;
import com.alibaba.dts.shade.org.h2.constraint.Constraint;
import com.alibaba.dts.shade.org.h2.engine.ConnectionInfo;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.Engine;
import com.alibaba.dts.shade.org.h2.engine.Procedure;
import com.alibaba.dts.shade.org.h2.engine.SessionInterface;
import com.alibaba.dts.shade.org.h2.engine.SessionWithState;
import com.alibaba.dts.shade.org.h2.engine.Setting;
import com.alibaba.dts.shade.org.h2.engine.SysProperties;
import com.alibaba.dts.shade.org.h2.engine.UndoLog;
import com.alibaba.dts.shade.org.h2.engine.UndoLogRecord;
import com.alibaba.dts.shade.org.h2.engine.User;
import com.alibaba.dts.shade.org.h2.index.Index;
import com.alibaba.dts.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.message.Trace;
import com.alibaba.dts.shade.org.h2.message.TraceSystem;
import com.alibaba.dts.shade.org.h2.mvstore.db.MVTable;
import com.alibaba.dts.shade.org.h2.mvstore.db.TransactionStore;
import com.alibaba.dts.shade.org.h2.result.LocalResult;
import com.alibaba.dts.shade.org.h2.result.Row;
import com.alibaba.dts.shade.org.h2.schema.Schema;
import com.alibaba.dts.shade.org.h2.store.DataHandler;
import com.alibaba.dts.shade.org.h2.store.InDoubtTransaction;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.util.New;
import com.alibaba.dts.shade.org.h2.util.SmallLRUCache;
import com.alibaba.dts.shade.org.h2.value.Value;
import com.alibaba.dts.shade.org.h2.value.ValueArray;
import com.alibaba.dts.shade.org.h2.value.ValueLong;
import com.alibaba.dts.shade.org.h2.value.ValueNull;
import com.alibaba.dts.shade.org.h2.value.ValueString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class Session
extends SessionWithState {
    public static final int LOG_WRITTEN = -1;
    private static final String SYSTEM_IDENTIFIER_PREFIX = "_";
    private static int nextSerialId;
    private final int serialId = nextSerialId++;
    private final Database database;
    private ConnectionInfo connectionInfo;
    private final User user;
    private final int id;
    private final ArrayList<Table> locks = New.arrayList();
    private final UndoLog undoLog;
    private boolean autoCommit = true;
    private Random random;
    private int lockTimeout;
    private Value lastIdentity = ValueLong.get(0L);
    private Value lastScopeIdentity = ValueLong.get(0L);
    private int firstUncommittedLog = -1;
    private int firstUncommittedPos = -1;
    private HashMap<String, Savepoint> savepoints;
    private HashMap<String, Table> localTempTables;
    private HashMap<String, Index> localTempTableIndexes;
    private HashMap<String, Constraint> localTempTableConstraints;
    private int throttle;
    private long lastThrottle;
    private Command currentCommand;
    private boolean allowLiterals;
    private String currentSchemaName;
    private String[] schemaSearchPath;
    private Trace trace;
    private HashMap<String, Value> removeLobMap;
    private int systemIdentifier;
    private HashMap<String, Procedure> procedures;
    private boolean undoLogEnabled = true;
    private boolean redoLogBinary = true;
    private boolean autoCommitAtTransactionEnd;
    private String currentTransactionName;
    private volatile long cancelAt;
    private boolean closed;
    private final long sessionStart = System.currentTimeMillis();
    private long transactionStart;
    private long currentCommandStart;
    private HashMap<String, Value> variables;
    private HashSet<LocalResult> temporaryResults;
    private int queryTimeout;
    private boolean commitOrRollbackDisabled;
    private Table waitForLock;
    private Thread waitForLockThread;
    private int modificationId;
    private int objectId;
    private final int queryCacheSize;
    private SmallLRUCache<String, Command> queryCache;
    private long modificationMetaID = -1L;
    private LinkedList<TimeoutValue> temporaryResultLobs;
    private ArrayList<Value> temporaryLobs;
    private TransactionStore.Transaction transaction;
    private long startStatement = -1L;

    public Session(Database database, User user, int id) {
        this.database = database;
        this.queryTimeout = database.getSettings().maxQueryTimeout;
        this.queryCacheSize = database.getSettings().queryCacheSize;
        this.undoLog = new UndoLog(this);
        this.user = user;
        this.id = id;
        Setting setting = database.findSetting(SetTypes.getTypeName(6));
        this.lockTimeout = setting == null ? 2000 : setting.getIntValue();
        this.currentSchemaName = "PUBLIC";
    }

    @Override
    public ArrayList<String> getClusterServers() {
        return new ArrayList<String>();
    }

    public boolean setCommitOrRollbackDisabled(boolean x) {
        boolean old = this.commitOrRollbackDisabled;
        this.commitOrRollbackDisabled = x;
        return old;
    }

    private void initVariables() {
        if (this.variables == null) {
            this.variables = this.database.newStringMap();
        }
    }

    public void setVariable(String name, Value value) {
        Value old;
        this.initVariables();
        ++this.modificationId;
        if (value == ValueNull.INSTANCE) {
            old = this.variables.remove(name);
        } else {
            value = value.copy(this.database, -1);
            old = this.variables.put(name, value);
        }
        if (old != null) {
            old.remove();
        }
    }

    public Value getVariable(String name) {
        this.initVariables();
        Value v = this.variables.get(name);
        return v == null ? ValueNull.INSTANCE : v;
    }

    public String[] getVariableNames() {
        if (this.variables == null) {
            return new String[0];
        }
        String[] list = new String[this.variables.size()];
        this.variables.keySet().toArray(list);
        return list;
    }

    public Table findLocalTempTable(String name) {
        if (this.localTempTables == null) {
            return null;
        }
        return this.localTempTables.get(name);
    }

    public ArrayList<Table> getLocalTempTables() {
        if (this.localTempTables == null) {
            return New.arrayList();
        }
        return New.arrayList(this.localTempTables.values());
    }

    public void addLocalTempTable(Table table) {
        if (this.localTempTables == null) {
            this.localTempTables = this.database.newStringMap();
        }
        if (this.localTempTables.get(table.getName()) != null) {
            throw DbException.get(42101, table.getSQL());
        }
        ++this.modificationId;
        this.localTempTables.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTable(Table table) {
        ++this.modificationId;
        this.localTempTables.remove(table.getName());
        Database database = this.database;
        synchronized (database) {
            table.removeChildrenAndResources(this);
        }
    }

    public Index findLocalTempTableIndex(String name) {
        if (this.localTempTableIndexes == null) {
            return null;
        }
        return this.localTempTableIndexes.get(name);
    }

    public HashMap<String, Index> getLocalTempTableIndexes() {
        if (this.localTempTableIndexes == null) {
            return New.hashMap();
        }
        return this.localTempTableIndexes;
    }

    public void addLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes == null) {
            this.localTempTableIndexes = this.database.newStringMap();
        }
        if (this.localTempTableIndexes.get(index.getName()) != null) {
            throw DbException.get(42111, index.getSQL());
        }
        this.localTempTableIndexes.put(index.getName(), index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLocalTempTableIndex(Index index) {
        if (this.localTempTableIndexes != null) {
            this.localTempTableIndexes.remove(index.getName());
            Database database = this.database;
            synchronized (database) {
                index.removeChildrenAndResources(this);
            }
        }
    }

    public Constraint findLocalTempTableConstraint(String name) {
        if (this.localTempTableConstraints == null) {
            return null;
        }
        return this.localTempTableConstraints.get(name);
    }

    public HashMap<String, Constraint> getLocalTempTableConstraints() {
        if (this.localTempTableConstraints == null) {
            return New.hashMap();
        }
        return this.localTempTableConstraints;
    }

    public void addLocalTempTableConstraint(Constraint constraint) {
        String name;
        if (this.localTempTableConstraints == null) {
            this.localTempTableConstraints = this.database.newStringMap();
        }
        if (this.localTempTableConstraints.get(name = constraint.getName()) != null) {
            throw DbException.get(90045, constraint.getSQL());
        }
        this.localTempTableConstraints.put(name, constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLocalTempTableConstraint(Constraint constraint) {
        if (this.localTempTableConstraints != null) {
            this.localTempTableConstraints.remove(constraint.getName());
            Database database = this.database;
            synchronized (database) {
                constraint.removeChildrenAndResources(this);
            }
        }
    }

    @Override
    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public User getUser() {
        return this.user;
    }

    @Override
    public void setAutoCommit(boolean b) {
        this.autoCommit = b;
    }

    public int getLockTimeout() {
        return this.lockTimeout;
    }

    public void setLockTimeout(int lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    @Override
    public synchronized CommandInterface prepareCommand(String sql, int fetchSize) {
        return this.prepareLocal(sql);
    }

    public synchronized CommandInterface prepareQuery(String table, Map<String, Object> key, int fetchSize) {
        if (this.closed) {
            throw DbException.get(90067, "session closed");
        }
        Parser parser = new Parser(this);
        Command command = parser.prepareQuery(table, key);
        return command;
    }

    public synchronized CommandInterface prepareMerge(String table, Map<String, Object> row, int fetchSize) {
        if (this.closed) {
            throw DbException.get(90067, "session closed");
        }
        Parser parser = new Parser(this);
        Command command = parser.prepareMerge(table, row);
        return command;
    }

    public synchronized CommandInterface prepareInsert(String table, List<Map<String, Object>> rows, int fetchSize) {
        if (this.closed) {
            throw DbException.get(90067, "session closed");
        }
        Parser parser = new Parser(this);
        Command command = parser.prepareInsert(table, rows);
        return command;
    }

    public synchronized CommandInterface prepareDelete(String table, Map<String, Object> key, int fetchSize) {
        if (this.closed) {
            throw DbException.get(90067, "session closed");
        }
        Parser parser = new Parser(this);
        Command command = parser.prepareDelete(table, key);
        return command;
    }

    public void freeVersion(long version) {
        this.database.getMvStore().getStore().freeVersion(version);
    }

    public long getEstimatedMemory() {
        return this.database.getMvStore().getStore().getEstimatedMemory();
    }

    public Prepared prepare(String sql) {
        return this.prepare(sql, false);
    }

    public Prepared prepare(String sql, boolean rightsChecked) {
        Parser parser = new Parser(this);
        parser.setRightsChecked(rightsChecked);
        return parser.prepare(sql);
    }

    public Command prepareLocal(String sql) {
        Command command;
        if (this.closed) {
            throw DbException.get(90067, "session closed");
        }
        if (this.queryCacheSize > 0) {
            if (this.queryCache == null) {
                this.queryCache = SmallLRUCache.newInstance(this.queryCacheSize);
                this.modificationMetaID = this.database.getModificationMetaId();
            } else {
                long newModificationMetaID = this.database.getModificationMetaId();
                if (newModificationMetaID != this.modificationMetaID) {
                    this.queryCache.clear();
                    this.modificationMetaID = newModificationMetaID;
                }
                if ((command = (Command)this.queryCache.get(sql)) != null && command.canReuse()) {
                    command.reuse();
                    return command;
                }
            }
        }
        Parser parser = new Parser(this);
        command = parser.prepareCommand(sql);
        if (this.queryCache != null && command.isCacheable()) {
            this.queryCache.put(sql, command);
        }
        return command;
    }

    public Database getDatabase() {
        return this.database;
    }

    @Override
    public int getPowerOffCount() {
        return this.database.getPowerOffCount();
    }

    @Override
    public void setPowerOffCount(int count) {
        this.database.setPowerOffCount(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commit(boolean ddl) {
        this.checkCommitRollback();
        long v = 0L;
        this.currentTransactionName = null;
        this.transactionStart = 0L;
        if (this.transaction != null) {
            if (this.locks.size() > 0) {
                int size = this.locks.size();
                for (int i = 0; i < size; ++i) {
                    Table t = this.locks.get(i);
                    if (!(t instanceof MVTable)) continue;
                    ((MVTable)t).commit();
                }
            }
            v = this.transaction.commit();
            this.transaction = null;
        }
        if (this.containsUncommitted()) {
            this.database.commit(this);
        }
        this.removeTemporaryLobs(true);
        if (this.undoLog.size() > 0) {
            if (this.database.isMultiVersion()) {
                ArrayList rows = New.arrayList();
                Database database = this.database;
                synchronized (database) {
                    while (this.undoLog.size() > 0) {
                        UndoLogRecord entry = this.undoLog.getLast();
                        entry.commit();
                        rows.add(entry.getRow());
                        this.undoLog.removeLast(false);
                    }
                    int size = rows.size();
                    for (int i = 0; i < size; ++i) {
                        Row r = (Row)rows.get(i);
                        r.commit();
                    }
                }
            }
            this.undoLog.clear();
        }
        if (!ddl) {
            this.cleanTempTables(false);
            if (this.autoCommitAtTransactionEnd) {
                this.autoCommit = true;
                this.autoCommitAtTransactionEnd = false;
            }
        }
        this.endTransaction();
        return v;
    }

    private void removeTemporaryLobs(boolean onTimeout) {
        if (this.temporaryLobs != null) {
            for (Value v : this.temporaryLobs) {
                if (v.isLinkedToTable()) continue;
                v.remove();
            }
            this.temporaryLobs.clear();
        }
        if (this.temporaryResultLobs != null && this.temporaryResultLobs.size() > 0) {
            long keepYoungerThan = System.currentTimeMillis() - (long)this.database.getSettings().lobTimeout;
            while (this.temporaryResultLobs.size() > 0) {
                TimeoutValue tv = this.temporaryResultLobs.getFirst();
                if (onTimeout && tv.created >= keepYoungerThan) break;
                Value v = this.temporaryResultLobs.removeFirst().value;
                if (v.isLinkedToTable()) continue;
                v.remove();
            }
        }
    }

    private void checkCommitRollback() {
        if (this.commitOrRollbackDisabled && this.locks.size() > 0) {
            throw DbException.get(90058);
        }
    }

    private void endTransaction() {
        if (this.removeLobMap != null && this.removeLobMap.size() > 0) {
            if (this.database.getMvStore() == null) {
                this.database.flush();
            }
            for (Value v : this.removeLobMap.values()) {
                v.remove();
            }
            this.removeLobMap = null;
        }
        this.unlockAll();
    }

    public void rollback() {
        this.checkCommitRollback();
        this.currentTransactionName = null;
        boolean needCommit = false;
        if (this.undoLog.size() > 0) {
            this.rollbackTo(null, false);
            needCommit = true;
        }
        if (this.transaction != null) {
            this.rollbackTo(null, false);
            needCommit = true;
            this.transaction.commit();
            this.transaction = null;
        }
        if (this.locks.size() > 0 || needCommit) {
            this.database.commit(this);
        }
        this.cleanTempTables(false);
        if (this.autoCommitAtTransactionEnd) {
            this.autoCommit = true;
            this.autoCommitAtTransactionEnd = false;
        }
        this.endTransaction();
    }

    public void rollbackTo(Savepoint savepoint, boolean trimToSize) {
        int index;
        int n = index = savepoint == null ? 0 : savepoint.logIndex;
        while (this.undoLog.size() > index) {
            UndoLogRecord entry = this.undoLog.getLast();
            entry.undo(this);
            this.undoLog.removeLast(trimToSize);
        }
        if (this.transaction != null) {
            long savepointId = savepoint == null ? 0L : savepoint.transactionSavepoint;
            HashMap<String, MVTable> tableMap = this.database.getMvStore().getTables();
            Iterator<TransactionStore.Change> it = this.transaction.getChanges(savepointId);
            while (it.hasNext()) {
                Row row;
                short op;
                TransactionStore.Change c = it.next();
                MVTable t = tableMap.get(c.mapName);
                if (t == null) continue;
                long key = ((ValueLong)c.key).getLong();
                ValueArray value = (ValueArray)c.value;
                if (value == null) {
                    op = 0;
                    row = t.getRow(this, key);
                } else {
                    op = 1;
                    row = new Row(value.getList(), -1);
                }
                row.setKey(key);
                UndoLogRecord log = new UndoLogRecord(t, op, row);
                log.undo(this);
            }
        }
        if (this.savepoints != null) {
            String[] names = new String[this.savepoints.size()];
            this.savepoints.keySet().toArray(names);
            for (String name : names) {
                Savepoint sp = this.savepoints.get(name);
                int savepointIndex = sp.logIndex;
                if (savepointIndex <= index) continue;
                this.savepoints.remove(name);
            }
        }
    }

    @Override
    public boolean hasPendingTransaction() {
        return this.undoLog.size() > 0;
    }

    public Savepoint setSavepoint() {
        Savepoint sp = new Savepoint();
        sp.logIndex = this.undoLog.size();
        if (this.database.getMvStore() != null) {
            sp.transactionSavepoint = this.getStatementSavepoint();
        }
        return sp;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void cancel() {
        this.cancelAt = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            try {
                this.database.checkPowerOff();
                this.removeTemporaryLobs(false);
                this.cleanTempTables(true);
                this.undoLog.clear();
                this.database.removeSession(this);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public void addLock(Table table) {
        if (SysProperties.CHECK && this.locks.contains(table)) {
            DbException.throwInternalError();
        }
        this.locks.add(table);
    }

    public void log(Table table, short operation, Row row) {
        if (table.isMVStore()) {
            return;
        }
        if (this.undoLogEnabled) {
            int lockMode;
            UndoLogRecord log = new UndoLogRecord(table, operation, row);
            if (SysProperties.CHECK && (lockMode = this.database.getLockMode()) != 0 && !this.database.isMultiVersion()) {
                String tableType = log.getTable().getTableType();
                if (this.locks.indexOf(log.getTable()) < 0 && !"TABLE LINK".equals(tableType) && !"EXTERNAL".equals(tableType)) {
                    DbException.throwInternalError();
                }
            }
            this.undoLog.add(log);
        } else if (this.database.isMultiVersion()) {
            ArrayList<Index> indexes = table.getIndexes();
            int size = indexes.size();
            for (int i = 0; i < size; ++i) {
                Index index = indexes.get(i);
                index.commit(operation, row);
            }
            row.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockReadLocks() {
        if (this.database.isMultiVersion()) {
            return;
        }
        for (int i = 0; i < this.locks.size(); ++i) {
            Table t = this.locks.get(i);
            if (t.isLockedExclusively()) continue;
            Database database = this.database;
            synchronized (database) {
                t.unlock(this);
                this.locks.remove(i);
            }
            --i;
        }
    }

    void unlock(Table t) {
        this.locks.remove(t);
    }

    private void unlockAll() {
        if (SysProperties.CHECK && this.undoLog.size() > 0) {
            DbException.throwInternalError();
        }
        if (this.locks.size() > 0) {
            int size = this.locks.size();
            for (int i = 0; i < size; ++i) {
                Table t = this.locks.get(i);
                t.unlock(this);
            }
            this.locks.clear();
        }
        this.savepoints = null;
        this.sessionStateChanged = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTempTables(boolean closeSession) {
        if (this.localTempTables != null && this.localTempTables.size() > 0) {
            Database database = this.database;
            synchronized (database) {
                for (Table table : New.arrayList(this.localTempTables.values())) {
                    if (closeSession || table.getOnCommitDrop()) {
                        ++this.modificationId;
                        table.setModified();
                        this.localTempTables.remove(table.getName());
                        table.removeChildrenAndResources(this);
                        if (!closeSession) continue;
                        this.database.commit(this);
                        continue;
                    }
                    if (!table.getOnCommitTruncate()) continue;
                    table.truncate(this);
                }
            }
        }
    }

    public Random getRandom() {
        if (this.random == null) {
            this.random = new Random();
        }
        return this.random;
    }

    @Override
    public Trace getTrace() {
        if (this.trace != null && !this.closed) {
            return this.trace;
        }
        String traceModuleName = "jdbc[" + this.id + "]";
        if (this.closed) {
            return new TraceSystem(null).getTrace(traceModuleName);
        }
        this.trace = this.database.getTraceSystem().getTrace(traceModuleName);
        return this.trace;
    }

    public void setLastIdentity(Value last) {
        this.lastIdentity = last;
        this.lastScopeIdentity = last;
    }

    public Value getLastIdentity() {
        return this.lastIdentity;
    }

    public void setLastScopeIdentity(Value last) {
        this.lastScopeIdentity = last;
    }

    public Value getLastScopeIdentity() {
        return this.lastScopeIdentity;
    }

    public void addLogPos(int logId, int pos) {
        if (this.firstUncommittedLog == -1) {
            this.firstUncommittedLog = logId;
            this.firstUncommittedPos = pos;
        }
    }

    public int getFirstUncommittedLog() {
        return this.firstUncommittedLog;
    }

    void setAllCommitted() {
        this.firstUncommittedLog = -1;
        this.firstUncommittedPos = -1;
    }

    public boolean containsUncommitted() {
        if (this.database.getMvStore() != null) {
            return this.transaction != null;
        }
        return this.firstUncommittedLog != -1;
    }

    public void addSavepoint(String name) {
        if (this.savepoints == null) {
            this.savepoints = this.database.newStringMap();
        }
        Savepoint sp = new Savepoint();
        sp.logIndex = this.undoLog.size();
        if (this.database.getMvStore() != null) {
            sp.transactionSavepoint = this.getStatementSavepoint();
        }
        this.savepoints.put(name, sp);
    }

    public void rollbackToSavepoint(String name) {
        this.checkCommitRollback();
        if (this.savepoints == null) {
            throw DbException.get(90063, name);
        }
        Savepoint savepoint = this.savepoints.get(name);
        if (savepoint == null) {
            throw DbException.get(90063, name);
        }
        this.rollbackTo(savepoint, false);
    }

    public void prepareCommit(String transactionName) {
        if (this.transaction != null) {
            this.database.prepareCommit(this, transactionName);
        }
        if (this.containsUncommitted()) {
            this.database.prepareCommit(this, transactionName);
        }
        this.currentTransactionName = transactionName;
    }

    public void setPreparedTransaction(String transactionName, boolean commit) {
        if (this.currentTransactionName != null && this.currentTransactionName.equals(transactionName)) {
            if (commit) {
                this.commit(false);
            } else {
                this.rollback();
            }
        } else {
            ArrayList<InDoubtTransaction> list = this.database.getInDoubtTransactions();
            int state = commit ? 1 : 2;
            boolean found = false;
            if (list != null) {
                for (InDoubtTransaction p : list) {
                    if (!p.getTransactionName().equals(transactionName)) continue;
                    p.setState(state);
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw DbException.get(90129, transactionName);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void setThrottle(int throttle) {
        this.throttle = throttle;
    }

    public void throttle() {
        if (this.currentCommandStart == 0L) {
            this.currentCommandStart = System.currentTimeMillis();
        }
        if (this.throttle == 0) {
            return;
        }
        long time = System.currentTimeMillis();
        if (this.lastThrottle + 50L > time) {
            return;
        }
        this.lastThrottle = time + (long)this.throttle;
        try {
            Thread.sleep(this.throttle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCurrentCommand(Command command) {
        this.currentCommand = command;
        if (this.queryTimeout > 0 && command != null) {
            long now;
            this.currentCommandStart = now = System.currentTimeMillis();
            this.cancelAt = now + (long)this.queryTimeout;
        }
    }

    public void checkCanceled() {
        this.throttle();
        if (this.cancelAt == 0L) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time >= this.cancelAt) {
            this.cancelAt = 0L;
            throw DbException.get(57014);
        }
    }

    public long getCancel() {
        return this.cancelAt;
    }

    public Command getCurrentCommand() {
        return this.currentCommand;
    }

    public long getCurrentCommandStart() {
        return this.currentCommandStart;
    }

    public boolean getAllowLiterals() {
        return this.allowLiterals;
    }

    public void setAllowLiterals(boolean b) {
        this.allowLiterals = b;
    }

    public void setCurrentSchema(Schema schema) {
        ++this.modificationId;
        this.currentSchemaName = schema.getName();
    }

    public String getCurrentSchemaName() {
        return this.currentSchemaName;
    }

    public JdbcConnection createConnection(boolean columnList) {
        String url = columnList ? "jdbc:columnlist:connection" : "jdbc:default:connection";
        return new JdbcConnection(this, this.getUser().getName(), url);
    }

    @Override
    public DataHandler getDataHandler() {
        return this.database;
    }

    public void removeAtCommit(Value v) {
        if (SysProperties.CHECK && !v.isLinkedToTable()) {
            DbException.throwInternalError();
        }
        if (this.removeLobMap == null) {
            this.removeLobMap = new HashMap();
        }
        this.removeLobMap.put(v.toString(), v);
    }

    public void removeAtCommitStop(Value v) {
        if (this.removeLobMap != null) {
            this.removeLobMap.remove(v.toString());
        }
    }

    public String getNextSystemIdentifier(String sql) {
        String identifier;
        while (sql.contains(identifier = SYSTEM_IDENTIFIER_PREFIX + this.systemIdentifier++)) {
        }
        return identifier;
    }

    public void addProcedure(Procedure procedure) {
        if (this.procedures == null) {
            this.procedures = this.database.newStringMap();
        }
        this.procedures.put(procedure.getName(), procedure);
    }

    public void removeProcedure(String name) {
        if (this.procedures != null) {
            this.procedures.remove(name);
        }
    }

    public Procedure getProcedure(String name) {
        if (this.procedures == null) {
            return null;
        }
        return this.procedures.get(name);
    }

    public void setSchemaSearchPath(String[] schemas) {
        ++this.modificationId;
        this.schemaSearchPath = schemas;
    }

    public String[] getSchemaSearchPath() {
        return this.schemaSearchPath;
    }

    public int hashCode() {
        return this.serialId;
    }

    public String toString() {
        return "#" + this.serialId + " (user: " + this.user.getName() + ")";
    }

    public void setUndoLogEnabled(boolean b) {
        this.undoLogEnabled = b;
    }

    public void setRedoLogBinary(boolean b) {
        this.redoLogBinary = b;
    }

    public boolean isUndoLogEnabled() {
        return this.undoLogEnabled;
    }

    public void begin() {
        this.autoCommitAtTransactionEnd = true;
        this.autoCommit = false;
    }

    public long getSessionStart() {
        return this.sessionStart;
    }

    public long getTransactionStart() {
        if (this.transactionStart == 0L) {
            this.transactionStart = System.currentTimeMillis();
        }
        return this.transactionStart;
    }

    public Table[] getLocks() {
        ArrayList<Table> copy = New.arrayList();
        for (int i = 0; i < this.locks.size(); ++i) {
            try {
                copy.add(this.locks.get(i));
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        Table[] list = new Table[copy.size()];
        copy.toArray(list);
        return list;
    }

    public void waitIfExclusiveModeEnabled() {
        Session exclusive;
        if (this.database.getLobSession() == this) {
            return;
        }
        while ((exclusive = this.database.getExclusiveSession()) != null && exclusive != this && !Thread.holdsLock(exclusive)) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void addTemporaryResult(LocalResult result) {
        if (!result.needToClose()) {
            return;
        }
        if (this.temporaryResults == null) {
            this.temporaryResults = New.hashSet();
        }
        if (this.temporaryResults.size() < 100) {
            this.temporaryResults.add(result);
        }
    }

    private void closeTemporaryResults() {
        if (this.temporaryResults != null) {
            for (LocalResult result : this.temporaryResults) {
                result.close();
            }
            this.temporaryResults = null;
        }
    }

    public void setQueryTimeout(int queryTimeout) {
        int max = this.database.getSettings().maxQueryTimeout;
        if (max != 0 && (max < queryTimeout || queryTimeout == 0)) {
            queryTimeout = max;
        }
        this.queryTimeout = queryTimeout;
        this.cancelAt = 0L;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setWaitForLock(Table waitForLock, Thread waitForLockThread) {
        this.waitForLock = waitForLock;
        this.waitForLockThread = waitForLockThread;
    }

    public Table getWaitForLock() {
        return this.waitForLock;
    }

    public Thread getWaitForLockThread() {
        return this.waitForLockThread;
    }

    public int getModificationId() {
        return this.modificationId;
    }

    @Override
    public boolean isReconnectNeeded(boolean write) {
        block2: {
            do {
                boolean reconnect;
                if (reconnect = this.database.isReconnectNeeded()) {
                    return true;
                }
                if (!write) break block2;
            } while (!this.database.beforeWriting());
            return false;
        }
        return false;
    }

    @Override
    public void afterWriting() {
        this.database.afterWriting();
    }

    @Override
    public SessionInterface reconnect(boolean write) {
        this.readSessionState();
        this.close();
        Session newSession = Engine.getInstance().createSession(this.connectionInfo);
        newSession.sessionState = this.sessionState;
        newSession.recreateSessionState();
        if (write) {
            while (!newSession.database.beforeWriting()) {
            }
        }
        return newSession;
    }

    public void setConnectionInfo(ConnectionInfo ci) {
        this.connectionInfo = ci;
    }

    public Value getTransactionId() {
        if (this.database.getMvStore() != null) {
            if (this.transaction == null) {
                return ValueNull.INSTANCE;
            }
            return ValueString.get(Long.toString(this.getTransaction().getId()));
        }
        if (!this.database.isPersistent()) {
            return ValueNull.INSTANCE;
        }
        if (this.undoLog.size() == 0) {
            return ValueNull.INSTANCE;
        }
        return ValueString.get(this.firstUncommittedLog + "-" + this.firstUncommittedPos + "-" + this.id);
    }

    public int nextObjectId() {
        return this.objectId++;
    }

    public boolean isRedoLogBinaryEnabled() {
        return this.redoLogBinary;
    }

    public TransactionStore.Transaction getTransaction() {
        if (this.transaction == null) {
            if (this.database.getMvStore().getStore().isClosed()) {
                this.database.shutdownImmediately();
                throw DbException.get(90098);
            }
            this.transaction = this.database.getMvStore().getTransactionStore().begin();
            this.startStatement = -1L;
        }
        return this.transaction;
    }

    public long getStatementSavepoint() {
        if (this.startStatement == -1L) {
            this.startStatement = this.getTransaction().setSavepoint();
        }
        return this.startStatement;
    }

    public void startStatementWithinTransaction() {
        this.startStatement = -1L;
    }

    public void endStatement() {
        this.startStatement = -1L;
        this.closeTemporaryResults();
    }

    @Override
    public void addTemporaryLob(Value v) {
        if (v.getType() != 16 && v.getType() != 15) {
            return;
        }
        if (v.getTableId() == -3 || v.getTableId() == -2) {
            if (this.temporaryResultLobs == null) {
                this.temporaryResultLobs = new LinkedList();
            }
            this.temporaryResultLobs.add(new TimeoutValue(v));
        } else {
            if (this.temporaryLobs == null) {
                this.temporaryLobs = new ArrayList();
            }
            this.temporaryLobs.add(v);
        }
    }

    public static class TimeoutValue {
        final long created = System.currentTimeMillis();
        final Value value;

        TimeoutValue(Value v) {
            this.value = v;
        }
    }

    public static class Savepoint {
        int logIndex;
        long transactionSavepoint;
    }
}

