/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.org.h2.command.ddl;

import com.alibaba.dts.shade.org.h2.command.ddl.DefineCommand;
import com.alibaba.dts.shade.org.h2.engine.Database;
import com.alibaba.dts.shade.org.h2.engine.DbObject;
import com.alibaba.dts.shade.org.h2.engine.Role;
import com.alibaba.dts.shade.org.h2.engine.Session;
import com.alibaba.dts.shade.org.h2.engine.User;
import com.alibaba.dts.shade.org.h2.message.DbException;
import com.alibaba.dts.shade.org.h2.schema.Schema;
import com.alibaba.dts.shade.org.h2.schema.SchemaObject;
import com.alibaba.dts.shade.org.h2.table.Table;
import com.alibaba.dts.shade.org.h2.util.New;
import java.util.ArrayList;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;
    private String databaseName;
    private boolean ifExists;

    public DropDatabase(Session session) {
        super(session);
    }

    @Override
    public int update() {
        Database db;
        if (this.databaseName != null && !this.databaseName.equalsIgnoreCase((db = this.session.getDatabase()).getShortName())) {
            if (this.ifExists) {
                return 0;
            }
            throw DbException.get(90013, this.databaseName);
        }
        int tableCount = 0;
        if (this.dropAllObjects) {
            tableCount = this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return tableCount;
    }

    private int dropAllObjects() {
        boolean runLoopAgain;
        int tableCount = 0;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        db.lockMeta(this.session);
        do {
            ArrayList<Table> tables = db.getAllTablesAndViews(false);
            ArrayList<Table> toRemove = New.arrayList();
            for (Table t : tables) {
                if (t.getName() == null || !"VIEW".equals(t.getTableType())) continue;
                toRemove.add(t);
            }
            for (Table t : tables) {
                if (t.getName() == null || !"TABLE LINK".equals(t.getTableType())) continue;
                toRemove.add(t);
            }
            for (Table t : tables) {
                if (t.getName() == null || !"TABLE".equals(t.getTableType()) || t.isHidden()) continue;
                toRemove.add(t);
                ++tableCount;
            }
            for (Table t : tables) {
                if (t.getName() == null || !"EXTERNAL".equals(t.getTableType()) || t.isHidden()) continue;
                toRemove.add(t);
            }
            runLoopAgain = false;
            for (Table t : toRemove) {
                if (t.getName() == null) continue;
                if (db.getDependentTable(t, t) == null) {
                    db.removeSchemaObject(this.session, t);
                    continue;
                }
                runLoopAgain = true;
            }
        } while (runLoopAgain);
        for (Schema schema : db.getAllSchemas()) {
            if (!schema.canDrop()) continue;
            db.removeDatabaseObject(this.session, schema);
        }
        this.session.findLocalTempTable(null);
        ArrayList<SchemaObject> list = New.arrayList();
        list.addAll(db.getAllSchemaObjects(3));
        list.addAll(db.getAllSchemaObjects(5));
        list.addAll(db.getAllSchemaObjects(4));
        list.addAll(db.getAllSchemaObjects(11));
        list.addAll(db.getAllSchemaObjects(9));
        for (SchemaObject obj : list) {
            if (obj.isHidden()) continue;
            db.removeSchemaObject(this.session, obj);
        }
        for (User user : db.getAllUsers()) {
            if (user == this.session.getUser()) continue;
            db.removeDatabaseObject(this.session, user);
        }
        for (Role role : db.getAllRoles()) {
            String sql = role.getCreateSQL();
            if (sql == null) continue;
            db.removeDatabaseObject(this.session, role);
        }
        ArrayList<DbObject> dbObjects = New.arrayList();
        dbObjects.addAll(db.getAllRights());
        dbObjects.addAll(db.getAllAggregates());
        dbObjects.addAll(db.getAllUserDataTypes());
        for (DbObject obj : dbObjects) {
            String sql = obj.getCreateSQL();
            if (sql == null) continue;
            db.removeDatabaseObject(this.session, obj);
        }
        return tableCount;
    }

    public void setDropAllObjects(boolean b) {
        this.dropAllObjects = b;
    }

    public void setDeleteFiles(boolean b) {
        this.deleteFiles = b;
    }

    public void setDatabaseName(String name) {
        this.databaseName = name;
    }

    public void setIfExists(boolean ifExists) {
        this.ifExists = ifExists;
    }

    @Override
    public int getType() {
        return 38;
    }
}

