/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.io.netty.handler.codec.http;

import com.alibaba.dts.shade.io.netty.channel.embedded.EmbeddedChannel;
import com.alibaba.dts.shade.io.netty.handler.codec.compression.ZlibCodecFactory;
import com.alibaba.dts.shade.io.netty.handler.codec.compression.ZlibWrapper;
import com.alibaba.dts.shade.io.netty.handler.codec.http.HttpContentDecoder;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;

    public HttpContentDecompressor() {
        this(false);
    }

    public HttpContentDecompressor(boolean strict) {
        this.strict = strict;
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        if ("gzip".equalsIgnoreCase(contentEncoding) || "x-gzip".equalsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
        }
        if ("deflate".equalsIgnoreCase(contentEncoding) || "x-deflate".equalsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(ZlibCodecFactory.newZlibDecoder(wrapper));
        }
        return null;
    }
}

