/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye.json;

import com.alibaba.dts.shade.com.taobao.eagleeye.json.DefaultJSONParser;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSON;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONException;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONLexer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.JSONSerializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectDeserializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.ObjectSerializer;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.SerializeWriter;
import com.alibaba.dts.shade.com.taobao.eagleeye.json.SerializerFeature;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Type;

class ColorCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final ColorCodec instance = new ColorCodec();

    ColorCodec() {
    }

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType) throws IOException {
        SerializeWriter out = serializer.getWriter();
        Color color = (Color)object;
        if (color == null) {
            out.writeNull();
            return;
        }
        int sep = 123;
        if (out.isEnabled(SerializerFeature.WriteClassName)) {
            out.write('{');
            out.writeFieldName(JSON.DEFAULT_TYPE_KEY);
            out.writeString(Color.class.getName());
            sep = 44;
        }
        out.writeFieldValue((char)sep, "r", color.getRed());
        out.writeFieldValue(',', "g", color.getGreen());
        out.writeFieldValue(',', "b", color.getBlue());
        if (color.getAlpha() > 0) {
            out.writeFieldValue(',', "alpha", color.getAlpha());
        }
        out.write('}');
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() != 12 && lexer.token() != 16) {
            throw new JSONException("syntax error");
        }
        lexer.nextToken();
        int r = 0;
        int g = 0;
        int b = 0;
        int alpha = 0;
        while (true) {
            if (lexer.token() == 13) break;
            if (lexer.token() != 4) {
                throw new JSONException("syntax error");
            }
            String key = lexer.stringVal();
            lexer.nextTokenWithColon(2);
            if (lexer.token() != 2) {
                throw new JSONException("syntax error");
            }
            int val = lexer.intValue();
            lexer.nextToken();
            if (key.equalsIgnoreCase("r")) {
                r = val;
            } else if (key.equalsIgnoreCase("g")) {
                g = val;
            } else if (key.equalsIgnoreCase("b")) {
                b = val;
            } else if (key.equalsIgnoreCase("alpha")) {
                alpha = val;
            } else {
                throw new JSONException("syntax error, " + key);
            }
            if (lexer.token() != 16) continue;
            lexer.nextToken(4);
        }
        lexer.nextToken();
        return (T)new Color(r, g, b, alpha);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }
}

