/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.RpcContext_inner;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.BasicManagedEntity;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class TracedHttpClient
implements HttpClient {
    protected final HttpClient delegate;
    protected final int rpcType;
    protected final boolean autoStartRpc;
    protected static final Field MANAGED_CONN_FIELD;

    public TracedHttpClient(HttpClient delegate, int rpcType) {
        this(delegate, rpcType, false);
    }

    public TracedHttpClient(HttpClient delegate, int rpcType, boolean autoStartRpc) {
        this.delegate = delegate;
        this.rpcType = rpcType;
        this.autoStartRpc = autoStartRpc;
    }

    public HttpClient getDelegate() {
        return this.delegate;
    }

    public HttpParams getParams() {
        return this.delegate.getParams();
    }

    public ClientConnectionManager getConnectionManager() {
        return this.delegate.getConnectionManager();
    }

    protected <REQ extends HttpRequest> REQ traceRequest(REQ request, RpcContext_inner ctx) {
        HttpEntityEnclosingRequest er;
        HttpEntity requestEntity;
        if (request instanceof HttpEntityEnclosingRequest && (requestEntity = (er = (HttpEntityEnclosingRequest)request).getEntity()) != null) {
            er.setEntity((HttpEntity)new TracedRequestEntity(requestEntity, ctx, this.rpcType));
        }
        if (ctx.getRpcId().length() >= 3) {
            request.addHeader("EagleEye-TraceId", ctx.getTraceId());
            request.addHeader("EagleEye-RpcId", ctx.getRpcId());
        }
        ctx.setRequestSize(this.getAllHeaderSize(request.getAllHeaders()) + request.getRequestLine().toString().length() + 2);
        return request;
    }

    protected HttpResponse traceResponse(HttpResponse response, RpcContext_inner ctx) {
        String resultCode;
        if (response == null) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            return response;
        }
        StatusLine statusLine = response.getStatusLine();
        if (statusLine != null) {
            resultCode = String.valueOf(statusLine.getStatusCode());
            ctx.setResponseSize(ctx.getResponseSize() + (long)statusLine.toString().length() + 1L);
        } else {
            resultCode = "01";
        }
        ctx.setResponseSize(ctx.getResponseSize() + (long)this.getAllHeaderSize(response.getAllHeaders()) + 1L);
        HttpEntity responseEntity = response.getEntity();
        if (responseEntity == null) {
            ctx.endRpc(resultCode, this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
        } else {
            if ((ctx.getRemoteIp() == null || ctx.getRemoteIp().length() == 0) && responseEntity instanceof BasicManagedEntity) {
                HttpInetConnection httpConn;
                InetAddress remoteAddress;
                Object conn;
                try {
                    conn = MANAGED_CONN_FIELD.get(responseEntity);
                }
                catch (Exception e) {
                    conn = null;
                }
                if (conn instanceof HttpInetConnection && (remoteAddress = (httpConn = (HttpInetConnection)conn).getRemoteAddress()) != null) {
                    ctx.setRemoteIp(remoteAddress.getHostAddress() + ':' + httpConn.getRemotePort());
                }
            }
            response.setEntity((HttpEntity)new TracedResponseEntity(responseEntity, ctx, this.rpcType, resultCode));
        }
        return response;
    }

    protected int getAllHeaderSize(Header[] headers) {
        int size = 0;
        for (Header header : headers) {
            String hvalue = header.getValue();
            int hvalueSize = hvalue != null ? hvalue.length() : 0;
            size += header.getName().length() + hvalueSize + 3;
        }
        return size;
    }

    protected RpcContext_inner getHttpRpcContext(HttpRequest request) {
        if (this.autoStartRpc) {
            if (request instanceof HttpUriRequest) {
                HttpUriRequest uriRequest = (HttpUriRequest)request;
                EagleEye.startRpc(uriRequest.getMethod(), uriRequest.getURI().toString());
                return EagleEye.popRpcContext();
            }
            return null;
        }
        RpcContext_inner ctx = EagleEye.getRpcContext();
        if (ctx == null) {
            return null;
        }
        if (ctx.getParentRpcContext() == null && !"9".equals(ctx.getRpcId())) {
            return null;
        }
        EagleEye.setRpcContext(ctx.getParentRpcContext());
        return ctx;
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        RpcContext_inner ctx = this.getHttpRpcContext((HttpRequest)request);
        if (ctx == null) {
            return this.delegate.execute(request);
        }
        HttpUriRequest tracedRequest = this.traceRequest(request, ctx);
        ctx.rpcClientSend();
        try {
            return this.traceResponse(this.delegate.execute(tracedRequest), ctx);
        }
        catch (IOException e) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            throw e;
        }
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        RpcContext_inner ctx = this.getHttpRpcContext((HttpRequest)request);
        if (ctx == null) {
            return this.delegate.execute(request, context);
        }
        HttpUriRequest tracedRequest = this.traceRequest(request, ctx);
        ctx.rpcClientSend();
        try {
            return this.traceResponse(this.delegate.execute(tracedRequest, context), ctx);
        }
        catch (IOException e) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            throw e;
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        RpcContext_inner ctx = this.getHttpRpcContext(request);
        if (ctx == null) {
            return this.delegate.execute(target, request);
        }
        HttpRequest tracedRequest = this.traceRequest(request, ctx);
        ctx.rpcClientSend();
        try {
            return this.traceResponse(this.delegate.execute(target, tracedRequest), ctx);
        }
        catch (IOException e) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            throw e;
        }
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        RpcContext_inner ctx = this.getHttpRpcContext(request);
        if (ctx == null) {
            return this.delegate.execute(target, request, context);
        }
        HttpRequest tracedRequest = this.traceRequest(request, ctx);
        ctx.rpcClientSend();
        try {
            return this.traceResponse(this.delegate.execute(target, tracedRequest, context), ctx);
        }
        catch (IOException e) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            throw e;
        }
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        RpcContext_inner ctx = this.getHttpRpcContext((HttpRequest)request);
        if (ctx == null) {
            return (T)this.delegate.execute(request, responseHandler);
        }
        HttpUriRequest tracedRequest = this.traceRequest(request, ctx);
        ctx.rpcClientSend();
        try {
            return (T)this.delegate.execute(tracedRequest, new TracedResponseHandler<T>(ctx, responseHandler));
        }
        catch (IOException e) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            throw e;
        }
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        RpcContext_inner ctx = this.getHttpRpcContext((HttpRequest)request);
        if (ctx == null) {
            return (T)this.delegate.execute(request, responseHandler, context);
        }
        HttpUriRequest tracedRequest = this.traceRequest(request, ctx);
        TracedResponseHandler<? extends T> tracedHandler = new TracedResponseHandler<T>(ctx, responseHandler);
        ctx.rpcClientSend();
        try {
            return (T)this.delegate.execute(tracedRequest, tracedHandler, context);
        }
        catch (IOException e) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            throw e;
        }
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        RpcContext_inner ctx = this.getHttpRpcContext(request);
        if (ctx == null) {
            return (T)this.delegate.execute(target, request, responseHandler);
        }
        HttpRequest tracedRequest = this.traceRequest(request, ctx);
        TracedResponseHandler<? extends T> tracedHandler = new TracedResponseHandler<T>(ctx, responseHandler);
        ctx.rpcClientSend();
        try {
            return (T)this.delegate.execute(target, tracedRequest, tracedHandler);
        }
        catch (IOException e) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            throw e;
        }
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        RpcContext_inner ctx = this.getHttpRpcContext(request);
        if (ctx == null) {
            return (T)this.delegate.execute(target, request, responseHandler, context);
        }
        HttpRequest tracedRequest = this.traceRequest(request, ctx);
        TracedResponseHandler<? extends T> tracedHandler = new TracedResponseHandler<T>(ctx, responseHandler);
        ctx.rpcClientSend();
        try {
            return (T)this.delegate.execute(target, tracedRequest, tracedHandler, context);
        }
        catch (IOException e) {
            ctx.endRpc("01", this.rpcType, null);
            EagleEye.commitRpcContext(ctx);
            throw e;
        }
    }

    static {
        Field field = null;
        try {
            field = BasicManagedEntity.class.getDeclaredField("managedConn");
            field.setAccessible(true);
        }
        catch (Throwable e) {
            field = null;
        }
        MANAGED_CONN_FIELD = field;
    }

    static class TracedOutputStream
    extends OutputStream {
        protected final OutputStream delegate;
        protected final RpcContext_inner ctx;
        protected final StreamOnCloseListener listener;
        protected final boolean onRequest;
        protected boolean hasError;

        protected TracedOutputStream(OutputStream delegate, RpcContext_inner ctx, StreamOnCloseListener listener, boolean onRequest) {
            this.delegate = delegate;
            this.ctx = ctx;
            this.listener = listener;
            this.onRequest = onRequest;
        }

        public OutputStream getDelegate() {
            return this.delegate;
        }

        @Override
        public void write(int b) throws IOException {
            try {
                this.delegate.write(b);
                if (this.onRequest) {
                    this.ctx.setRequestSize(this.ctx.getRequestSize() + 1L);
                } else {
                    this.ctx.setResponseSize(this.ctx.getResponseSize() + 1L);
                }
            }
            catch (IOException e) {
                this.hasError = true;
                throw e;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            try {
                this.delegate.write(b, off, len);
                if (this.onRequest) {
                    this.ctx.setRequestSize(this.ctx.getRequestSize() + (long)len);
                } else {
                    this.ctx.setResponseSize(this.ctx.getResponseSize() + (long)len);
                }
            }
            catch (IOException e) {
                this.hasError = true;
                throw e;
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.delegate.flush();
            }
            catch (IOException e) {
                this.hasError = true;
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                if (this.listener != null) {
                    this.listener.onClose(this.hasError);
                }
            }
            catch (IOException e) {
                if (this.listener != null) {
                    this.listener.onClose(true);
                }
                throw e;
            }
        }
    }

    static class TracedInputStream
    extends InputStream {
        protected final InputStream delegate;
        protected final RpcContext_inner ctx;
        protected final StreamOnCloseListener listener;
        protected final boolean onRequest;
        protected boolean hasError;

        protected TracedInputStream(InputStream delegate, RpcContext_inner ctx, StreamOnCloseListener listener, boolean onRequest) {
            this.delegate = delegate;
            this.ctx = ctx;
            this.listener = listener;
            this.onRequest = onRequest;
        }

        public InputStream getDelegate() {
            return this.delegate;
        }

        @Override
        public int read() throws IOException {
            try {
                int ret = this.delegate.read();
                if (this.onRequest) {
                    this.ctx.setRequestSize(this.ctx.getRequestSize() + 1L);
                } else {
                    this.ctx.setResponseSize(this.ctx.getResponseSize() + 1L);
                }
                return ret;
            }
            catch (IOException e) {
                this.hasError = true;
                throw e;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int size = this.delegate.read(b, off, len);
                if (this.onRequest) {
                    this.ctx.setRequestSize(this.ctx.getRequestSize() + (long)size);
                } else {
                    this.ctx.setResponseSize(this.ctx.getResponseSize() + (long)size);
                }
                return size;
            }
            catch (IOException e) {
                this.hasError = true;
                throw e;
            }
        }

        @Override
        public long skip(long n) throws IOException {
            try {
                long skipped = this.delegate.skip(n);
                if (this.onRequest) {
                    this.ctx.setRequestSize(this.ctx.getRequestSize() + skipped);
                } else {
                    this.ctx.setResponseSize(this.ctx.getResponseSize() + skipped);
                }
                return skipped;
            }
            catch (IOException e) {
                this.hasError = true;
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.delegate.close();
                if (this.listener != null) {
                    this.listener.onClose(this.hasError);
                }
            }
            catch (IOException e) {
                if (this.listener != null) {
                    this.listener.onClose(true);
                }
                throw e;
            }
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            try {
                this.delegate.reset();
                if (this.onRequest) {
                    this.ctx.setRequestSize(0L);
                } else {
                    this.ctx.setResponseSize(0L);
                }
            }
            catch (IOException e) {
                this.hasError = true;
                throw e;
            }
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }

    static class RpcClientRecvOnClose
    implements StreamOnCloseListener {
        private final RpcContext_inner ctx;
        private final int rpcType;
        private final String defaultResultCode;

        public RpcClientRecvOnClose(RpcContext_inner ctx, int rpcType, String defaultResultCode) {
            this.ctx = ctx;
            this.rpcType = rpcType;
            this.defaultResultCode = defaultResultCode;
        }

        @Override
        public void onClose(boolean hasError) {
            if (this.ctx != null) {
                if (hasError) {
                    this.ctx.endRpc("01", this.rpcType, null);
                } else {
                    this.ctx.endRpc(this.defaultResultCode, this.rpcType, null);
                }
                EagleEye.commitRpcContext(this.ctx);
            }
        }
    }

    static interface StreamOnCloseListener {
        public void onClose(boolean var1);
    }

    static class TracedResponseEntity
    extends HttpEntityWrapper {
        protected final RpcContext_inner ctx;
        protected final int rpcType;
        protected final String defaultResultCode;

        protected TracedResponseEntity(HttpEntity delegate, RpcContext_inner ctx, int rpcType, String defaultResultCode) {
            super(delegate);
            this.ctx = ctx;
            this.rpcType = rpcType;
            this.defaultResultCode = defaultResultCode;
        }

        public HttpEntity getDelegate() {
            return this.wrappedEntity;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            InputStream stream;
            try {
                stream = this.wrappedEntity.getContent();
            }
            catch (IOException e) {
                this.ctx.endRpc("01", this.rpcType, null);
                EagleEye.commitRpcContext(this.ctx);
                throw e;
            }
            if (stream == null) {
                this.ctx.endRpc(this.defaultResultCode, this.rpcType, null);
                EagleEye.commitRpcContext(this.ctx);
                return null;
            }
            if (this.wrappedEntity.isRepeatable()) {
                return new TracedInputStream(stream, this.ctx, null, false);
            }
            return new TracedInputStream(stream, this.ctx, new RpcClientRecvOnClose(this.ctx, this.rpcType, this.defaultResultCode), false);
        }

        public void writeTo(OutputStream outstream) throws IOException {
            try {
                this.wrappedEntity.writeTo((OutputStream)new TracedOutputStream(outstream, this.ctx, new RpcClientRecvOnClose(this.ctx, this.rpcType, this.defaultResultCode), false));
            }
            catch (IOException e) {
                this.ctx.endRpc("01", this.rpcType, null);
                EagleEye.commitRpcContext(this.ctx);
                throw e;
            }
        }
    }

    static class TracedRequestEntity
    extends HttpEntityWrapper {
        protected final RpcContext_inner ctx;
        protected final int rpcType;

        protected TracedRequestEntity(HttpEntity delegate, RpcContext_inner ctx, int rpcType) {
            super(delegate);
            this.ctx = ctx;
            this.rpcType = rpcType;
        }

        public HttpEntity getDelegate() {
            return this.wrappedEntity;
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            InputStream stream = this.wrappedEntity.getContent();
            if (stream == null) {
                return null;
            }
            return new TracedInputStream(stream, this.ctx, null, true);
        }

        public void writeTo(OutputStream outstream) throws IOException {
            this.wrappedEntity.writeTo((OutputStream)new TracedOutputStream(outstream, this.ctx, null, true));
        }
    }

    class TracedResponseHandler<T>
    implements ResponseHandler<T> {
        private final RpcContext_inner ctx;
        private final ResponseHandler<? extends T> handler;

        public TracedResponseHandler(RpcContext_inner ctx, ResponseHandler<? extends T> handler) {
            this.ctx = ctx;
            this.handler = handler;
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            return (T)this.handler.handleResponse(TracedHttpClient.this.traceResponse(response, this.ctx));
        }
    }
}

