/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.eagleeye;

import com.alibaba.dts.shade.com.taobao.eagleeye.AbstractContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContext;
import com.alibaba.dts.shade.com.taobao.eagleeye.BaseContextEncoder;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeAppender;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEyeCoreUtils;
import java.io.IOException;

class DefaultRpcContextEncoder
extends BaseContextEncoder {
    private int DEFAULT_BUFFER_SIZE = 256;
    private StringBuilder buffer = new StringBuilder(this.DEFAULT_BUFFER_SIZE);

    DefaultRpcContextEncoder() {
    }

    @Override
    public void encode(BaseContext base, EagleEyeAppender eea) throws IOException {
        int samplingInterval;
        if (!(base instanceof AbstractContext)) {
            return;
        }
        AbstractContext ctx = (AbstractContext)base;
        StringBuilder buffer = this.buffer;
        buffer.delete(0, buffer.length());
        switch (ctx.logType) {
            case 1: {
                buffer.append(ctx.traceId).append('|').append(ctx.startTime).append('|').append(ctx.rpcType).append('|').append(ctx.logTime - ctx.startTime).append('|');
                if (ctx.rpcId != null && ctx.rpcId.length() >= 3) {
                    buffer.append(ctx.rpcId).append('|');
                }
                if (EagleEyeCoreUtils.isNotBlank(ctx.serviceName)) {
                    buffer.append(ctx.serviceName).append('|');
                }
                buffer.append(ctx.traceName);
                break;
            }
            case 2: {
                buffer.append(ctx.traceId).append('|').append(ctx.startTime).append('|').append(ctx.rpcType).append('|').append(ctx.rpcId).append('|').append(ctx.serviceName).append('|').append(ctx.methodName).append('|').append(ctx.remoteIp).append('|').append('[').append(ctx.span0).append(", ").append(ctx.span1).append(']').append('|').append(ctx.traceName).append('|').append(ctx.requestSize).append('|').append(ctx.responseSize);
                break;
            }
            case 3: {
                buffer.append(ctx.traceId).append('|').append(ctx.startTime).append('|').append(ctx.rpcType).append('|').append(ctx.rpcId).append('|');
                if (EagleEyeCoreUtils.isNotBlank(ctx.serviceName)) {
                    buffer.append(ctx.serviceName).append('|');
                    buffer.append(ctx.methodName).append('|');
                }
                if (EagleEyeCoreUtils.isNotBlank(ctx.traceName)) {
                    buffer.append(ctx.traceName).append('|');
                }
                buffer.append(ctx.remoteIp).append('|').append(ctx.logTime - ctx.startTime).append('|').append(ctx.responseSize);
                break;
            }
            case 4: {
                buffer.append(ctx.traceId).append('|').append(ctx.logTime).append('|').append(ctx.rpcType);
                if (!EagleEyeCoreUtils.isNotBlank(ctx.rpcId)) break;
                buffer.append('|').append(ctx.rpcId);
                break;
            }
            case 5: {
                buffer.append(ctx.traceId).append('|').append(ctx.logTime).append('|').append(ctx.rpcType).append('|').append(ctx.traceName).append('|').append(ctx.callBackMsg).append("\r\n");
                eea.append(buffer.toString());
                return;
            }
            default: {
                return;
            }
        }
        if (EagleEyeCoreUtils.isNotBlank(ctx.callBackMsg)) {
            buffer.append('|').append(ctx.callBackMsg);
        }
        if ((samplingInterval = EagleEye.getSamplingInterval()) >= 2 && samplingInterval <= 9999) {
            buffer.append("|#").append(samplingInterval);
        }
        if (!"".equals(ctx.localId) && ctx.localId != null) {
            buffer.append("|!").append(ctx.getLocalId());
        }
        ctx.logContextData(buffer);
        buffer.append("\r\n");
        eea.append(buffer.toString());
    }
}

