/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting;

import com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting.DayStressSwitch;
import com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting.RationControl;
import com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting.ShadowTbapi;
import com.alibaba.dts.shade.com.taobao.eagleeye.EagleEye;
import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import java.util.Arrays;

public class StressTestingUtil {
    private static final long TEST_USER_ID_BEGIN = 9223370014720000000L;
    private static final long FUNC_USER_ID_BEGIN = 9223372000000000000L;
    private static final long TEST_ITEM_ID_BEGIN = 900000000000000000L;
    private static final long FUNC_ITEM_ID_BEGIN = 5000000000000000000L;
    private static final int TEST_SHOP_ID_BEGIN = 1536000000;

    public static boolean isTestUser(long userId) {
        return userId >= 9223370014720000000L;
    }

    public static boolean isTestItem(long itemId) {
        return itemId >= 900000000000000000L;
    }

    public static long testItemConvert(long itemId) {
        if (StringUtils.isEmpty(EagleEye.getUserData("t"))) {
            EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", is not test flow, return! itemId=" + itemId);
            return itemId;
        }
        if (itemId >= 900000000000000000L && itemId < 5000000000000000000L) {
            return itemId - 900000000000000000L;
        }
        if (itemId >= 5000000000000000000L) {
            return itemId - 5000000000000000000L;
        }
        return itemId;
    }

    public static long testUserConvert(long userId) {
        if (StringUtils.isEmpty(EagleEye.getUserData("t"))) {
            EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", is not test flow, return! userId=" + userId);
            return userId;
        }
        if (userId >= 9223370014720000000L && userId < 9223372000000000000L) {
            return userId - 9223370014720000000L;
        }
        if (userId >= 9223372000000000000L) {
            return userId - 9223372000000000000L;
        }
        return userId;
    }

    public static boolean isTestShop(long shopId) {
        return shopId >= 1536000000L;
    }

    public static boolean isTestFlow() {
        return "1".equals(EagleEye.getUserData("t"));
    }

    public static boolean isFuncTestFlow() {
        return "1".equals(EagleEye.getUserData("t")) && StringUtils.isNotEmpty(EagleEye.getUserData("f"));
    }

    public static boolean isPreviewFlow() {
        return "1".equals(EagleEye.getUserData("t")) && StringUtils.isNotEmpty(EagleEye.getUserData("p"));
    }

    public static boolean isTestFlowAll() {
        String t = EagleEye.getUserData("t");
        return "1".equals(t) || "2".equals(t);
    }

    public static boolean isIllegalViaUserIdItemId(long userId, long itemId) {
        boolean isTestFlow = StressTestingUtil.isTestFlow();
        if (!(isTestFlow || StressTestingUtil.isTestUser(userId) || StressTestingUtil.isTestItem(itemId))) {
            return false;
        }
        if (isTestFlow && StressTestingUtil.isTestUser(userId) && StressTestingUtil.isTestItem(itemId)) {
            return false;
        }
        EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", illegal flow, userId=" + userId + ", itemId=" + itemId);
        return true;
    }

    public static boolean isIllegalViaUserIdItemId(long userId, long[] itemIds) {
        if (itemIds == null) {
            EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", illegal flow, userId=" + userId + ", itemIds=null");
            return true;
        }
        boolean isTestFlow = StressTestingUtil.isTestFlow();
        if (!isTestFlow && !StressTestingUtil.isTestUser(userId)) {
            for (long id : itemIds) {
                if (!StressTestingUtil.isTestItem(id)) continue;
                EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", illegal flow, userId=" + userId + ", itemIds=" + Arrays.toString(itemIds));
                return true;
            }
            return false;
        }
        if (isTestFlow && StressTestingUtil.isTestUser(userId)) {
            for (long id : itemIds) {
                if (StressTestingUtil.isTestItem(id)) continue;
                EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", illegal flow, userId=" + userId + ", itemIds=" + Arrays.toString(itemIds));
                return true;
            }
            return false;
        }
        EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", illegal flow, userId=" + userId + ", itemIds=" + Arrays.toString(itemIds));
        return true;
    }

    public static boolean isIllegalViaUserId(long userId) {
        boolean isTestFlow = StressTestingUtil.isTestFlow();
        if (!isTestFlow && !StressTestingUtil.isTestUser(userId)) {
            return false;
        }
        if (isTestFlow && StressTestingUtil.isTestUser(userId)) {
            return false;
        }
        EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", illegal flow, userId=" + userId);
        return true;
    }

    public static boolean isTDDLIllegalFlow(long buyerId) {
        boolean isTestFlow = StressTestingUtil.isTestFlow();
        if (!isTestFlow && !StressTestingUtil.isTestUser(buyerId)) {
            return false;
        }
        if (isTestFlow && StressTestingUtil.isTestUser(buyerId)) {
            return false;
        }
        EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", TDDL illegal flow, buyerId=" + buyerId);
        return true;
    }

    public static boolean isIllegalViaItemId(long itemId) {
        boolean isTestFlow = StressTestingUtil.isTestFlow();
        if (!isTestFlow && !StressTestingUtil.isTestItem(itemId)) {
            return false;
        }
        if (isTestFlow && StressTestingUtil.isTestItem(itemId)) {
            return false;
        }
        EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", illegal flow, itemId=" + itemId);
        return true;
    }

    public static boolean isIllegalViaShopId(long shopId) {
        boolean isTestFlow = StressTestingUtil.isTestFlow();
        if (!isTestFlow && !StressTestingUtil.isTestShop(shopId)) {
            return false;
        }
        if (isTestFlow && StressTestingUtil.isTestShop(shopId)) {
            return false;
        }
        EagleEye.selfLog("[StressTest] " + EagleEye.getTraceId() + ", " + EagleEye.getRpcId() + ", illegal flow, shopId=" + shopId);
        return true;
    }

    public static boolean isUseTestGroup() {
        boolean notReal = "1".equals(EagleEye.getUserData("t")) || "2".equals(EagleEye.getUserData("t"));
        boolean switchOn = DayStressSwitch.SWITCH_VALUE == 1;
        return notReal && switchOn;
    }

    public static boolean isIsolationFlow() {
        return "1".equals(EagleEye.getUserData("geli"));
    }

    public static String getStressVipserverKey(String originVipserverKey) {
        return originVipserverKey + "_yace";
    }

    public static String getIsolationDomain(String originDomain) {
        int pos = -1;
        if (originDomain != null && (pos = originDomain.indexOf(".")) > -1) {
            String firPart = originDomain.substring(0, pos);
            if (firPart.contains("-yace")) {
                return originDomain;
            }
            String isolationDomain = firPart + "-yace" + originDomain.substring(pos);
            return isolationDomain;
        }
        return originDomain;
    }

    public static boolean isTestFlowMissRatio(String key) {
        if (!StressTestingUtil.isTestFlow()) {
            return false;
        }
        return RationControl.missRation(key);
    }

    public static String getShadowTbapiUrl() {
        return ShadowTbapi.URL_VALUE;
    }

    public static boolean isTestJuId(long juId) {
        return juId < 1L || juId > 9999999999999999L;
    }

    public static boolean isTestJuSignRecordId(long signRecordId) {
        return signRecordId < 1L || signRecordId > 9999999999L;
    }

    public static boolean isTestJuShowPitId(long showPitId) {
        return showPitId < 1L || showPitId > 9999999999L;
    }

    public static boolean isTestJuActivityId(long activityId) {
        return activityId < 1L || activityId > 99999999L;
    }

    public static boolean isTestJuBusinessId(long businessId) {
        return businessId < 1L || businessId > 9999999L;
    }

    public static boolean isTestJuChannelId(long channelId) {
        return channelId < 1L || channelId > 99999L;
    }

    public static boolean isTestJuSalesSiteId(long salesSiteId) {
        return salesSiteId < 1L || salesSiteId > 99999L;
    }
}

