/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.domain.DtsConfiguration;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionUtil {
    private static final Class<?>[] EMPTY_ARRAY = new Class[0];
    private static final Map<Class<?>, Constructor<?>> CONSTRUCTOR_CACHE = new ConcurrentHashMap();
    private static final Map<String, Class<?>> CLASS_CACHE = new ConcurrentHashMap();

    private static <T> T newInstance(Class<T> clazz) {
        Object result;
        try {
            Constructor<Object> meth = CONSTRUCTOR_CACHE.get(clazz);
            if (meth == null) {
                meth = clazz.getDeclaredConstructor(EMPTY_ARRAY);
                meth.setAccessible(true);
                CONSTRUCTOR_CACHE.put(clazz, meth);
            }
            result = meth.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return (T)result;
    }

    public static <T> T getInstanceByClassName(String className) throws ClassNotFoundException {
        Class<?> clazz = CLASS_CACHE.get(className);
        if (clazz == null) {
            clazz = Class.forName(className);
            CLASS_CACHE.put(className, clazz);
        }
        return (T)ReflectionUtil.newInstance(clazz);
    }

    public static <T> List<T> getInstancesByConf(DtsConfiguration conf, String key) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String[] classNameArray = conf.getStringArray(key);
        ArrayList<T> instances = new ArrayList<T>();
        if (classNameArray == null || classNameArray.length == 0) {
            return instances;
        }
        for (String className : classNameArray) {
            T theClass = ReflectionUtil.getInstanceByClassName(className);
            instances.add(theClass);
        }
        return instances;
    }

    public static Object invokeMethod(Object owner, String methodName, Object[] args) throws Exception {
        Class<?> ownerClass = owner.getClass();
        Class[] argsClass = new Class[args.length];
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            argsClass[i] = args[i].getClass();
        }
        Method method = ownerClass.getMethod(methodName, argsClass);
        return method.invoke(owner, args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object[] args) throws Exception {
        Class<?> ownerClass = Class.forName(className);
        Class[] argsClass = new Class[args.length];
        int j = args.length;
        for (int i = 0; i < j; ++i) {
            argsClass[i] = args[i].getClass();
        }
        Method method = ownerClass.getMethod(methodName, argsClass);
        return method.invoke(null, args);
    }
}

