/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.shade.org.ini4j.Config;
import com.alibaba.dts.shade.org.ini4j.Ini;
import com.alibaba.dts.shade.org.ini4j.Profile;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IniUtil
implements Constants {
    private static final Log logger = LogFactory.getLog(IniUtil.class);

    public static Map<String, String> getIniValuesFromFile(String configFilePath, String sectionName) {
        Map<String, Profile.Section> sectionsMap = IniUtil.getIniSectionsFormFile(configFilePath, null);
        Profile.Section section = sectionsMap.get(sectionName);
        if (null != section) {
            HashMap<String, String> valueMap = new HashMap<String, String>(section.size());
            for (Map.Entry entry : section.entrySet()) {
                valueMap.put((String)entry.getKey(), (String)entry.getValue());
            }
            return valueMap;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Profile.Section> getIniSectionsFormFile(String filePath, Charset charset) {
        Ini ini = new Ini();
        Config config = ini.getConfig();
        config.setFileEncoding(charset != null ? charset : DEFAULT_CHARSET);
        File iniFile = new File(filePath);
        if (iniFile.exists() && iniFile.isFile()) {
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(iniFile);
                ini.load(fis);
                HashMap sectionMap = new HashMap(ini.size());
                for (Map.Entry entry : ini.entrySet()) {
                    sectionMap.put(entry.getKey(), entry.getValue());
                }
                HashMap hashMap = sectionMap;
                return hashMap;
            }
            catch (Throwable e) {
                logger.error((Object)"getIniFile Error!", e);
            }
            finally {
                if (null != fis) {
                    try {
                        fis.close();
                    }
                    catch (Throwable e) {
                        logger.error((Object)"getIniFile close FileInputStream Error!", e);
                    }
                }
            }
        }
        logger.error((Object)("getIniFile Error, file not exists, filePath:" + filePath));
        return Collections.emptyMap();
    }
}

