/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.ClientGroup;
import com.alibaba.dts.common.domain.store.Cluster;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.util.StringUtil;

public class GroupIdUtil
implements Constants {
    public static String getGroupId(Cluster cluster, ClientGroup clientGroup) {
        return cluster.getId() + "-" + clientGroup.getServerGroupId() + "-" + cluster.getJobBackupAmount() + "-" + clientGroup.getId();
    }

    public static String generateGroupId(long clusterId, long serverGroupId, int backAmout, long clientGroupId) {
        return clusterId + "-" + serverGroupId + "-" + backAmout + "-" + clientGroupId;
    }

    public static String getGroupId(Cluster cluster, Job job, int jobBackupAmount) {
        return cluster.getId() + "-" + job.getServerGroupId() + "-" + jobBackupAmount + "-" + job.getClientGroupId();
    }

    public static boolean checkGroupId(String groupId) {
        if (StringUtil.isBlank(groupId)) {
            throw new RuntimeException("groupId is null! please set groupId, you can get groupId from console page");
        }
        String[] s = groupId.split("-");
        if (s.length != 4) {
            throw new RuntimeException("groupId is error! please check groupId, like this format xxx-xxx-xxx-xxx. but you set groupId:" + groupId);
        }
        return true;
    }

    public static boolean checkClientGroupId(String groupId) {
        if (StringUtil.isBlank(groupId)) {
            return false;
        }
        String[] s = groupId.split("-");
        return s.length == 4;
    }

    public static Cluster getCluster(String groupId) {
        String[] s = groupId.split("-");
        Cluster cluster = new Cluster();
        cluster.setId(Long.parseLong(s[0]));
        cluster.setJobBackupAmount(Integer.parseInt(s[2]));
        return cluster;
    }

    public static ClientGroup getClientGroup(String groupId) {
        String[] s = groupId.split("-");
        ClientGroup clientGroup = new ClientGroup();
        clientGroup.setServerGroupId(Long.parseLong(s[1]));
        clientGroup.setId(Long.parseLong(s[3]));
        return clientGroup;
    }
}

