/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.util;

import com.alibaba.dts.common.constants.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileUtil
implements Constants {
    private static final Log logger = LogFactory.getLog(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write(String filePath, String fileName, String content) {
        File path = new File(filePath);
        if (!path.exists()) {
            boolean createResult = false;
            try {
                createResult = path.mkdirs();
            }
            catch (Throwable e) {
                logger.error((Object)"[FileUtil]: write mkdirs error", e);
                return false;
            }
            logger.warn((Object)("[FileUtil]: write mkdirs, createResult:" + createResult));
        }
        File file = new File(filePath + System.getProperty("file.separator") + fileName);
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file, true)));
            writer.write(content + "\r\n");
            writer.flush();
        }
        catch (Throwable e) {
            logger.error((Object)"[FileUtil]: FileWriter write error", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable e) {
                    logger.error((Object)"[FileUtil]: FileWriter write close error", e);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> read(String filePath) {
        ArrayList<String> lineList = new ArrayList<String>();
        File file = new File(filePath);
        if (!file.exists()) {
            return lineList;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                lineList.add(line);
            }
        }
        catch (Throwable e) {
            logger.error((Object)"[FileUtil]: FileReader read error", e);
            ArrayList<String> arrayList = lineList;
            return arrayList;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable e) {
                    logger.error((Object)"[FileUtil]: FileReader read close error", e);
                }
            }
        }
        return lineList;
    }

    public static List<String> getFileList(String path) {
        ArrayList<String> fileList = new ArrayList<String>();
        File file = new File(path);
        if (!file.exists()) {
            return fileList;
        }
        File[] fileArray = file.listFiles();
        if (null == fileArray || fileArray.length <= 0) {
            return fileList;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            fileList.add(fileArray[i].getName());
        }
        return fileList;
    }

    public static boolean deleteFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }
}

