/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.remoting.netty;

import com.alibaba.dts.common.domain.remoting.Pair;
import com.alibaba.dts.common.domain.remoting.SemaphoreReleaseOnlyOnce;
import com.alibaba.dts.common.domain.remoting.ServiceThread;
import com.alibaba.dts.common.exception.RemotingSendRequestException;
import com.alibaba.dts.common.exception.RemotingTimeoutException;
import com.alibaba.dts.common.exception.RemotingTooMuchRequestException;
import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.remoting.ChannelEventListener;
import com.alibaba.dts.common.remoting.InvokeCallback;
import com.alibaba.dts.common.remoting.RPCHook;
import com.alibaba.dts.common.remoting.netty.NettyEvent;
import com.alibaba.dts.common.remoting.netty.NettyRequestProcessor;
import com.alibaba.dts.common.remoting.netty.ResponseFuture;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.shade.io.netty.channel.Channel;
import com.alibaba.dts.shade.io.netty.channel.ChannelFuture;
import com.alibaba.dts.shade.io.netty.channel.ChannelFutureListener;
import com.alibaba.dts.shade.io.netty.channel.ChannelHandlerContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NettyRemotingAbstract {
    private static final Log plog = LogFactory.getLog(NettyRemotingAbstract.class);
    protected final Semaphore semaphoreOneway;
    protected final Semaphore semaphoreAsync;
    protected final ConcurrentHashMap<Integer, ResponseFuture> responseTable = new ConcurrentHashMap(256);
    protected Pair<NettyRequestProcessor, ExecutorService> defaultRequestProcessor;
    protected final HashMap<Integer, Pair<NettyRequestProcessor, ExecutorService>> processorTable = new HashMap(64);
    protected final NettyEventExecuter nettyEventExecuter = new NettyEventExecuter();

    public abstract ChannelEventListener getChannelEventListener();

    public abstract RPCHook getRPCHook();

    public void putNettyEvent(NettyEvent event) {
        this.nettyEventExecuter.putNettyEvent(event);
    }

    public NettyRemotingAbstract(int permitsOneway, int permitsAsync) {
        this.semaphoreOneway = new Semaphore(permitsOneway, true);
        this.semaphoreAsync = new Semaphore(permitsAsync, true);
    }

    public void processRequestCommand(final ChannelHandlerContext ctx, final RemotingCommand cmd) {
        Pair<NettyRequestProcessor, ExecutorService> pair;
        Pair<NettyRequestProcessor, ExecutorService> matched = this.processorTable.get(cmd.getCode());
        Pair<NettyRequestProcessor, ExecutorService> pair2 = pair = null == matched ? this.defaultRequestProcessor : matched;
        if (pair != null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    block7: {
                        try {
                            RPCHook rpcHook = NettyRemotingAbstract.this.getRPCHook();
                            if (rpcHook != null) {
                                rpcHook.doBeforeRequest(RemotingHelper.parseChannelRemoteAddr(ctx.channel()), cmd);
                            }
                            RemotingCommand response = ((NettyRequestProcessor)pair.getObject1()).processRequest(ctx, cmd);
                            if (rpcHook != null) {
                                rpcHook.doAfterResponse(cmd, response);
                            }
                            if (!cmd.isOnewayRPC() && response != null) {
                                response.setOpaque(cmd.getOpaque());
                                response.markResponseType();
                                try {
                                    ctx.writeAndFlush(response);
                                }
                                catch (Throwable e) {
                                    plog.error((Object)"process request over, but response failed", e);
                                    plog.error((Object)cmd.toString());
                                    plog.error((Object)response.toString());
                                }
                            }
                        }
                        catch (Throwable e) {
                            plog.error((Object)"process request exception", e);
                            plog.error((Object)cmd.toString());
                            if (cmd.isOnewayRPC()) break block7;
                            RemotingCommand response = RemotingCommand.createResponseCommand(1, RemotingHelper.exceptionSimpleDesc(e));
                            response.setOpaque(cmd.getOpaque());
                            ctx.writeAndFlush(response);
                        }
                    }
                }
            };
            try {
                pair.getObject2().submit(run);
            }
            catch (RejectedExecutionException e) {
                plog.warn((Object)(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + ", too many requests and system thread pool busy, RejectedExecutionException " + pair.getObject2().toString() + " request code: " + cmd.getCode()));
                if (!cmd.isOnewayRPC()) {
                    RemotingCommand response = RemotingCommand.createResponseCommand(2, "too many requests and system thread pool busy, please try another server");
                    response.setOpaque(cmd.getOpaque());
                    ctx.writeAndFlush(response);
                }
            }
        } else {
            String error = " request type " + cmd.getCode() + " not supported";
            RemotingCommand response = RemotingCommand.createResponseCommand(3, error);
            response.setOpaque(cmd.getOpaque());
            ctx.writeAndFlush(response);
            plog.error((Object)(RemotingHelper.parseChannelRemoteAddr(ctx.channel()) + error));
        }
    }

    public void processResponseCommand(ChannelHandlerContext ctx, RemotingCommand cmd) {
        final ResponseFuture responseFuture = this.responseTable.get(cmd.getOpaque());
        if (responseFuture != null) {
            responseFuture.setResponseCommand(cmd);
            responseFuture.release();
            if (responseFuture.getInvokeCallback() != null) {
                boolean runInThisThread = false;
                ExecutorService executor = this.getCallbackExecutor();
                if (executor != null) {
                    try {
                        executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    responseFuture.executeInvokeCallback();
                                }
                                catch (Throwable e) {
                                    plog.warn((Object)"excute callback in executor exception, and callback throw", e);
                                }
                            }
                        });
                    }
                    catch (Exception e) {
                        runInThisThread = true;
                        plog.warn((Object)"excute callback in executor exception, maybe executor busy", (Throwable)e);
                    }
                } else {
                    runInThisThread = true;
                }
                if (runInThisThread) {
                    try {
                        responseFuture.executeInvokeCallback();
                    }
                    catch (Throwable e) {
                        plog.warn((Object)"executeInvokeCallback Exception", e);
                    }
                }
            } else {
                responseFuture.putResponse(cmd);
            }
        } else {
            plog.warn((Object)("receive response, but not matched any request, " + RemotingHelper.parseChannelRemoteAddr(ctx.channel())));
            plog.warn((Object)cmd.toString());
        }
        this.responseTable.remove(cmd.getOpaque());
    }

    public void processMessageReceived(ChannelHandlerContext ctx, RemotingCommand msg) throws Exception {
        RemotingCommand cmd = msg;
        if (cmd != null) {
            switch (cmd.getType()) {
                case REQUEST_COMMAND: {
                    this.processRequestCommand(ctx, cmd);
                    break;
                }
                case RESPONSE_COMMAND: {
                    this.processResponseCommand(ctx, cmd);
                    break;
                }
            }
        }
    }

    public abstract ExecutorService getCallbackExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanResponseTable() {
        Iterator<Map.Entry<Integer, ResponseFuture>> it = this.responseTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, ResponseFuture> next = it.next();
            ResponseFuture rep = next.getValue();
            if (rep.getBeginTimestamp() + rep.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            it.remove();
            try {
                rep.executeInvokeCallback();
            }
            catch (Throwable e) {
                plog.warn((Object)"scanResponseTable, operationComplete Exception", e);
            }
            finally {
                rep.release();
            }
            plog.warn((Object)("remove timeout request, " + rep));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemotingCommand invokeSyncImpl(final Channel channel, final RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingSendRequestException, RemotingTimeoutException {
        try {
            final ResponseFuture responseFuture = new ResponseFuture(request.getOpaque(), timeoutMillis, null, null);
            this.responseTable.put(request.getOpaque(), responseFuture);
            channel.writeAndFlush(request).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture f) throws Exception {
                    if (f.isSuccess()) {
                        responseFuture.setSendRequestOK(true);
                        return;
                    }
                    responseFuture.setSendRequestOK(false);
                    NettyRemotingAbstract.this.responseTable.remove(request.getOpaque());
                    responseFuture.setCause(f.cause());
                    responseFuture.putResponse(null);
                    plog.warn((Object)("send a request command to channel <" + channel.remoteAddress() + "> failed."));
                    plog.warn((Object)request.toString());
                }
            });
            RemotingCommand responseCommand = responseFuture.waitResponse(timeoutMillis);
            if (null == responseCommand) {
                if (responseFuture.isSendRequestOK()) {
                    throw new RemotingTimeoutException(RemotingHelper.parseChannelRemoteAddr(channel), timeoutMillis, responseFuture.getCause());
                }
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), responseFuture.getCause());
            }
            RemotingCommand remotingCommand = responseCommand;
            return remotingCommand;
        }
        finally {
            this.responseTable.remove(request.getOpaque());
        }
    }

    public void invokeAsyncImpl(final Channel channel, final RemotingCommand request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        boolean acquired = this.semaphoreAsync.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreAsync);
            final ResponseFuture responseFuture = new ResponseFuture(request.getOpaque(), timeoutMillis, invokeCallback, once);
            this.responseTable.put(request.getOpaque(), responseFuture);
            try {
                channel.writeAndFlush(request).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture f) throws Exception {
                        if (f.isSuccess()) {
                            responseFuture.setSendRequestOK(true);
                            return;
                        }
                        responseFuture.setSendRequestOK(false);
                        responseFuture.putResponse(null);
                        NettyRemotingAbstract.this.responseTable.remove(request.getOpaque());
                        try {
                            responseFuture.executeInvokeCallback();
                        }
                        catch (Throwable e) {
                            plog.warn((Object)"excute callback in writeAndFlush addListener, and callback throw", e);
                        }
                        finally {
                            responseFuture.release();
                        }
                        plog.warn((Object)("send a request command to channel <{" + RemotingHelper.parseChannelRemoteAddr(channel) + "}> failed."));
                        plog.warn((Object)request.toString());
                    }
                });
            }
            catch (Exception e) {
                responseFuture.release();
                plog.warn((Object)("send a request command to channel <" + RemotingHelper.parseChannelRemoteAddr(channel) + "> Exception"), (Throwable)e);
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeAsyncImpl invoke too fast");
            }
            String info = String.format("invokeAsyncImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            plog.warn((Object)info);
            plog.warn((Object)request.toString());
            throw new RemotingTimeoutException(info);
        }
    }

    public void invokeOnewayImpl(final Channel channel, final RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingTooMuchRequestException, RemotingTimeoutException, RemotingSendRequestException {
        request.markOnewayRPC();
        boolean acquired = this.semaphoreOneway.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            final SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreOneway);
            try {
                channel.writeAndFlush(request).addListener(new ChannelFutureListener(){

                    @Override
                    public void operationComplete(ChannelFuture f) throws Exception {
                        once.release();
                        if (!f.isSuccess()) {
                            plog.warn((Object)("send a request command to channel <" + channel.remoteAddress() + "> failed."));
                            plog.warn((Object)request.toString());
                        }
                    }
                });
            }
            catch (Exception e) {
                once.release();
                plog.warn((Object)("write send a request command to channel <" + channel.remoteAddress() + "> failed."));
                throw new RemotingSendRequestException(RemotingHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemotingTooMuchRequestException("invokeOnewayImpl invoke too fast");
            }
            String info = String.format("invokeOnewayImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            plog.warn((Object)info);
            plog.warn((Object)request.toString());
            throw new RemotingTimeoutException(info);
        }
    }

    class NettyEventExecuter
    extends ServiceThread {
        private final LinkedBlockingQueue<NettyEvent> eventQueue = new LinkedBlockingQueue();
        private final int MaxSize = 10000;

        NettyEventExecuter() {
        }

        public void putNettyEvent(NettyEvent event) {
            if (this.eventQueue.size() <= 10000) {
                this.eventQueue.add(event);
            } else {
                plog.warn((Object)("event queue size[{" + this.eventQueue.size() + "}] enough, so drop this event {" + event.toString() + "}"));
            }
        }

        @Override
        public void run() {
            plog.info((Object)(this.getServiceName() + " service started"));
            ChannelEventListener listener = NettyRemotingAbstract.this.getChannelEventListener();
            while (!this.isStoped()) {
                try {
                    NettyEvent event = this.eventQueue.poll(3000L, TimeUnit.MILLISECONDS);
                    if (event == null || listener == null) continue;
                    switch (event.getType()) {
                        case IDLE: {
                            listener.onChannelIdle(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CLOSE: {
                            listener.onChannelClose(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case CONNECT: {
                            listener.onChannelConnect(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                        case EXCEPTION: {
                            listener.onChannelException(event.getRemoteAddr(), event.getChannel());
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    plog.warn((Object)(this.getServiceName() + " service has exception. "), (Throwable)e);
                }
            }
            plog.info((Object)(this.getServiceName() + " service end"));
        }

        @Override
        public String getServiceName() {
            return NettyEventExecuter.class.getSimpleName();
        }
    }
}

