/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.logger.innerlog;

import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.dts.shade.org.apache.commons.lang.reflect.MethodUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

public class LoggerClassLoader
extends ClassLoader {
    private static final String LOGBACK_LIB = "logback-assemble-1.2.3.jlb";
    private static final long LOGBACK_LIB_CHECK_LENGTH = 794653L;
    private static final String LOCK_FILE = "logback-assemble.lock";
    private static final String SYSTEM_TMP_DIR = System.getProperty("user.home");
    private static final String SYSTEM_FILE_SEP = System.getProperty("file.separator");
    private static final String OUT_LIB_DIR_NAME = ".inner-logger";
    private static final String OUT_LIB_DIR_PATH = SYSTEM_TMP_DIR + SYSTEM_FILE_SEP + ".inner-logger";
    private static final String OUT_LIB_PATH = OUT_LIB_DIR_PATH + SYSTEM_FILE_SEP + "logback-assemble-1.2.3.jlb";
    private static final String LOCK_PATH = OUT_LIB_DIR_PATH + SYSTEM_FILE_SEP + "logback-assemble.lock";
    private Method logMethod;
    private Object innerFactory;
    private Class<?> sl4jLogFactoryClass;
    private Integer id;
    private boolean configure = false;

    protected LoggerClassLoader(Integer id) {
        super(null);
        this.id = id;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        URL logLibUrl = Thread.currentThread().getContextClassLoader().getResource(LOGBACK_LIB);
        String libProtocol = logLibUrl.getProtocol();
        if ("file".equals(libProtocol)) {
            File libFile = new File(logLibUrl.getFile());
            try {
                JarFile libJarFile = new JarFile(libFile);
                return this.getClassFromJarEntry(name, libJarFile);
            }
            catch (IOException e) {
                throw new ClassNotFoundException("inner Logger className: " + name, e);
            }
        }
        if ("jar".equals(libProtocol)) {
            String logbackUrl = logLibUrl.toString();
            String outerJarPath = StringUtils.substringBeforeLast(StringUtils.substringAfter(logbackUrl, "jar:file:"), "!");
            return this.getaClassFromOutLib(name, outerJarPath);
        }
        if ("vfs".equals(libProtocol)) {
            String innerLoggerPath = StringUtils.substringBeforeLast(logLibUrl.getFile(), SYSTEM_FILE_SEP);
            return this.getaClassFromOutLib(name, innerLoggerPath);
        }
        throw new ClassNotFoundException("Not Supported Lib Protocol: " + libProtocol + " ClassName: " + name);
    }

    private Class<?> getaClassFromOutLib(String name, String jarPath) throws ClassNotFoundException {
        File outLogLibFile = this.exportInnerLib2Local(jarPath);
        JarFile libJarFile = null;
        try {
            libJarFile = new JarFile(outLogLibFile);
            Class<?> clazz = this.getClassFromJarEntry(name, libJarFile);
            return clazz;
        }
        catch (Exception e) {
            throw new ClassNotFoundException("Load Class From OutLib: " + outLogLibFile.getAbsolutePath() + ", ClassName: " + name, e);
        }
        finally {
            if (null != libJarFile) {
                try {
                    libJarFile.close();
                }
                catch (IOException e) {
                    throw new ClassNotFoundException("close file occur error", e);
                }
            }
        }
    }

    private static void extractNestedJar(String innerLoggerPath) throws IOException {
        String absoluteJarPath = null;
        String currentPath = null;
        ZipFile logbackJarFile = null;
        try {
            currentPath = System.getProperty("user.dir");
            if (innerLoggerPath.contains(currentPath) || innerLoggerPath.contains("/home/")) {
                absoluteJarPath = "jar:file:" + innerLoggerPath;
            } else {
                String outerJar = StringUtils.substringBefore(innerLoggerPath, ".jar");
                int startIndex = outerJar.lastIndexOf("/") + 1;
                absoluteJarPath = "jar:file:" + currentPath + SYSTEM_FILE_SEP + innerLoggerPath.substring(startIndex);
            }
            URL jarUrl = new URL(absoluteJarPath);
            JarURLConnection connection = (JarURLConnection)jarUrl.openConnection();
            JarFile innerLogJarFile = connection.getJarFile();
            JarEntry innerLogJarEntry = connection.getJarEntry();
            File tempJarFile = new File(OUT_LIB_DIR_PATH + SYSTEM_FILE_SEP + "temp-inner-logger.jar");
            FileOutputStream temp = new FileOutputStream(tempJarFile);
            LoggerClassLoader.copyInput2OutPut(innerLogJarFile.getInputStream(innerLogJarEntry), temp);
            logbackJarFile = new JarFile(tempJarFile);
            innerLogJarEntry = ((JarFile)logbackJarFile).getJarEntry(LOGBACK_LIB);
            File outLogLibFile = new File(OUT_LIB_PATH);
            FileOutputStream outLibFileOut = new FileOutputStream(outLogLibFile);
            LoggerClassLoader.copyInput2OutPut(((JarFile)logbackJarFile).getInputStream(innerLogJarEntry), outLibFileOut);
        }
        catch (Exception e) {
            throw new RuntimeException("extractNestedJar occur error, innerLoggerPath : " + innerLoggerPath + ", currentPath : " + currentPath + ", absoluteJarPath : " + absoluteJarPath, e);
        }
        finally {
            if (logbackJarFile != null) {
                try {
                    logbackJarFile.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File exportInnerLib2Local(String jarPath) throws ClassNotFoundException {
        File outLogLibFile = new File(OUT_LIB_PATH);
        if (outLogLibFile.exists() && 794653L == outLogLibFile.length()) {
            return outLogLibFile;
        }
        Class<LoggerClassLoader> clazz = LoggerClassLoader.class;
        synchronized (LoggerClassLoader.class) {
            File lockFile = new File(LOCK_PATH);
            if (!lockFile.getParentFile().exists()) {
                lockFile.getParentFile().mkdir();
            }
            FileOutputStream lockFileOut = null;
            FileLock lock = null;
            ZipFile innerLogJarFile = null;
            FileOutputStream outLibFileOut = null;
            try {
                lockFileOut = new FileOutputStream(lockFile);
                lock = lockFileOut.getChannel().lock();
                outLibFileOut = new FileOutputStream(outLogLibFile);
                if (jarPath.split(".jar!/").length > 1) {
                    LoggerClassLoader.extractNestedJar(jarPath);
                } else {
                    innerLogJarFile = new JarFile(jarPath);
                    JarEntry innerLogJarEntry = ((JarFile)innerLogJarFile).getJarEntry(LOGBACK_LIB);
                    LoggerClassLoader.copyInput2OutPut(((JarFile)innerLogJarFile).getInputStream(innerLogJarEntry), outLibFileOut);
                }
                if (794653L != outLogLibFile.length()) {
                    outLogLibFile.delete();
                    throw new ClassNotFoundException("out lib file error, will remove lib, correct length : 794653, error length : " + outLogLibFile.length() + ", outPath : " + outLogLibFile.getAbsolutePath());
                }
                File file = outLogLibFile;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return file;
            }
            catch (IOException e) {
                throw new ClassNotFoundException("export innerlogger to local error, jarPath : " + jarPath, e);
            }
            finally {
                if (null != lock) {
                    try {
                        lock.release();
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException("lock.release occur error", e);
                    }
                }
                if (null != lockFileOut) {
                    try {
                        lockFileOut.close();
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException("close file occur error", e);
                    }
                }
                if (null != innerLogJarFile) {
                    try {
                        innerLogJarFile.close();
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException("close file occur error", e);
                    }
                }
                if (null != outLibFileOut) {
                    try {
                        outLibFileOut.close();
                    }
                    catch (IOException e) {
                        throw new ClassNotFoundException("close file occur error", e);
                    }
                }
            }
        }
    }

    private Class<?> getClassFromJarEntry(String name, JarFile jarFile) throws ClassNotFoundException {
        Class<?> clazz = null;
        FilterInputStream dis = null;
        try {
            JarEntry innerClassEntry = jarFile.getJarEntry(StringUtils.replace(name, ".", "/") + ".class");
            if (null == innerClassEntry) {
                throw new ClassNotFoundException("Inner Logger ClassName: " + name);
            }
            dis = new DataInputStream(jarFile.getInputStream(innerClassEntry));
            byte[] classBytes = new byte[(int)innerClassEntry.getSize()];
            ((DataInputStream)dis).readFully(classBytes);
            clazz = this.defineClass(name, classBytes, 0, classBytes.length);
        }
        catch (IOException e) {
            File outLogLibFile = new File(OUT_LIB_PATH);
            outLogLibFile.delete();
            throw new ClassNotFoundException("Inner Logger ClassName: " + name, e);
        }
        finally {
            if (null != jarFile) {
                try {
                    jarFile.close();
                }
                catch (IOException iOException) {}
            }
            if (null != dis) {
                try {
                    dis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return clazz;
    }

    private static int copyInput2OutPut(InputStream input, OutputStream output) throws IOException {
        int n;
        long count = 0L;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        if (count > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)count;
    }

    protected Object getInnerLogger(String loggerName) {
        if (null == this.logMethod) {
            this.logMethod = MethodUtils.getMatchingAccessibleMethod(this.sl4jLogFactoryClass, "getLogger", new Class[]{String.class});
            this.logMethod.setAccessible(true);
        }
        try {
            return this.logMethod.invoke(null, loggerName);
        }
        catch (Exception e) {
            throw new RuntimeException("invoke get inner logger Error! logName: " + loggerName, e);
        }
    }

    protected boolean isConfigure() {
        return this.configure;
    }

    protected void setConfigure(boolean configure) {
        this.configure = configure;
    }

    protected Object getInnerFactory() {
        return this.innerFactory;
    }

    protected Class<?> getSl4jLogFactoryClass() {
        return this.sl4jLogFactoryClass;
    }

    protected void setInnerFactory(Object innerFactory) {
        this.innerFactory = innerFactory;
    }

    protected void setSl4jLogFactoryClass(Class<?> sl4jLogFactoryClass) {
        this.sl4jLogFactoryClass = sl4jLogFactoryClass;
    }

    protected Integer getId() {
        return this.id;
    }

    public static void main(String[] args) throws IOException {
        LoggerClassLoader.printPath();
    }

    private static void printPath() {
        System.out.println("====");
        URL jarUrl2 = Thread.currentThread().getContextClassLoader().getResource(LOGBACK_LIB);
        System.out.println(jarUrl2);
        String relativelyPath = System.getProperty("user.dir");
        System.out.println(relativelyPath);
        URL resource = Thread.currentThread().getContextClassLoader().getResource("");
        System.out.println(resource);
        URL p2 = LoggerClassLoader.class.getResource("");
        System.out.println(p2);
        URL p3 = LoggerClassLoader.class.getResource("/");
        System.out.println(p3);
        System.out.println(ClassLoader.getSystemResource(""));
        System.out.println("====");
    }
}

