/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.logger.innerlog;

import com.alibaba.dts.common.logger.innerlog.LogConfigure;
import com.alibaba.dts.shade.org.apache.commons.lang.StringUtils;
import java.io.InputStream;

public class DefaultLogConfigure
extends LogConfigure {
    private static final String INNER_DEFAULT_CONF = "inner-default-logback.xml";
    private final String resource;
    private final boolean fileSystem;

    public DefaultLogConfigure(String resource) {
        this.resource = resource;
        this.fileSystem = false;
    }

    public DefaultLogConfigure(String resource, boolean fileSystem) {
        this.resource = resource;
        this.fileSystem = fileSystem;
    }

    @Override
    public InputStream configure() {
        InputStream inputStream = null;
        if (StringUtils.isNotBlank(this.resource)) {
            InputStream inputStream2 = inputStream = this.fileSystem ? DefaultLogConfigure.getResourceFromFileSystem(this.resource) : DefaultLogConfigure.getResourceFromClassPath(this.resource);
        }
        if (null == inputStream) {
            inputStream = DefaultLogConfigure.getResourceFromClassPath(INNER_DEFAULT_CONF);
        }
        return inputStream;
    }
}

