/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.domain.result;

import com.alibaba.dts.common.constants.Constants;

public enum ResultCode_EN implements Constants
{
    SUCCESS(true, 100, "success"),
    FAILURE(false, 101, "failed"),
    NO_SUCH_METHOD(false, 102, "no such method"),
    SC_FAIL_INVALID_TIMESTAMP(false, 103, "authentication failed, invalid timestamp"),
    SC_FAIL_INVALID_SIGN(false, 104, "authentication failed, invalid signature"),
    SC_FAIL_NO_PERMISSION(false, 105, "authentication failed, no permission"),
    CLIENT_VERSION_ERROR(false, 106, "authentication failed, client version error"),
    SC_FAIL_RESUOURCE_LIMIT(false, 107, "authentication failed, resource limit"),
    CREATE_INTERNAL_JOB_SUCCESS(true, 200, "create job success."),
    CREATE_INTERNAL_JOB_NEVER_FIRE(false, 201, "crontab is expired, job will never fire!"),
    CREATE_INTERNAL_JOB_INIT_FAILURE(false, 202, "timeScheduler initialize failed!"),
    CREATE_INTERNAL_JOB_PUT_FAILURE(false, 203, "timeScheduler put jobPoll failed!"),
    CREATE_PERSISTENCE_JOB_INSERT_FAILURE(false, 204, "timeScheduler persisted failed!"),
    CREATE_PERSISTENCE_JOB_SUCCESS(true, 205, "timeScheduler persisted success."),
    CREATE_JOB_IP_LIST_ERROR(false, 206, "create failed, get server list error!"),
    CREATE_JOB_BACKUP_ERROR(false, 207, "backup job failed, now job is disable, you can click enable to recover the job."),
    CREATE_JOB_ENABLE_ERROR(false, 208, "auto enable job failed, now job is disable, you can click enable to recover the job."),
    CREATE_JOB_SUCCESS(true, 209, "create job success."),
    CREATE_INTERNAL_JOB_MAPPING_FAILURE(false, 210, "create job_mapping failed!"),
    CREATE_INTERNAL_JOB_FAILURE(false, 211, "create job failed!"),
    CREATE_INTERNAL_JOB_EXISTS(false, 212, "internalJob is already exists"),
    CRON_EXPRESSION_ERROR(false, 222, "cron expression error!"),
    ARGUMENT_NULL(false, 223, "argument is null!"),
    QUERY_SERVER_GROUP_ERROR(false, 224, "query server group failed!"),
    CREARE_SUCCESS_START_FAILED(false, 225, "job create sucess, but enable failed, please re-enable!"),
    CREATE_SUCCESS_CANNOT_USE(false, 226, "job is unavailable, plase re-create!"),
    ENABLE_JOB_ERROR(false, 227, "enable job failed!"),
    ENABLE_JOB_ERROR_BAD_RETRY(false, 228, "enable job failed, please retry!"),
    DISTABLE_JOB_ERROR(false, 227, "disable job failed!"),
    DISABLE_JOB_ERROR_BAD_RETRY(false, 228, "disable job failed, please retry!"),
    UPDATE_ERROR_NEED_REDO(false, 229, "system error, plase retry!"),
    CREATE_JOB_OPERATION_ERROR(false, 230, "write database failed!"),
    QUERY_JOB_OPERATION_ERROR(false, 231, "query database failed!"),
    DELETE_JOB_OPERATION_ERROR(false, 232, "delete database failed!"),
    SYNTAX_ERROR(false, 233, "the object of dispatchTaskList must implement java.io.Serializable!"),
    CRON_EXPRESSION_OBSOLETE(false, 234, "cronExpression become obsolete"),
    DELETE_INTERNAL_JOB_SUCCESS(true, 300, "delete job from memory success."),
    DELETE_INTERNAL_JOB_IS_NULL(false, 301, "job of memory is null!"),
    DELETE_INTERNAL_JOB_FAILURE(false, 302, "delete job failed!"),
    DELETE_INTERNAL_JOB_REMOVE_FAILURE(false, 303, "delete job from memory failed!"),
    DELETE_PERSISTENCE_JOB_FAILURE(false, 304, "delete job from db failed!"),
    DELETE_PERSISTENCE_JOB_SUCCESS(true, 305, "delete job from db success!"),
    DELETE_JOB_IP_LIST_ERROR(false, 306, "delete success\uff0cbut get server list error!"),
    DELETE_JOB_SUCCESS(true, 307, "delete success"),
    DELETE_JOB_FAILURE(false, 308, "the system is busy, please retry for a while"),
    DELETE_JOB_MATION_RELATION(false, 309, "delete job_relation failed!"),
    CLUSTER_SERVER_ERROR(false, 310, "server is not started or not reach the number of backup!"),
    QUERY_CLUSTER_GROUP_ERROR(false, 311, "query cluster failed!"),
    USER_PARAMETER_ERROR(false, 312, "wrong parameter!"),
    CREATE_JOB_SERVER_RELATION_ERROR(false, 313, "create job_relation failed!"),
    PUBLISH_ZK_DATA_ERROR(false, 314, "publish zk data failed!"),
    NO_JOB_SERVER_RELATION_ERROR(false, 315, "no such job_relation!"),
    QUERY_JOB_SERVER_ERROR(false, 316, "query job_relation failed!"),
    CLIENT_MACHINE_EMPTY(false, 317, "no available client!"),
    DAUTH_ERROR(false, 318, "authentication failed using DAuth!"),
    DAUTH_DELETE_ERROR(false, 319, "delete resource failed using DAuth!"),
    REPLAY_ERROR(false, 320, "replay failed!"),
    QUERY_INTERNAL_JOB_SUCCESS(true, 400, "query job from memory success."),
    QUERY_INTERNAL_JOB_IS_NULL(false, 401, "job of memory is null!"),
    QUERY_PERSISTENCE_JOB_SUCCESS(true, 402, "query job from db success."),
    QUERY_PERSISTENCE_JOB_IS_NULL(false, 403, "job of db is null"),
    QUERY_JOB_COUNT_ERROR(false, 404, "count job of group failed!"),
    QUERY_PERSISTENCE_JOB_ERROR(false, 405, "query job failed!"),
    BEFORE_JOB_ERROR(false, 406, "parent job is failed!"),
    UPDATE_INTERNAL_JOB_SUCCESS(true, 500, "update job of memory success."),
    UPDATE_PERSISTENCE_JOB_FAILURE(false, 501, "update job of db failed!"),
    UPDATE_PERSISTENCE_JOB_SUCCESS(true, 502, "update job of db success."),
    UPDATE_INTERNAL_JOB_IS_NULL(false, 503, "update job failed, job of memory is null!"),
    UPDATE_JOB_IP_LIST_ERROR(false, 504, "update failed, get server list error!"),
    UPDATE_JOB_FAILURE(false, 505, "system is busy, please retry for a while"),
    UPDATE_JOB_SUCCESS(true, 506, "update success."),
    PULL_TASK_LIST_SUCCESS(true, 600, "pull task list success."),
    PULL_TASK_LIST_OVER(false, 601, "pull task list over."),
    PULL_TASK_GET_LOCK_FAILURE(false, 602, "get locak failed!"),
    PULL_OVER(false, 603, "pull over."),
    DISPATCH_TASK_LIST_IS_EMPTY(false, 700, "task list is empty!"),
    DISPATCH_TASK_LIST_SERVER_DOWN(false, 701, "server is down!"),
    DISPATCH_TASK_LIST_SERVER_DO_NOT_RESPONSE(false, 702, "dispatch task failed!"),
    DISPATCH_LONGTIMETASK_LIST_NOTROOT(false, 703, "longtime task can't support multi-level dispatch!"),
    DISPATCH_TASK_LIST_NAME_IS_NULL(false, 770, "task name is null!"),
    QUERY_ALL_CLUSTER_FAILURE(false, 703, "query all cluster failed!"),
    QUERY_USER_CERTAIN_GROUP_FAILURE(false, 704, "query userGroup failed!"),
    QUERY_ALL_USER_GROUP_FAILURE(false, 713, "query all userGroup failed!"),
    INSERT_USER_GROUP_FAILURE(false, 705, "create userGroup failed!"),
    DELE_GROUP_ERROR(false, 706, "delete userGroup failed!"),
    QUERY_MONITOR_ERROR(false, 707, "query monitor failed!"),
    MONITOR_NOTSET(true, 708, "monitor is not set!"),
    MONITOR_UPDATE_ERROR(false, 709, "update monitor failed!"),
    QUERY_JOB_INSTANCE_ERROR(false, 710, "query job status failed!"),
    QUERY_TASK_SNAPSHOT_PROGRESS_ERROR(false, 711, "query task_snapshot progress failed!"),
    QUERY_TASK_SNAPSHOT_DETAIL_PROGRESS_ERROR(false, 712, "query task_snapshot detail progress failed!"),
    QUERY_USER_ERROR(false, 714, "query user failed!"),
    USER_NOT_EXISTS(false, 715, "user not exists!"),
    USER_NOT_OWN_RESOURCE(false, 716, "resource is not belong to the user!"),
    CHANGE_JOB_STATUS_ERROR(false, 717, "change job status failed!"),
    CREATE_USER_GROUP_ERROR(false, 718, "create user_group_relation failed!"),
    QUERY_USER_GROUP_ERROR(false, 719, "query user_group_relation failed!"),
    DELETE_USER_GROUP_ERROR(false, 720, "delete user_group_relation failed!"),
    QUERY_JOB_RELATION_ERROR(false, 721, "query job_relation failed!"),
    CREATE_JOB_RELATION_ERROR(false, 722, "create job_relation failed"),
    DELETE_JOB_RELATION_ERROR(false, 723, "delete job_relation failed!"),
    NO_SUCH_RELATION(false, 724, "no such job_relation!"),
    NO_NEED_CALL_DEPENDENCY(false, 725, "no need call dependency!"),
    DEPENDENCE_JOB_WAIT(false, 726, "dependency job wait"),
    UPDATE_JOB_RELATION_ERROR(false, 727, "update job dependency failed!"),
    HEART_BEAT_CHECK_SUCCESS(true, 800, "I am alive !"),
    HEART_BEAT_CHECK_FAILURE(false, 801, "I am over !"),
    HEART_BEAT_CHECK_EXIT(false, 802, "I am exit !"),
    HEART_BEAT_CHECK_CRASH(false, 803, "I am crash !"),
    SET_GLOBAL_ARGUMENTS_NULL(false, 901, "argument is null"),
    SET_GLOBAL_OBJECT_TO_BYTES_FAILURE(false, 902, "set global variable failed!"),
    SET_GLOBAL_SERVER_DOWN(false, 903, "server is down!"),
    SET_GLOBAL_FAILURE(false, 904, "set global variable failed!"),
    FIRE_JOB_WORKING_FAILURE(false, 1001, "fire failed\uff0cthe job is running!"),
    FIRE_JOB_NO_CLIENT_FAILURE(false, 1002, "fire failed, no client available!"),
    FIRE_JOB_LOAD_INSTANCE_FAILURE(false, 1003, "fire failed, load instance failed!"),
    FIRE_JOB_INSTANCE_STATUS_ERROR(false, 1004, "fire failed, instance status error!"),
    FIRE_JOB_ACQUIRE_LOCK_FAILURE(false, 1005, "fire failed, acquire lock failed!"),
    FIRE_JOB_LOAD_INSTANCE_FAILURE_AFTER_LOCK(false, 1006, "fire failed, load instace failed after getting lock!"),
    FIRE_JOB_INSTANCE_STATUS_ERROR_AFTER_LOCK(false, 1007, "fire failed, instance status error after getting locak!"),
    FIRE_JOB_INIT_ROOT_TASK_ERROR(false, 1008, "fire failed, initialize root task failed!"),
    FIRE_JOB_EXECUTE_TASK_ERROR(false, 1009, "fire failed, execute task failed!"),
    SDK_IO_ERROR(false, 1003, "URL access error!"),
    CONNECT_ACCESS_FAILURE(false, 1101, "accessKey or groupId is not correct!"),
    INNER_ERROR(false, 1102, "system inner error!"),
    QUERY_DESIGNATEDMATCHINE_ERROR(false, 1110, "query designated machine failed!"),
    DELETE_DESIGNATEDMATCHINE_ERROR(false, 1111, "delete designated machine failed!"),
    INSERT__DESIGNATEDMATCHINE_ERROR(false, 1112, "insert designated machine failed!"),
    CAN_NOT_FIND_JOB_BACKUP_SERVER_LIST_ERROR(false, 1113, "can not find job backup server list"),
    PUSH_JOB_TYPE_ERROR(false, 1201, "push job type error"),
    PUSH_UNIT_MAP_IS_EMPTY_ERROR(false, 1202, "executorUnitMap is empty error"),
    PUSH_UNIT_IS_NULL_ERROR(false, 1203, "executorUnit is null error"),
    ALREADY_GRANT_ERROR(false, 1303, "already grant to this user!"),
    TASK_SEND_INTERRUPT(false, 1501, "task send interrupt!"),
    NODE_RECEIVE_QUEUE_NOT_AVAILABLE(false, 10001, "client receive queue is full!"),
    CHECK_ZK_ERROR(false, 2303, "zookeeper error"),
    CHECK_SCHEDULERX_CONSOLE_ERROR(false, 2304, "SchedulerX console error"),
    CHECK_SCHEDULERX_SERVER_ERROR(false, 2305, "SchedulerX server error"),
    NO_SUCH_ENUM(false, 9999, "no such enum!");

    private boolean success;
    private int code;
    private String information;

    private ResultCode_EN(boolean success, int code, String information) {
        this.success = success;
        this.code = code;
        this.information = information;
    }

    public String toString() {
        return this.success + " " + this.code + " " + this.information;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getInformation() {
        return this.information;
    }

    public void setInformation(String information) {
        this.information = information;
    }

    public static ResultCode_EN getResultCodeByCode(int code) {
        switch (code) {
            case 100: {
                return SUCCESS;
            }
            case 101: {
                return FAILURE;
            }
            case 102: {
                return NO_SUCH_METHOD;
            }
            case 103: {
                return SC_FAIL_INVALID_TIMESTAMP;
            }
            case 104: {
                return SC_FAIL_INVALID_SIGN;
            }
            case 105: {
                return SC_FAIL_NO_PERMISSION;
            }
            case 106: {
                return CLIENT_VERSION_ERROR;
            }
            case 200: {
                return CREATE_INTERNAL_JOB_SUCCESS;
            }
            case 201: {
                return CREATE_INTERNAL_JOB_NEVER_FIRE;
            }
            case 202: {
                return CREATE_INTERNAL_JOB_INIT_FAILURE;
            }
            case 203: {
                return CREATE_INTERNAL_JOB_PUT_FAILURE;
            }
            case 204: {
                return CREATE_PERSISTENCE_JOB_INSERT_FAILURE;
            }
            case 205: {
                return CREATE_PERSISTENCE_JOB_SUCCESS;
            }
            case 206: {
                return CREATE_JOB_IP_LIST_ERROR;
            }
            case 207: {
                return CREATE_JOB_BACKUP_ERROR;
            }
            case 208: {
                return CREATE_JOB_ENABLE_ERROR;
            }
            case 209: {
                return CREATE_JOB_SUCCESS;
            }
            case 210: {
                return CREATE_INTERNAL_JOB_MAPPING_FAILURE;
            }
            case 211: {
                return CREATE_INTERNAL_JOB_FAILURE;
            }
            case 212: {
                return CREATE_INTERNAL_JOB_EXISTS;
            }
            case 222: {
                return CRON_EXPRESSION_ERROR;
            }
            case 223: {
                return ARGUMENT_NULL;
            }
            case 224: {
                return QUERY_SERVER_GROUP_ERROR;
            }
            case 225: {
                return CREARE_SUCCESS_START_FAILED;
            }
            case 226: {
                return CREATE_SUCCESS_CANNOT_USE;
            }
            case 227: {
                return ENABLE_JOB_ERROR;
            }
            case 228: {
                return ENABLE_JOB_ERROR_BAD_RETRY;
            }
            case 229: {
                return UPDATE_ERROR_NEED_REDO;
            }
            case 230: {
                return CREATE_JOB_OPERATION_ERROR;
            }
            case 231: {
                return QUERY_JOB_OPERATION_ERROR;
            }
            case 232: {
                return DELETE_JOB_OPERATION_ERROR;
            }
            case 233: {
                return SYNTAX_ERROR;
            }
            case 234: {
                return CRON_EXPRESSION_OBSOLETE;
            }
            case 300: {
                return DELETE_INTERNAL_JOB_SUCCESS;
            }
            case 301: {
                return DELETE_INTERNAL_JOB_IS_NULL;
            }
            case 302: {
                return DELETE_INTERNAL_JOB_FAILURE;
            }
            case 303: {
                return DELETE_INTERNAL_JOB_REMOVE_FAILURE;
            }
            case 304: {
                return DELETE_PERSISTENCE_JOB_FAILURE;
            }
            case 305: {
                return DELETE_PERSISTENCE_JOB_SUCCESS;
            }
            case 306: {
                return DELETE_JOB_IP_LIST_ERROR;
            }
            case 307: {
                return DELETE_JOB_SUCCESS;
            }
            case 308: {
                return DELETE_JOB_FAILURE;
            }
            case 309: {
                return DELETE_JOB_MATION_RELATION;
            }
            case 310: {
                return CLUSTER_SERVER_ERROR;
            }
            case 311: {
                return QUERY_CLUSTER_GROUP_ERROR;
            }
            case 312: {
                return USER_PARAMETER_ERROR;
            }
            case 313: {
                return CREATE_JOB_SERVER_RELATION_ERROR;
            }
            case 314: {
                return PUBLISH_ZK_DATA_ERROR;
            }
            case 315: {
                return NO_JOB_SERVER_RELATION_ERROR;
            }
            case 316: {
                return QUERY_JOB_SERVER_ERROR;
            }
            case 317: {
                return CLIENT_MACHINE_EMPTY;
            }
            case 318: {
                return DAUTH_ERROR;
            }
            case 319: {
                return DAUTH_DELETE_ERROR;
            }
            case 320: {
                return REPLAY_ERROR;
            }
            case 400: {
                return QUERY_INTERNAL_JOB_SUCCESS;
            }
            case 401: {
                return QUERY_INTERNAL_JOB_IS_NULL;
            }
            case 402: {
                return QUERY_PERSISTENCE_JOB_SUCCESS;
            }
            case 403: {
                return QUERY_PERSISTENCE_JOB_IS_NULL;
            }
            case 404: {
                return QUERY_JOB_COUNT_ERROR;
            }
            case 405: {
                return QUERY_PERSISTENCE_JOB_ERROR;
            }
            case 406: {
                return BEFORE_JOB_ERROR;
            }
            case 500: {
                return UPDATE_INTERNAL_JOB_SUCCESS;
            }
            case 501: {
                return UPDATE_PERSISTENCE_JOB_FAILURE;
            }
            case 502: {
                return UPDATE_PERSISTENCE_JOB_SUCCESS;
            }
            case 503: {
                return UPDATE_INTERNAL_JOB_IS_NULL;
            }
            case 504: {
                return UPDATE_JOB_IP_LIST_ERROR;
            }
            case 505: {
                return UPDATE_JOB_FAILURE;
            }
            case 506: {
                return UPDATE_JOB_SUCCESS;
            }
            case 600: {
                return PULL_TASK_LIST_SUCCESS;
            }
            case 601: {
                return PULL_TASK_LIST_OVER;
            }
            case 602: {
                return PULL_TASK_GET_LOCK_FAILURE;
            }
            case 603: {
                return PULL_OVER;
            }
            case 700: {
                return DISPATCH_TASK_LIST_IS_EMPTY;
            }
            case 701: {
                return DISPATCH_TASK_LIST_SERVER_DOWN;
            }
            case 702: {
                return DISPATCH_TASK_LIST_SERVER_DO_NOT_RESPONSE;
            }
            case 703: {
                return DISPATCH_LONGTIMETASK_LIST_NOTROOT;
            }
            case 770: {
                return DISPATCH_TASK_LIST_NAME_IS_NULL;
            }
            case 704: {
                return QUERY_USER_CERTAIN_GROUP_FAILURE;
            }
            case 713: {
                return QUERY_ALL_USER_GROUP_FAILURE;
            }
            case 705: {
                return INSERT_USER_GROUP_FAILURE;
            }
            case 706: {
                return DELE_GROUP_ERROR;
            }
            case 707: {
                return QUERY_MONITOR_ERROR;
            }
            case 708: {
                return MONITOR_NOTSET;
            }
            case 709: {
                return MONITOR_UPDATE_ERROR;
            }
            case 710: {
                return QUERY_JOB_INSTANCE_ERROR;
            }
            case 711: {
                return QUERY_TASK_SNAPSHOT_PROGRESS_ERROR;
            }
            case 712: {
                return QUERY_TASK_SNAPSHOT_DETAIL_PROGRESS_ERROR;
            }
            case 714: {
                return QUERY_USER_ERROR;
            }
            case 715: {
                return USER_NOT_EXISTS;
            }
            case 716: {
                return USER_NOT_OWN_RESOURCE;
            }
            case 717: {
                return CHANGE_JOB_STATUS_ERROR;
            }
            case 718: {
                return CREATE_USER_GROUP_ERROR;
            }
            case 719: {
                return QUERY_USER_GROUP_ERROR;
            }
            case 720: {
                return DELETE_USER_GROUP_ERROR;
            }
            case 721: {
                return QUERY_JOB_RELATION_ERROR;
            }
            case 722: {
                return CREATE_JOB_RELATION_ERROR;
            }
            case 723: {
                return DELETE_JOB_RELATION_ERROR;
            }
            case 724: {
                return DELETE_JOB_RELATION_ERROR;
            }
            case 725: {
                return NO_NEED_CALL_DEPENDENCY;
            }
            case 726: {
                return DEPENDENCE_JOB_WAIT;
            }
            case 727: {
                return UPDATE_JOB_RELATION_ERROR;
            }
            case 800: {
                return HEART_BEAT_CHECK_SUCCESS;
            }
            case 801: {
                return HEART_BEAT_CHECK_FAILURE;
            }
            case 802: {
                return HEART_BEAT_CHECK_EXIT;
            }
            case 803: {
                return HEART_BEAT_CHECK_CRASH;
            }
            case 901: {
                return SET_GLOBAL_ARGUMENTS_NULL;
            }
            case 902: {
                return SET_GLOBAL_OBJECT_TO_BYTES_FAILURE;
            }
            case 903: {
                return SET_GLOBAL_SERVER_DOWN;
            }
            case 904: {
                return SET_GLOBAL_FAILURE;
            }
            case 1001: {
                return FIRE_JOB_WORKING_FAILURE;
            }
            case 1002: {
                return FIRE_JOB_NO_CLIENT_FAILURE;
            }
            case 1003: {
                return FIRE_JOB_LOAD_INSTANCE_FAILURE;
            }
            case 1004: {
                return FIRE_JOB_INSTANCE_STATUS_ERROR;
            }
            case 1005: {
                return FIRE_JOB_ACQUIRE_LOCK_FAILURE;
            }
            case 1006: {
                return FIRE_JOB_LOAD_INSTANCE_FAILURE_AFTER_LOCK;
            }
            case 1007: {
                return FIRE_JOB_INSTANCE_STATUS_ERROR_AFTER_LOCK;
            }
            case 1008: {
                return FIRE_JOB_INIT_ROOT_TASK_ERROR;
            }
            case 1009: {
                return FIRE_JOB_EXECUTE_TASK_ERROR;
            }
            case 1101: {
                return CONNECT_ACCESS_FAILURE;
            }
            case 1102: {
                return INNER_ERROR;
            }
            case 1110: {
                return QUERY_DESIGNATEDMATCHINE_ERROR;
            }
            case 111: {
                return SUCCESS;
            }
            case 1111: {
                return DELETE_DESIGNATEDMATCHINE_ERROR;
            }
            case 1112: {
                return INSERT__DESIGNATEDMATCHINE_ERROR;
            }
            case 1113: {
                return CAN_NOT_FIND_JOB_BACKUP_SERVER_LIST_ERROR;
            }
            case 1201: {
                return PUSH_JOB_TYPE_ERROR;
            }
            case 1202: {
                return PUSH_UNIT_MAP_IS_EMPTY_ERROR;
            }
            case 1203: {
                return PUSH_UNIT_IS_NULL_ERROR;
            }
            case 1303: {
                return ALREADY_GRANT_ERROR;
            }
            case 1501: {
                return TASK_SEND_INTERRUPT;
            }
            case 10001: {
                return NODE_RECEIVE_QUEUE_NOT_AVAILABLE;
            }
            case 2303: {
                return CHECK_ZK_ERROR;
            }
            case 2304: {
                return CHECK_SCHEDULERX_CONSOLE_ERROR;
            }
            case 2305: {
                return CHECK_SCHEDULERX_SERVER_ERROR;
            }
        }
        return NO_SUCH_ENUM;
    }
}

